/*
 * Decompiled with CFR 0.152.
 */
package boomerang.flowfunction;

import boomerang.BoomerangOptions;
import boomerang.flowfunction.FlowFunctionUtils;
import boomerang.flowfunction.IBackwardFlowFunction;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Field;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Method;
import boomerang.scene.Pair;
import boomerang.scene.Statement;
import boomerang.scene.StaticFieldVal;
import boomerang.scene.Val;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.Strategies;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.nodes.ExclusionNode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.NodeWithLocation;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import wpds.impl.Weight;
import wpds.interfaces.State;

public class DefaultBackwardFlowFunction
implements IBackwardFlowFunction {
    private final BoomerangOptions options;
    private Strategies<Weight> strategies;
    private BackwardBoomerangSolver solver;

    public DefaultBackwardFlowFunction(BoomerangOptions opts) {
        this.options = opts;
    }

    @Override
    public Collection<Val> returnFlow(Method callee, Statement returnStmt, Val returnedVal) {
        HashSet out = Sets.newHashSet();
        if (!callee.isStatic() && callee.getThisLocal().equals((Object)returnedVal)) {
            out.add(returnedVal);
        }
        for (Val param : callee.getParameterLocals()) {
            if (!param.equals((Object)returnedVal)) continue;
            out.add(returnedVal);
        }
        if (callee.isStatic()) {
            out.add(returnedVal);
        }
        return out;
    }

    @Override
    public Collection<Val> callFlow(Statement callSite, Val fact, Method callee, Statement calleeSp) {
        if (!callSite.containsInvokeExpr()) {
            throw new RuntimeException("Call site does not contain an invoke expression.");
        }
        InvokeExpr invokeExpr = callSite.getInvokeExpr();
        HashSet out = Sets.newHashSet();
        if (invokeExpr.isInstanceInvokeExpr() && invokeExpr.getBase().equals((Object)fact) && !callee.isStatic()) {
            out.add(callee.getThisLocal());
        }
        List parameterLocals = callee.getParameterLocals();
        int i = 0;
        for (Val arg : invokeExpr.getArgs()) {
            if (arg.equals((Object)fact) && parameterLocals.size() > i) {
                Val param = (Val)parameterLocals.get(i);
                out.add(param);
            }
            ++i;
        }
        if (callSite.isAssign() && calleeSp.isReturnStmt() && callSite.getLeftOp().equals((Object)fact)) {
            out.add(calleeSp.getReturnOp());
        }
        if (fact.isStatic()) {
            out.add(fact.withNewMethod(callee));
        }
        return out;
    }

    @Override
    public Collection<State> normalFlow(ControlFlowGraph.Edge currEdge, Val fact) {
        Statement curr = currEdge.getTarget();
        if (this.options.getAllocationVal(curr.getMethod(), curr, fact).isPresent()) {
            return Collections.emptySet();
        }
        if (curr.isThrowStmt()) {
            return Collections.emptySet();
        }
        HashSet out = Sets.newHashSet();
        boolean leftSideMatches = false;
        if (curr.isAssign()) {
            Pair arrayBase;
            Pair ifr;
            Val leftOp = curr.getLeftOp();
            Val rightOp = curr.getRightOp();
            if (leftOp.equals((Object)fact)) {
                leftSideMatches = true;
                if (curr.isFieldLoad()) {
                    if (this.options.trackFields()) {
                        ifr = curr.getFieldLoad();
                        if (!this.options.ignoreInnerClassFields() || !((Field)ifr.getY()).isInnerClassField()) {
                            out.add(new PushNode((Object)currEdge, ifr.getX(), ifr.getY(), SyncPDSSolver.PDSSystem.FIELDS));
                        }
                    }
                } else if (curr.isStaticFieldLoad()) {
                    if (this.options.trackFields()) {
                        this.strategies.getStaticFieldStrategy().handleBackward(currEdge, curr.getLeftOp(), curr.getStaticField(), out);
                    }
                } else if (rightOp.isArrayRef()) {
                    arrayBase = curr.getArrayBase();
                    if (this.options.trackFields()) {
                        this.strategies.getArrayHandlingStrategy().handleBackward(currEdge, (Pair<Val, Integer>)arrayBase, out);
                    }
                } else if (rightOp.isCast()) {
                    out.add(new Node((Object)currEdge, (Object)rightOp.getCastOp()));
                } else if (curr.isPhiStatement()) {
                    Collection phiVals = curr.getPhiVals();
                    for (Val v : phiVals) {
                        out.add(new Node((Object)currEdge, (Object)v));
                    }
                } else if (curr.isFieldLoadWithBase(fact)) {
                    out.add(new ExclusionNode((Object)currEdge, (Object)fact, (Object)curr.getLoadedField()));
                } else {
                    out.add(new Node((Object)currEdge, (Object)rightOp));
                }
            }
            if (curr.isFieldStore()) {
                ifr = curr.getFieldStore();
                Val base = (Val)ifr.getX();
                if (base.equals((Object)fact)) {
                    NodeWithLocation succNode = new NodeWithLocation((Object)currEdge, (Object)rightOp, ifr.getY());
                    out.add(new PopNode((Object)succNode, SyncPDSSolver.PDSSystem.FIELDS));
                }
            } else if (curr.isStaticFieldStore()) {
                StaticFieldVal staticField = curr.getStaticField();
                if (fact.isStatic() && fact.equals((Object)staticField)) {
                    out.add(new Node((Object)currEdge, (Object)rightOp));
                }
            } else if (leftOp.isArrayRef() && ((Val)(arrayBase = curr.getArrayBase()).getX()).equals((Object)fact)) {
                NodeWithLocation succNode = new NodeWithLocation((Object)currEdge, (Object)rightOp, (Object)Field.array((int)((Integer)arrayBase.getY())));
                out.add(new PopNode((Object)succNode, SyncPDSSolver.PDSSystem.FIELDS));
            }
        }
        if (!leftSideMatches) {
            out.add(new Node((Object)currEdge, (Object)fact));
        }
        return out;
    }

    @Override
    public Collection<State> callToReturnFlow(ControlFlowGraph.Edge edge, Val fact) {
        if (FlowFunctionUtils.isSystemArrayCopy(edge.getTarget().getInvokeExpr().getMethod())) {
            return this.systemArrayCopyFlow(edge, fact);
        }
        return this.normalFlow(edge, fact);
    }

    @Override
    public void setSolver(BackwardBoomerangSolver solver, Multimap<Field, Statement> fieldLoadStatements, Multimap<Field, Statement> fieldStoreStatements) {
        this.solver = solver;
        this.strategies = new Strategies(this.options, solver, fieldLoadStatements, fieldStoreStatements);
    }

    protected Collection<State> systemArrayCopyFlow(ControlFlowGraph.Edge edge, Val fact) {
        Statement callSite = edge.getTarget();
        if (fact.equals((Object)callSite.getInvokeExpr().getArg(2))) {
            Val arg = callSite.getInvokeExpr().getArg(0);
            return Collections.singleton(new Node((Object)edge, (Object)arg));
        }
        return Collections.emptySet();
    }
}

