/*
 * Decompiled with CFR 0.152.
 */
package boomerang;

import boomerang.BackwardQuery;
import boomerang.BoomerangOptions;
import boomerang.BoomerangTimeoutException;
import boomerang.DefaultBoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.ForwardQueryArray;
import boomerang.ForwardQueryMultiDimensionalArray;
import boomerang.Query;
import boomerang.QueryGraph;
import boomerang.SolverCreationListener;
import boomerang.WeightedForwardQuery;
import boomerang.callgraph.BackwardsObservableICFG;
import boomerang.callgraph.ObservableDynamicICFG;
import boomerang.callgraph.ObservableICFG;
import boomerang.callgraph.ObservableStaticICFG;
import boomerang.controlflowgraph.DynamicCFG;
import boomerang.controlflowgraph.ObservableControlFlowGraph;
import boomerang.controlflowgraph.PredecessorListener;
import boomerang.controlflowgraph.StaticCFG;
import boomerang.controlflowgraph.SuccessorListener;
import boomerang.debugger.Debugger;
import boomerang.poi.AbstractPOI;
import boomerang.poi.CopyAccessPathChain;
import boomerang.poi.ExecuteImportFieldStmtPOI;
import boomerang.poi.PointOfIndirection;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.scene.AllocVal;
import boomerang.scene.CallGraph;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DataFlowScope;
import boomerang.scene.Field;
import boomerang.scene.Method;
import boomerang.scene.Pair;
import boomerang.scene.Statement;
import boomerang.scene.StaticFieldVal;
import boomerang.scene.Val;
import boomerang.scene.jimple.JimpleField;
import boomerang.scene.jimple.JimpleMethod;
import boomerang.scene.jimple.JimpleStaticFieldVal;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.ControlFlowEdgeBasedFieldTransitionListener;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import boomerang.util.DefaultValueMap;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.NodeWithLocation;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.Rule;
import wpds.impl.SummaryNestedWeightedPAutomatons;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;

public abstract class WeightedBoomerang<W extends Weight> {
    protected ObservableICFG<Statement, Method> icfg;
    protected ObservableControlFlowGraph cfg;
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightedBoomerang.class);
    private Map<Map.Entry<INode<Node<ControlFlowGraph.Edge, Val>>, Field>, INode<Node<ControlFlowGraph.Edge, Val>>> genField = new HashMap<Map.Entry<INode<Node<ControlFlowGraph.Edge, Val>>, Field>, INode<Node<ControlFlowGraph.Edge, Val>>>();
    private long lastTick;
    private IBoomerangStats<W> stats;
    private Set<Method> visitedMethods = Sets.newHashSet();
    private Set<SolverCreationListener<W>> solverCreationListeners = Sets.newHashSet();
    private Multimap<SolverPair, ExecuteImportFieldStmtPOI<W>> poiListeners = HashMultimap.create();
    private Multimap<SolverPair, INode<Node<ControlFlowGraph.Edge, Val>>> activatedPoi = HashMultimap.create();
    private final DefaultValueMap<ForwardQuery, ForwardBoomerangSolver<W>> queryToSolvers = new DefaultValueMap<ForwardQuery, ForwardBoomerangSolver<W>>(){

        @Override
        protected ForwardBoomerangSolver<W> createItem(ForwardQuery key) {
            LOGGER.trace("Forward solving query: {}", (Object)key);
            WeightedBoomerang.this.forwardQueries++;
            ForwardBoomerangSolver solver = WeightedBoomerang.this.createForwardSolver(key);
            WeightedBoomerang.this.stats.registerSolver(key, solver);
            solver.getCallAutomaton().registerListener((t, w, aut) -> WeightedBoomerang.this.checkTimeout());
            solver.getFieldAutomaton().registerListener((t, w, aut) -> WeightedBoomerang.this.checkTimeout());
            WeightedBoomerang.this.onCreateSubSolver(key, solver);
            return solver;
        }
    };
    private int forwardQueries;
    private int backwardQueries;
    private final QueryGraph<W> queryGraph;
    private final DefaultValueMap<BackwardQuery, BackwardBoomerangSolver<W>> queryToBackwardSolvers = new DefaultValueMap<BackwardQuery, BackwardBoomerangSolver<W>>(){

        @Override
        protected BackwardBoomerangSolver<W> createItem(BackwardQuery key) {
            if (WeightedBoomerang.this.backwardSolverIns != null) {
                return WeightedBoomerang.this.backwardSolverIns;
            }
            BackwardBoomerangSolver backwardSolver = new BackwardBoomerangSolver<W>(WeightedBoomerang.this.bwicfg(), WeightedBoomerang.this.cfg(), WeightedBoomerang.this.genField, key, WeightedBoomerang.this.options, WeightedBoomerang.this.createCallSummaries(null, WeightedBoomerang.this.backwardCallSummaries), WeightedBoomerang.this.createFieldSummaries(null, WeightedBoomerang.this.backwardFieldSummaries), WeightedBoomerang.this.dataFlowscope, WeightedBoomerang.this.options.getBackwardFlowFunction(), WeightedBoomerang.this.callGraph.getFieldLoadStatements(), WeightedBoomerang.this.callGraph.getFieldStoreStatements(), null){

                public WeightFunctions<ControlFlowGraph.Edge, Val, Field, W> getFieldWeights() {
                    return WeightedBoomerang.this.getBackwardFieldWeights();
                }

                public WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> getCallWeights() {
                    return WeightedBoomerang.this.getBackwardCallWeights();
                }

                @Override
                protected boolean forceUnbalanced(INode<Val> node, Collection<INode<Val>> sources) {
                    return sources.contains(WeightedBoomerang.this.rootQuery) && this.callAutomaton.isUnbalancedState(node);
                }

                @Override
                protected boolean preventCallTransitionAdd(Transition<ControlFlowGraph.Edge, INode<Val>> t, W weight) {
                    WeightedBoomerang.this.checkTimeout();
                    return super.preventCallTransitionAdd(t, weight);
                }

                @Override
                protected boolean preventFieldTransitionAdd(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W weight) {
                    WeightedBoomerang.this.checkTimeout();
                    return super.preventFieldTransitionAdd(t, weight);
                }
            };
            backwardSolver.registerListener(node -> {
                Optional<AllocVal> allocNode = WeightedBoomerang.this.isAllocationNode((ControlFlowGraph.Edge)node.stmt(), (Val)node.fact());
                if (allocNode.isPresent() || ((ControlFlowGraph.Edge)node.stmt()).getTarget().isArrayLoad() || ((ControlFlowGraph.Edge)node.stmt()).getTarget().isFieldLoad()) {
                    backwardSolver.getFieldAutomaton().registerListener((WPAStateListener)new EmptyFieldListener(key, (Node<ControlFlowGraph.Edge, Val>)node));
                }
                WeightedBoomerang.this.addVisitedMethod(((ControlFlowGraph.Edge)node.stmt()).getStart().getMethod());
                WeightedBoomerang.this.handleMapsBackward((Node<ControlFlowGraph.Edge, Val>)node);
                if (WeightedBoomerang.this.options.trackStaticFieldAtEntryPointToClinit()) {
                    WeightedBoomerang.this.handleStaticInitializer((Node<ControlFlowGraph.Edge, Val>)node, backwardSolver);
                }
            });
            WeightedBoomerang.this.backwardSolverIns = backwardSolver;
            return backwardSolver;
        }
    };
    private static final String MAP_PUT_SUB_SIGNATURE = "java.util.Map: java.lang.Object put(";
    private static final String MAP_GET_SUB_SIGNATURE = "java.util.Map: java.lang.Object get(";
    private BackwardBoomerangSolver<W> backwardSolverIns;
    private boolean solving;
    private ObservableICFG<Statement, Method> bwicfg;
    private NestedWeightedPAutomatons<ControlFlowGraph.Edge, INode<Val>, W> backwardCallSummaries = new SummaryNestedWeightedPAutomatons();
    private NestedWeightedPAutomatons<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> backwardFieldSummaries = new SummaryNestedWeightedPAutomatons();
    private NestedWeightedPAutomatons<ControlFlowGraph.Edge, INode<Val>, W> forwardCallSummaries = new SummaryNestedWeightedPAutomatons();
    private NestedWeightedPAutomatons<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> forwardFieldSummaries = new SummaryNestedWeightedPAutomatons();
    private DefaultValueMap<FieldWritePOI, FieldWritePOI> fieldWrites = new DefaultValueMap<FieldWritePOI, FieldWritePOI>(){

        @Override
        protected FieldWritePOI createItem(FieldWritePOI key) {
            WeightedBoomerang.this.stats.registerFieldWritePOI(key);
            return key;
        }
    };
    protected final BoomerangOptions options;
    private Stopwatch analysisWatch = Stopwatch.createUnstarted();
    private final DataFlowScope dataFlowscope;
    private CallGraph callGraph;
    private INode<Val> rootQuery;

    private void handleStaticInitializer(final Node<ControlFlowGraph.Edge, Val> node, final BackwardBoomerangSolver<W> backwardSolver) {
        Val fact;
        if (this.options.trackStaticFieldAtEntryPointToClinit() && ((Val)node.fact()).isStatic() && this.isFirstStatementOfEntryPoint(((ControlFlowGraph.Edge)node.stmt()).getStart()) && (fact = (Val)node.fact()) instanceof JimpleStaticFieldVal) {
            JimpleStaticFieldVal val = (JimpleStaticFieldVal)fact;
            for (SootMethod m : ((JimpleField)val.field()).getSootField().getDeclaringClass().getMethods()) {
                if (!m.hasActiveBody()) continue;
                JimpleMethod jimpleMethod = JimpleMethod.of((SootMethod)m);
                if (!m.isStaticInitializer()) continue;
                for (final Statement ep : this.icfg().getEndPointsOf((Method)JimpleMethod.of((SootMethod)m))) {
                    JimpleStaticFieldVal newVal = new JimpleStaticFieldVal((JimpleField)val.field(), (Method)jimpleMethod);
                    this.cfg.addPredsOfListener(new PredecessorListener(ep, (StaticFieldVal)newVal){
                        final /* synthetic */ StaticFieldVal val$newVal;
                        {
                            this.val$newVal = staticFieldVal;
                            super(curr);
                        }

                        @Override
                        public void getPredecessor(Statement pred) {
                            backwardSolver.addNormalCallFlow(node, new Node((Object)new ControlFlowGraph.Edge(pred, ep), (Object)this.val$newVal));
                            backwardSolver.addNormalFieldFlow(node, new Node((Object)new ControlFlowGraph.Edge(pred, ep), (Object)this.val$newVal));
                        }
                    });
                }
            }
        }
    }

    protected boolean isFirstStatementOfEntryPoint(Statement stmt) {
        return this.callGraph.getEntryPoints().contains(stmt.getMethod()) && stmt.getMethod().getControlFlowGraph().getStartPoints().contains(stmt);
    }

    protected void handleMapsBackward(final Node<ControlFlowGraph.Edge, Val> node) {
        final Statement rstmt = ((ControlFlowGraph.Edge)node.stmt()).getStart();
        if (rstmt.isAssign() && rstmt.containsInvokeExpr() && rstmt.getInvokeExpr().toString().contains(MAP_GET_SUB_SIGNATURE) && rstmt.getLeftOp().equals(node.fact())) {
            this.cfg.addPredsOfListener(new PredecessorListener(rstmt){

                @Override
                public void getPredecessor(Statement pred) {
                    BackwardQuery bwq = BackwardQuery.make(new ControlFlowGraph.Edge(pred, rstmt), rstmt.getInvokeExpr().getArg(0));
                    WeightedBoomerang.this.backwardSolve(bwq);
                    for (ForwardQuery q : Lists.newArrayList(WeightedBoomerang.this.queryToSolvers.keySet())) {
                        Val var;
                        AllocVal v;
                        if (!((ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get(q))).getReachedStates().contains(bwq.asNode()) || !(v = (AllocVal)(var = q.var())).getAllocVal().isStringConstant()) continue;
                        String key = v.getAllocVal().getStringValue();
                        WeightedBoomerang.this.backwardSolverIns.propagate(node, (State)new PushNode((Object)new ControlFlowGraph.Edge(pred, rstmt), (Object)rstmt.getInvokeExpr().getBase(), (Object)Field.string((String)key), SyncPDSSolver.PDSSystem.FIELDS));
                    }
                }
            });
        }
        if (rstmt.containsInvokeExpr() && rstmt.getInvokeExpr().toString().contains(MAP_PUT_SUB_SIGNATURE) && rstmt.getInvokeExpr().getBase().equals(node.fact())) {
            this.cfg.addPredsOfListener(new PredecessorListener(rstmt){

                @Override
                public void getPredecessor(Statement pred) {
                    BackwardQuery bwq = BackwardQuery.make(new ControlFlowGraph.Edge(pred, rstmt), rstmt.getInvokeExpr().getArg(0));
                    WeightedBoomerang.this.backwardSolve(bwq);
                    for (ForwardQuery q : Lists.newArrayList(WeightedBoomerang.this.queryToSolvers.keySet())) {
                        Val var;
                        AllocVal v;
                        if (!((ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get(q))).getReachedStates().contains(bwq.asNode()) || !(v = (AllocVal)(var = q.var())).getAllocVal().isStringConstant()) continue;
                        String key = v.getAllocVal().getStringValue();
                        NodeWithLocation succNode = new NodeWithLocation((Object)new ControlFlowGraph.Edge(pred, rstmt), (Object)rstmt.getInvokeExpr().getArg(1), (Object)Field.string((String)key));
                        WeightedBoomerang.this.backwardSolverIns.propagate(node, (State)new PopNode((Object)succNode, SyncPDSSolver.PDSSystem.FIELDS));
                    }
                }
            });
        }
    }

    protected void handleMapsForward(final ForwardBoomerangSolver<W> solver, final Node<ControlFlowGraph.Edge, Val> node) {
        final Statement rstmt = ((ControlFlowGraph.Edge)node.stmt()).getTarget();
        if (rstmt.containsInvokeExpr()) {
            BackwardQuery bwq;
            if (rstmt.isAssign() && rstmt.getInvokeExpr().toString().contains(MAP_GET_SUB_SIGNATURE) && rstmt.getInvokeExpr().getBase().equals(node.fact())) {
                bwq = BackwardQuery.make((ControlFlowGraph.Edge)node.stmt(), rstmt.getInvokeExpr().getArg(0));
                this.backwardSolve(bwq);
                this.cfg.addSuccsOfListener(new SuccessorListener(rstmt){

                    @Override
                    public void getSuccessor(Statement succ) {
                        for (ForwardQuery q : Lists.newArrayList(WeightedBoomerang.this.queryToSolvers.keySet())) {
                            Val var;
                            AllocVal v;
                            if (!((ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get(q))).getReachedStates().contains(bwq.asNode()) || !(v = (AllocVal)(var = q.var())).getAllocVal().isStringConstant()) continue;
                            String key = v.getAllocVal().getStringValue();
                            NodeWithLocation succNode = new NodeWithLocation((Object)new ControlFlowGraph.Edge(rstmt, succ), (Object)rstmt.getLeftOp(), (Object)Field.string((String)key));
                            solver.propagate(node, (State)new PopNode((Object)succNode, SyncPDSSolver.PDSSystem.FIELDS));
                        }
                    }
                });
            }
            if (rstmt.getInvokeExpr().toString().contains(MAP_PUT_SUB_SIGNATURE) && rstmt.getInvokeExpr().getArg(1).equals(node.fact())) {
                bwq = BackwardQuery.make((ControlFlowGraph.Edge)node.stmt(), rstmt.getInvokeExpr().getArg(0));
                this.backwardSolve(bwq);
                this.cfg.addSuccsOfListener(new SuccessorListener(rstmt){

                    @Override
                    public void getSuccessor(Statement succ) {
                        for (ForwardQuery q : Lists.newArrayList(WeightedBoomerang.this.queryToSolvers.keySet())) {
                            Val var;
                            AllocVal v;
                            if (!((ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get(q))).getReachedStates().contains(bwq.asNode()) || !(v = (AllocVal)(var = q.var())).getAllocVal().isStringConstant()) continue;
                            String key = v.getAllocVal().getStringValue();
                            solver.propagate(node, (State)new PushNode((Object)new ControlFlowGraph.Edge(rstmt, succ), (Object)rstmt.getInvokeExpr().getBase(), (Object)Field.string((String)key), SyncPDSSolver.PDSSystem.FIELDS));
                        }
                    }
                });
            }
        }
    }

    public void checkTimeout() {
        if (this.options.analysisTimeoutMS() > 0) {
            long elapsed = this.analysisWatch.elapsed(TimeUnit.MILLISECONDS);
            if (elapsed - this.lastTick > 15000L) {
                LOGGER.debug("Elapsed Time: {}/{}, Visited Methods {}", new Object[]{elapsed, this.options.analysisTimeoutMS(), this.visitedMethods.size()});
                LOGGER.debug("Forward / Backward Queries: {}/{}", (Object)this.forwardQueries, (Object)this.backwardQueries);
                if (LOGGER.isDebugEnabled()) {
                    this.printElapsedTimes();
                    this.printRules();
                    this.printStats();
                }
                this.lastTick = elapsed;
            }
            if ((long)this.options.analysisTimeoutMS() < elapsed) {
                if (this.analysisWatch.isRunning()) {
                    this.analysisWatch.stop();
                }
                throw new BoomerangTimeoutException(elapsed, this.stats);
            }
        }
    }

    public WeightedBoomerang(CallGraph cg, DataFlowScope scope, BoomerangOptions options) {
        this.options = options;
        this.options.checkValid();
        this.stats = options.statsFactory();
        this.dataFlowscope = scope;
        this.cfg = options.onTheFlyControlFlow() ? new DynamicCFG() : new StaticCFG();
        this.icfg = options.onTheFlyCallGraph() ? new ObservableDynamicICFG(this.cfg, options.getResolutionStrategy().newInstance(this, cg)) : new ObservableStaticICFG(cg);
        this.callGraph = cg;
        this.queryGraph = new QueryGraph(this);
    }

    public WeightedBoomerang(CallGraph cg, DataFlowScope scope) {
        this(cg, scope, new DefaultBoomerangOptions());
    }

    protected void addVisitedMethod(Method method) {
        if (!this.dataFlowscope.isExcluded(method) && this.visitedMethods.add(method)) {
            LOGGER.trace("Reach Method: {}", (Object)method);
        }
    }

    protected Optional<AllocVal> isAllocationNode(ControlFlowGraph.Edge s, Val fact) {
        return this.options.getAllocationVal(s.getStart().getMethod(), s.getStart(), fact);
    }

    protected ForwardBoomerangSolver<W> createForwardSolver(final ForwardQuery sourceQuery) {
        ForwardBoomerangSolver solver = new ForwardBoomerangSolver<W>(this.icfg(), this.cfg(), sourceQuery, this.genField, this.options, this.createCallSummaries(sourceQuery, this.forwardCallSummaries), this.createFieldSummaries(sourceQuery, this.forwardFieldSummaries), this.dataFlowscope, this.options.getForwardFlowFunctions(), this.callGraph.getFieldLoadStatements(), this.callGraph.getFieldStoreStatements(), sourceQuery.getType()){

            public WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> getCallWeights() {
                return WeightedBoomerang.this.getForwardCallWeights(sourceQuery);
            }

            public WeightFunctions<ControlFlowGraph.Edge, Val, Field, W> getFieldWeights() {
                return WeightedBoomerang.this.getForwardFieldWeights();
            }

            @Override
            public void addCallRule(Rule<ControlFlowGraph.Edge, INode<Val>, W> rule) {
                if (WeightedBoomerang.this.preventCallRuleAdd(sourceQuery, rule)) {
                    return;
                }
                super.addCallRule(rule);
            }

            @Override
            protected boolean forceUnbalanced(INode<Val> node, Collection<INode<Val>> sources) {
                return WeightedBoomerang.this.queryGraph.isRoot(sourceQuery);
            }

            @Override
            protected void overwriteFieldAtStatement(ControlFlowGraph.Edge fieldWriteStatement, Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> killedTransition) {
                BackwardQuery backwardQuery = BackwardQuery.make((ControlFlowGraph.Edge)((Node)((INode)killedTransition.getTarget()).fact()).stmt(), fieldWriteStatement.getTarget().getRightOp());
                CopyAccessPathChain copyAccessPathChain = new CopyAccessPathChain((ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get(sourceQuery)), (BackwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToBackwardSolvers.getOrCreate(backwardQuery)), fieldWriteStatement, killedTransition);
                copyAccessPathChain.exec();
                WeightedBoomerang.this.queryGraph.addEdge(sourceQuery, (Node<ControlFlowGraph.Edge, Val>)((Node)((INode)killedTransition.getStart()).fact()), backwardQuery);
            }

            @Override
            protected boolean preventCallTransitionAdd(Transition<ControlFlowGraph.Edge, INode<Val>> t, W weight) {
                WeightedBoomerang.this.checkTimeout();
                return super.preventCallTransitionAdd(t, weight);
            }

            @Override
            protected boolean preventFieldTransitionAdd(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W weight) {
                WeightedBoomerang.this.checkTimeout();
                return super.preventFieldTransitionAdd(t, weight);
            }
        };
        solver.registerListener(node -> {
            if (((ControlFlowGraph.Edge)node.stmt()).getStart().isFieldStore()) {
                this.forwardHandleFieldWrite((Node<ControlFlowGraph.Edge, Val>)node, this.createFieldStore((ControlFlowGraph.Edge)node.stmt()), sourceQuery);
            } else if (this.options.getArrayStrategy() != BoomerangOptions.ArrayStrategy.DISABLED && ((ControlFlowGraph.Edge)node.stmt()).getStart().isArrayStore()) {
                this.forwardHandleFieldWrite((Node<ControlFlowGraph.Edge, Val>)node, this.createArrayFieldStore((ControlFlowGraph.Edge)node.stmt()), sourceQuery);
            }
            this.addVisitedMethod(((ControlFlowGraph.Edge)node.stmt()).getStart().getMethod());
            this.handleMapsForward(solver, (Node<ControlFlowGraph.Edge, Val>)node);
        });
        return solver;
    }

    private NestedWeightedPAutomatons<ControlFlowGraph.Edge, INode<Val>, W> createCallSummaries(final ForwardQuery sourceQuery, final NestedWeightedPAutomatons<ControlFlowGraph.Edge, INode<Val>, W> summaries) {
        return new NestedWeightedPAutomatons<ControlFlowGraph.Edge, INode<Val>, W>(){

            public void putSummaryAutomaton(INode<Val> target, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> aut) {
                summaries.putSummaryAutomaton(target, aut);
            }

            public WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> getSummaryAutomaton(INode<Val> target) {
                if (sourceQuery.var() instanceof AllocVal) {
                    AllocVal allocVal = (AllocVal)sourceQuery.var();
                    Val f = ((Val)target.fact()).isUnbalanced() ? ((Val)target.fact()).asUnbalanced(null) : (Val)target.fact();
                    if (f.equals((Object)allocVal.getDelegate())) {
                        return ((ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.getOrCreate(sourceQuery))).getCallAutomaton();
                    }
                }
                return summaries.getSummaryAutomaton(target);
            }
        };
    }

    private NestedWeightedPAutomatons<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> createFieldSummaries(final ForwardQuery sourceQuery, final NestedWeightedPAutomatons<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> summaries) {
        return new NestedWeightedPAutomatons<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W>(){

            public void putSummaryAutomaton(INode<Node<ControlFlowGraph.Edge, Val>> target, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> aut) {
                summaries.putSummaryAutomaton(target, aut);
            }

            public WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> getSummaryAutomaton(INode<Node<ControlFlowGraph.Edge, Val>> target) {
                if (((Node)target.fact()).equals(sourceQuery.asNode())) {
                    return ((ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.getOrCreate(sourceQuery))).getFieldAutomaton();
                }
                return summaries.getSummaryAutomaton(target);
            }
        };
    }

    public boolean preventCallRuleAdd(ForwardQuery sourceQuery, Rule<ControlFlowGraph.Edge, INode<Val>, W> rule) {
        return false;
    }

    protected FieldWritePOI createArrayFieldStore(ControlFlowGraph.Edge s) {
        Pair base = s.getStart().getArrayBase();
        return this.fieldWrites.getOrCreate(new FieldWritePOI(s, (Val)base.getX(), Field.array((int)((Integer)base.getY())), s.getStart().getRightOp()));
    }

    protected FieldWritePOI createFieldStore(ControlFlowGraph.Edge cfgEdge) {
        Statement s = cfgEdge.getStart();
        Val base = (Val)s.getFieldStore().getX();
        Field field = (Field)s.getFieldStore().getY();
        Val stored = s.getRightOp();
        return this.fieldWrites.getOrCreate(new FieldWritePOI(cfgEdge, base, field, stored));
    }

    protected void forwardHandleFieldWrite(Node<ControlFlowGraph.Edge, Val> node, FieldWritePOI fieldWritePoi, ForwardQuery sourceQuery) {
        BackwardQuery backwardQuery = BackwardQuery.make((ControlFlowGraph.Edge)node.stmt(), (Val)fieldWritePoi.getBaseVar());
        if (((Val)node.fact()).equals(fieldWritePoi.getStoredVar())) {
            this.backwardSolve(backwardQuery);
            this.queryGraph.addEdge(sourceQuery, node, backwardQuery);
            this.queryToSolvers.get(sourceQuery).registerStatementFieldTransitionListener(new ForwardHandleFieldWrite(sourceQuery, fieldWritePoi, (ControlFlowGraph.Edge)node.stmt()));
        }
        if (((Val)node.fact()).equals(fieldWritePoi.getBaseVar())) {
            this.queryToSolvers.getOrCreate(sourceQuery).getFieldAutomaton().registerListener((WPAStateListener)new TriggerBaseAllocationAtFieldWrite((INode<Node<ControlFlowGraph.Edge, Val>>)new SingleNode(node), fieldWritePoi, sourceQuery));
        }
    }

    public void unregisterAllListeners() {
        for (AbstractBoomerangSolver abstractBoomerangSolver : this.queryToSolvers.values()) {
            abstractBoomerangSolver.unregisterAllListeners();
        }
        for (AbstractBoomerangSolver abstractBoomerangSolver : this.queryToBackwardSolvers.values()) {
            abstractBoomerangSolver.unregisterAllListeners();
        }
        this.cfg.unregisterAllListeners();
        this.queryGraph.unregisterAllListeners();
        this.poiListeners.clear();
        this.activatedPoi.clear();
        this.fieldWrites.clear();
    }

    public DefaultValueMap<BackwardQuery, BackwardBoomerangSolver<W>> getBackwardSolvers() {
        return this.queryToBackwardSolvers;
    }

    public QueryGraph<W> getQueryGraph() {
        return this.queryGraph;
    }

    private boolean isAllocationNode(Val fact, ForwardQuery sourceQuery) {
        return fact.equals((Object)sourceQuery.var().asUnbalanced(sourceQuery.cfgEdge()));
    }

    private ObservableICFG<Statement, Method> bwicfg() {
        if (this.bwicfg == null) {
            this.bwicfg = new BackwardsObservableICFG(this.icfg());
        }
        return this.bwicfg;
    }

    public ForwardBoomerangResults<W> solve(ForwardQuery query) {
        if (!this.options.allowMultipleQueries() && this.solving) {
            throw new RuntimeException("One cannot re-use the same Boomerang solver for more than one query, unless option allowMultipleQueries is enabled. If allowMultipleQueries is enabled, ensure to call unregisterAllListeners() on this instance upon termination of all queries.");
        }
        this.solving = true;
        if (!this.analysisWatch.isRunning()) {
            this.analysisWatch.start();
        }
        boolean timedout = false;
        try {
            this.queryGraph.addRoot(query);
            LOGGER.trace("Starting forward analysis of: {}", (Object)query);
            this.forwardSolve(query);
            LOGGER.trace("Query terminated in {} ({}), visited methods {}", new Object[]{this.analysisWatch, query, this.visitedMethods.size()});
            LOGGER.trace("Query Graph \n{}", (Object)this.queryGraph.toDotString());
            this.icfg.computeFallback();
        }
        catch (BoomerangTimeoutException e) {
            timedout = true;
            LOGGER.trace("Timeout ({}) of query: {}, visited methods {}", new Object[]{this.analysisWatch, query, this.visitedMethods.size()});
        }
        catch (Throwable e) {
            LOGGER.error("Solving query crashed in {}", e);
        }
        if (!this.options.allowMultipleQueries()) {
            this.unregisterAllListeners();
        }
        if (this.analysisWatch.isRunning()) {
            this.analysisWatch.stop();
        }
        return new ForwardBoomerangResults<W>(query, this.icfg(), this.cfg(), timedout, this.queryToSolvers, this.getStats(), this.analysisWatch, this.visitedMethods, this.options.trackDataFlowPath(), this.options.prunePathConditions(), this.options.trackImplicitFlows());
    }

    public BackwardBoomerangResults<W> solve(BackwardQuery query) {
        return this.solve(query, true);
    }

    public BackwardBoomerangResults<W> solve(BackwardQuery query, boolean timing) {
        if (!this.options.allowMultipleQueries() && this.solving) {
            throw new RuntimeException("One cannot re-use the same Boomerang solver for more than one query, unless option allowMultipleQueries is enabled. If allowMultipleQueries is enabled, ensure to call unregisterAllListeners() on this instance upon termination of all queries.");
        }
        this.solving = true;
        if (timing && !this.analysisWatch.isRunning()) {
            this.analysisWatch.start();
        }
        boolean timedout = false;
        try {
            this.queryGraph.addRoot(query);
            LOGGER.trace("Starting backward analysis of: {}", (Object)query);
            this.backwardSolve(query);
        }
        catch (BoomerangTimeoutException e) {
            timedout = true;
            LOGGER.trace("Timeout ({}) of query: {} ", (Object)this.analysisWatch, (Object)query);
        }
        this.debugOutput();
        if (!this.options.allowMultipleQueries()) {
            this.unregisterAllListeners();
        }
        if (timing && this.analysisWatch.isRunning()) {
            this.analysisWatch.stop();
        }
        return new BackwardBoomerangResults<W>(query, timedout, this.queryToSolvers, this.backwardSolverIns, this.getStats(), this.analysisWatch);
    }

    public BackwardBoomerangResults<W> solveUnderScope(BackwardQuery query, Node<ControlFlowGraph.Edge, Val> triggeringNode, Query parentQuery) {
        if (!this.options.allowMultipleQueries() && this.solving) {
            throw new RuntimeException("One cannot re-use the same Boomerang solver for more than one query, unless option allowMultipleQueries is enabled. If allowMultipleQueries is enabled, ensure to call unregisterAllListeners() on this instance upon termination of all queries.");
        }
        this.solving = true;
        if (!this.analysisWatch.isRunning()) {
            this.analysisWatch.start();
        }
        boolean timedout = false;
        try {
            LOGGER.trace("Starting backward analysis of: {}", (Object)query);
            this.backwardSolve(query);
            this.queryGraph.addEdge(parentQuery, triggeringNode, query);
            this.debugOutput();
        }
        catch (BoomerangTimeoutException e) {
            timedout = true;
            LOGGER.trace("Timeout ({}) of query: {} ", (Object)this.analysisWatch, (Object)query);
        }
        if (this.analysisWatch.isRunning()) {
            this.analysisWatch.stop();
        }
        return new BackwardBoomerangResults<W>(query, timedout, this.queryToSolvers, this.backwardSolverIns, this.getStats(), this.analysisWatch);
    }

    public ForwardBoomerangResults<W> solveUnderScope(ForwardQuery query, Node<ControlFlowGraph.Edge, Val> triggeringNode, Query parentQuery) {
        if (!this.options.allowMultipleQueries() && this.solving) {
            throw new RuntimeException("One cannot re-use the same Boomerang solver for more than one query, unless option allowMultipleQueries is enabled. If allowMultipleQueries is enabled, ensure to call unregisterAllListeners() on this instance upon termination of all queries.");
        }
        this.solving = true;
        if (!this.analysisWatch.isRunning()) {
            this.analysisWatch.start();
        }
        boolean timedout = false;
        try {
            LOGGER.trace("Starting forward analysis of: {}", (Object)query);
            this.forwardSolve(query);
            this.queryGraph.addEdge(parentQuery, triggeringNode, query);
            LOGGER.trace("Query terminated in {} ({}), visited methods {}", new Object[]{this.analysisWatch, query, this.visitedMethods.size()});
        }
        catch (BoomerangTimeoutException e) {
            timedout = true;
            LOGGER.trace("Timeout ({}) of query: {}, visited methods {}", new Object[]{this.analysisWatch, query, this.visitedMethods.size()});
        }
        catch (Throwable e) {
            LOGGER.error("Solving query crashed in {}", e);
        }
        if (!this.options.allowMultipleQueries()) {
            this.unregisterAllListeners();
        }
        if (this.analysisWatch.isRunning()) {
            this.analysisWatch.stop();
        }
        return new ForwardBoomerangResults<W>(query, this.icfg(), this.cfg(), timedout, this.queryToSolvers, this.getStats(), this.analysisWatch, this.visitedMethods, this.options.trackDataFlowPath(), this.options.prunePathConditions(), this.options.trackImplicitFlows());
    }

    public void debugOutput() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Query Graph \n{}", (Object)this.queryGraph.toDotString());
            LOGGER.trace("#ForwardSolvers: {}", (Object)this.queryToSolvers.size());
            this.printAllAutomata();
            this.printAllForwardCallAutomatonFlow();
            this.printAllBackwardCallAutomatonFlow();
        }
    }

    protected void backwardSolve(BackwardQuery query) {
        if (!this.options.aliasing()) {
            return;
        }
        AbstractBoomerangSolver solver = this.queryToBackwardSolvers.getOrCreate(query);
        INode<Node<ControlFlowGraph.Edge, Val>> fieldTarget = solver.createQueryNodeField(query);
        INode callTarget = solver.generateCallState((INode)new SingleNode((Object)query.var()), (Location)query.cfgEdge());
        if (this.rootQuery == null) {
            this.rootQuery = callTarget;
        }
        solver.solve(query.asNode(), (Location)Field.empty(), fieldTarget, (Location)query.cfgEdge(), callTarget);
    }

    private AbstractBoomerangSolver<W> forwardSolve(ForwardQuery query) {
        Val var;
        Field field;
        ControlFlowGraph.Edge cfgEdge = (ControlFlowGraph.Edge)query.asNode().stmt();
        AbstractBoomerangSolver solver = this.queryToSolvers.getOrCreate(query);
        INode<Node<ControlFlowGraph.Edge, Val>> fieldTarget = solver.createQueryNodeField(query);
        INode callTarget = solver.generateCallState((INode)new SingleNode((Object)query.var()), (Location)query.cfgEdge());
        Statement stmt = cfgEdge.getStart();
        if (!stmt.isFieldStore() && query instanceof ForwardQueryArray && this.options.getArrayStrategy() != BoomerangOptions.ArrayStrategy.DISABLED) {
            Node node;
            ForwardQueryArray arrayQuery;
            if (query instanceof ForwardQueryMultiDimensionalArray) {
                arrayQuery = (ForwardQueryMultiDimensionalArray)query;
                node = new Node((Object)query.cfgEdge(), (Object)((AllocVal)query.var()).getDelegate());
                SingleNode sourveVal = new SingleNode((Object)node);
                INode<Node<ControlFlowGraph.Edge, Val>> genState1 = solver.generateFieldState((INode<Node<ControlFlowGraph.Edge, Val>>)sourveVal, Field.array((int)((ForwardQueryMultiDimensionalArray)arrayQuery).getIndex1()));
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)new Transition((State)sourveVal, (Location)Field.array((int)((ForwardQueryMultiDimensionalArray)arrayQuery).getIndex1()), genState1));
                INode<Node<ControlFlowGraph.Edge, Val>> genState2 = solver.generateFieldState((INode<Node<ControlFlowGraph.Edge, Val>>)sourveVal, Field.array((int)((ForwardQueryMultiDimensionalArray)arrayQuery).getIndex2()));
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)new Transition(genState1, (Location)Field.array((int)((ForwardQueryMultiDimensionalArray)arrayQuery).getIndex2()), genState2));
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)new Transition(genState2, (Location)Field.empty(), fieldTarget));
            } else {
                arrayQuery = (ForwardQueryArray)query;
                node = new Node((Object)query.cfgEdge(), (Object)((AllocVal)query.var()).getDelegate());
                SingleNode sourceVal = new SingleNode((Object)node);
                INode<Node<ControlFlowGraph.Edge, Val>> genState = solver.generateFieldState((INode<Node<ControlFlowGraph.Edge, Val>>)sourceVal, Field.array((int)arrayQuery.getIndex()));
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)new Transition((State)sourceVal, (Location)Field.array((int)arrayQuery.getIndex()), genState));
                this.insertTransition(solver.getFieldAutomaton(), (Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)new Transition(genState, (Location)Field.empty(), fieldTarget));
            }
        }
        if (stmt.isStringAllocation()) {
            // empty if block
        }
        if (stmt.isFieldStore()) {
            field = (Field)stmt.getFieldStore().getY();
            var = (Val)stmt.getFieldStore().getX();
            this.forwardHandleFieldWrite((Node<ControlFlowGraph.Edge, Val>)new Node((Object)cfgEdge, (Object)stmt.getRightOp()), new FieldWritePOI(cfgEdge, var, field, stmt.getRightOp()), query);
        } else {
            var = ((AllocVal)query.var()).getDelegate();
            field = Field.empty();
        }
        if (query instanceof WeightedForwardQuery) {
            WeightedForwardQuery q = (WeightedForwardQuery)query;
            solver.solve(new Node((Object)cfgEdge, (Object)var), (Location)field, (INode)fieldTarget, (Location)cfgEdge, callTarget, (Weight)q.weight());
        } else {
            solver.solve(new Node((Object)cfgEdge, (Object)var), (Location)field, fieldTarget, (Location)cfgEdge, callTarget);
        }
        return solver;
    }

    private boolean insertTransition(WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> aut, Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> transition) {
        if (!aut.nested()) {
            return aut.addTransition(transition);
        }
        INode target = (INode)transition.getTarget();
        if (!(target instanceof GeneratedState)) {
            this.forwardFieldSummaries.putSummaryAutomaton((State)target, aut);
            aut.registerListener((t, w, aut12) -> {
                if (t.getStart() instanceof GeneratedState) {
                    WeightedPAutomaton n = this.forwardFieldSummaries.getSummaryAutomaton(t.getStart());
                    aut12.addNestedAutomaton(n);
                }
            });
            return aut.addTransition(transition);
        }
        WeightedPAutomaton nested = this.forwardFieldSummaries.getSummaryAutomaton((State)target);
        nested.registerListener((t, w, aut1) -> {
            if (t.getStart() instanceof GeneratedState) {
                WeightedPAutomaton n = this.forwardFieldSummaries.getSummaryAutomaton(t.getStart());
                aut1.addNestedAutomaton(n);
            }
        });
        return nested.addTransition(transition);
    }

    protected void activateAllPois(SolverPair pair, INode<Node<ControlFlowGraph.Edge, Val>> start) {
        if (this.activatedPoi.put((Object)pair, start)) {
            Collection listeners = this.poiListeners.get((Object)pair);
            for (ExecuteImportFieldStmtPOI l : Lists.newArrayList((Iterable)listeners)) {
                l.trigger(start);
            }
        }
    }

    public void registerActivationListener(SolverPair solverPair, ExecuteImportFieldStmtPOI<W> exec) {
        Collection listeners = this.activatedPoi.get((Object)solverPair);
        for (INode node : Lists.newArrayList((Iterable)listeners)) {
            exec.trigger((INode<Node<ControlFlowGraph.Edge, Val>>)node);
        }
        this.poiListeners.put((Object)solverPair, exec);
    }

    public ObservableICFG<Statement, Method> icfg() {
        return this.icfg;
    }

    public ObservableControlFlowGraph cfg() {
        return this.cfg;
    }

    protected abstract WeightFunctions<ControlFlowGraph.Edge, Val, Field, W> getForwardFieldWeights();

    protected abstract WeightFunctions<ControlFlowGraph.Edge, Val, Field, W> getBackwardFieldWeights();

    protected abstract WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> getBackwardCallWeights();

    protected abstract WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> getForwardCallWeights(ForwardQuery var1);

    public DefaultValueMap<ForwardQuery, ForwardBoomerangSolver<W>> getSolvers() {
        return this.queryToSolvers;
    }

    public void debugOutput(Debugger<W> debugger) {
        debugger.done(this.icfg, this.cfg, this.visitedMethods, this.queryToSolvers);
    }

    public IBoomerangStats<W> getStats() {
        return this.stats;
    }

    public void onCreateSubSolver(Query key, AbstractBoomerangSolver<W> solver) {
        for (SolverCreationListener<W> l : this.solverCreationListeners) {
            l.onCreatedSolver(key, solver);
        }
    }

    public void registerSolverCreationListener(SolverCreationListener<W> l) {
        if (this.solverCreationListeners.add(l)) {
            for (Map.Entry e : Lists.newArrayList(this.queryToSolvers.entrySet())) {
                l.onCreatedSolver((Query)e.getKey(), (AbstractBoomerangSolver)((Object)e.getValue()));
            }
        }
    }

    public Table<ControlFlowGraph.Edge, Val, W> getResults(ForwardQuery seed) {
        HashBasedTable results = HashBasedTable.create();
        WeightedPAutomaton fieldAut = this.queryToSolvers.getOrCreate(seed).getCallAutomaton();
        for (Map.Entry e : fieldAut.getTransitionsToFinalWeights().entrySet()) {
            Transition t = (Transition)e.getKey();
            Weight w = (Weight)e.getValue();
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)Statement.epsilon()) || ((Val)((INode)t.getStart()).fact()).isLocal() && !((ControlFlowGraph.Edge)t.getLabel()).getStart().getMethod().equals(((Val)((INode)t.getStart()).fact()).m())) continue;
            results.put((Object)t.getLabel(), ((INode)t.getStart()).fact(), (Object)w);
        }
        return results;
    }

    public BoomerangOptions getOptions() {
        return this.options;
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public Set<Method> getVisitedMethods() {
        return this.visitedMethods;
    }

    public void printCallAutomatonFlow(AbstractBoomerangSolver<W> solver) {
        HashBasedTable results = HashBasedTable.create();
        WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> callAut = solver.getCallAutomaton();
        for (Map.Entry e : callAut.getTransitionsToFinalWeights().entrySet()) {
            Transition t = (Transition)e.getKey();
            Weight w = (Weight)e.getValue();
            if (((ControlFlowGraph.Edge)t.getLabel()).getStart().equals((Object)Statement.epsilon()) || ((Val)((INode)t.getStart()).fact()).isLocal() && !((ControlFlowGraph.Edge)t.getLabel()).getStart().getMethod().equals(((Val)((INode)t.getStart()).fact()).m())) continue;
            results.put((Object)t.getLabel(), ((INode)t.getStart()).fact(), (Object)w);
        }
        LOGGER.trace("Call Automaton flow for {}", solver);
        this.printResultsPerMethod((Table<ControlFlowGraph.Edge, Val, W>)results);
    }

    private void printResultsPerMethod(Table<ControlFlowGraph.Edge, Val, W> results) {
        HashMultimap methodToRes = HashMultimap.create();
        for (Table.Cell c : results.cellSet()) {
            methodToRes.put((Object)((ControlFlowGraph.Edge)c.getRowKey()).getStart().getMethod(), (Object)c);
        }
        for (Method m : methodToRes.keySet()) {
            LOGGER.trace("Results in Method {}: ", (Object)m);
            for (Statement s : m.getStatements()) {
                LOGGER.trace("\tStatement {}: ", (Object)s);
                for (Table.Cell c : methodToRes.get((Object)m)) {
                    if (!((ControlFlowGraph.Edge)c.getRowKey()).getStart().equals((Object)s)) continue;
                    LOGGER.trace("\t\tVal: {}, W: {}", c.getColumnKey(), (Object)(c.getValue() + " "));
                }
            }
        }
    }

    public void printAllForwardCallAutomatonFlow() {
        for (Map.Entry<ForwardQuery, ForwardBoomerangSolver<W>> e : this.queryToSolvers.entrySet()) {
            this.printCallAutomatonFlow(e.getValue());
        }
    }

    public void printAllBackwardCallAutomatonFlow() {
        for (Map.Entry<BackwardQuery, BackwardBoomerangSolver<W>> e : this.queryToBackwardSolvers.entrySet()) {
            this.printCallAutomatonFlow(e.getValue());
        }
    }

    public void printAllAutomata() {
        for (Map.Entry<ForwardQuery, ForwardBoomerangSolver<W>> entry : this.queryToSolvers.entrySet()) {
            this.printAutomata(entry.getKey());
        }
        LOGGER.trace("Backward Solver");
        for (Map.Entry<Query, AbstractBoomerangSolver> entry : this.queryToBackwardSolvers.entrySet()) {
            this.printAutomata(entry.getKey());
        }
    }

    public void printAutomata(Query q) {
        if (LOGGER.isTraceEnabled() && q instanceof ForwardQuery) {
            LOGGER.trace("Solver {}", (Object)this.queryToSolvers.get(q).getQuery());
            LOGGER.trace("Field Automaton\n {}", (Object)this.queryToSolvers.get(q).getFieldAutomaton().toDotString());
            LOGGER.trace("Call Automaton\n {}", (Object)this.queryToSolvers.get(q).getCallAutomaton().toDotString());
        }
        if (LOGGER.isTraceEnabled() && q instanceof BackwardQuery) {
            LOGGER.trace("Solver {}", this.queryToBackwardSolvers.get(q));
            LOGGER.trace("Field Automaton\n {}", (Object)this.queryToBackwardSolvers.get(q).getFieldAutomaton().toDotString());
            LOGGER.trace("Call Automaton\n {}", (Object)this.queryToBackwardSolvers.get(q).getCallAutomaton().toDotString());
        }
    }

    private void printStats() {
        int forwardCallTransitions = 0;
        int backwardCallTransitions = 0;
        int forwardFieldTransitions = 0;
        int backwardFieldTransitions = 0;
        for (Map.Entry<ForwardQuery, ForwardBoomerangSolver<W>> e : this.queryToSolvers.entrySet()) {
            if (e.getKey() instanceof ForwardQuery) {
                forwardCallTransitions += e.getValue().getCallAutomaton().getTransitions().size();
                forwardFieldTransitions += e.getValue().getFieldAutomaton().getTransitions().size();
                continue;
            }
            backwardCallTransitions += e.getValue().getCallAutomaton().getTransitions().size();
            backwardFieldTransitions += e.getValue().getFieldAutomaton().getTransitions().size();
        }
        LOGGER.trace("Forward Call Transitions: {}", (Object)forwardCallTransitions);
        LOGGER.trace("Forward Field Transitions: {}", (Object)forwardFieldTransitions);
        LOGGER.trace("Backward Call Transitions: {}", (Object)backwardCallTransitions);
        LOGGER.trace("Backward Field Transitions: {}", (Object)backwardFieldTransitions);
    }

    private void printQueryTimes() {
        for (Map.Entry<ForwardQuery, ForwardBoomerangSolver<W>> entry : this.queryToSolvers.entrySet()) {
            LOGGER.trace("{}", (Object)entry.getKey());
            LOGGER.trace("Call Automaton Time: {}", (Object)entry.getValue().getCallAutomaton().getWatch());
            LOGGER.trace("Field Automaton Time: {}", (Object)entry.getValue().getFieldAutomaton().getWatch());
        }
    }

    private void printElapsedTimes() {
        long forwardCallElaps = 0L;
        long forwardFieldElaps = 0L;
        for (ForwardBoomerangSolver<W> v : this.queryToSolvers.values()) {
            forwardCallElaps += v.getCallAutomaton().getWatch().elapsed(TimeUnit.SECONDS);
            forwardFieldElaps += v.getFieldAutomaton().getWatch().elapsed(TimeUnit.SECONDS);
        }
        LOGGER.trace("ForwardCallWatch " + forwardCallElaps + " s");
        LOGGER.trace("ForwardFieldWatch " + forwardFieldElaps + " s");
    }

    private void printRules() {
        long forwardCallElaps = 0L;
        long forwardFieldElaps = 0L;
        HashSet allCallRules = Sets.newHashSet();
        HashSet allFieldRules = Sets.newHashSet();
        for (ForwardBoomerangSolver<W> v : this.queryToSolvers.values()) {
            allCallRules.addAll(v.getCallPDS().getAllRules());
            allFieldRules.addAll(v.getFieldPDS().getAllRules());
            forwardCallElaps += (long)v.getCallPDS().getAllRules().size();
            forwardFieldElaps += (long)v.getFieldPDS().getAllRules().size();
        }
        LOGGER.trace("ForwardCallRules (total)" + forwardCallElaps);
        LOGGER.trace("ForwardFieldRules (total)" + forwardFieldElaps);
        LOGGER.trace("ForwardCallRules (deduplicated)" + allCallRules.size());
        LOGGER.trace("ForwardFieldRules (deduplicated)" + allFieldRules.size());
    }

    private class SolverPair {
        private AbstractBoomerangSolver<W> flowSolver;
        private AbstractBoomerangSolver<W> baseSolver;

        public SolverPair(AbstractBoomerangSolver<W> flowSolver, AbstractBoomerangSolver<W> baseSolver) {
            this.flowSolver = flowSolver;
            this.baseSolver = baseSolver;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.baseSolver == null ? 0 : ((Object)((Object)this.baseSolver)).hashCode());
            result = 31 * result + (this.flowSolver == null ? 0 : ((Object)((Object)this.flowSolver)).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SolverPair other = (SolverPair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.baseSolver == null ? other.baseSolver != null : !((Object)((Object)this.baseSolver)).equals((Object)other.baseSolver)) {
                return false;
            }
            return !(this.flowSolver == null ? other.flowSolver != null : !((Object)((Object)this.flowSolver)).equals((Object)other.flowSolver));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }

    public class FieldWritePOI
    extends AbstractPOI<ControlFlowGraph.Edge, Val, Field> {
        public FieldWritePOI(ControlFlowGraph.Edge statement, Val base, Field field, Val stored) {
            super(statement, base, field, stored);
        }

        @Override
        public void execute(ForwardQuery baseAllocation, Query flowAllocation) {
            if (!(flowAllocation instanceof BackwardQuery) && flowAllocation instanceof ForwardQuery) {
                ForwardBoomerangSolver baseSolver = (ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get(baseAllocation));
                ForwardBoomerangSolver flowSolver = (ForwardBoomerangSolver)((Object)WeightedBoomerang.this.queryToSolvers.get(flowAllocation));
                ExecuteImportFieldStmtPOI exec = new ExecuteImportFieldStmtPOI<W>(baseSolver, flowSolver, this){

                    @Override
                    public void activate(INode<Node<ControlFlowGraph.Edge, Val>> start) {
                        WeightedBoomerang.this.activateAllPois(new SolverPair(this.flowSolver, this.baseSolver), start);
                    }
                };
                WeightedBoomerang.this.registerActivationListener(new SolverPair(flowSolver, baseSolver), exec);
                exec.solve();
            }
        }
    }

    private class TriggerBaseAllocationAtFieldWrite
    extends WPAStateListener<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> {
        private final PointOfIndirection<ControlFlowGraph.Edge, Val, Field> fieldWritePoi;
        private final ForwardQuery sourceQuery;

        public TriggerBaseAllocationAtFieldWrite(INode<Node<ControlFlowGraph.Edge, Val>> state, PointOfIndirection<ControlFlowGraph.Edge, Val, Field> fieldWritePoi, ForwardQuery sourceQuery) {
            super(state);
            this.fieldWritePoi = fieldWritePoi;
            this.sourceQuery = sourceQuery;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> aut) {
            if (WeightedBoomerang.this.isAllocationNode((Val)((Node)((INode)t.getTarget()).fact()).fact(), this.sourceQuery)) {
                this.fieldWritePoi.addBaseAllocation(this.sourceQuery);
            }
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> aut) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.fieldWritePoi == null ? 0 : this.fieldWritePoi.hashCode());
            result = 31 * result + (this.sourceQuery == null ? 0 : this.sourceQuery.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            TriggerBaseAllocationAtFieldWrite other = (TriggerBaseAllocationAtFieldWrite)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.fieldWritePoi == null ? other.fieldWritePoi != null : !this.fieldWritePoi.equals(other.fieldWritePoi)) {
                return false;
            }
            return !(this.sourceQuery == null ? other.sourceQuery != null : !this.sourceQuery.equals(other.sourceQuery));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }

    private final class ForwardHandleFieldWrite
    extends ControlFlowEdgeBasedFieldTransitionListener<W> {
        private final Query sourceQuery;
        private final AbstractPOI<ControlFlowGraph.Edge, Val, Field> fieldWritePoi;
        private final ControlFlowGraph.Edge stmt;

        private ForwardHandleFieldWrite(Query sourceQuery, AbstractPOI<ControlFlowGraph.Edge, Val, Field> fieldWritePoi, ControlFlowGraph.Edge statement) {
            super(statement);
            this.sourceQuery = sourceQuery;
            this.fieldWritePoi = fieldWritePoi;
            this.stmt = statement;
        }

        @Override
        public void onAddedTransition(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t) {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            if (((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()).equals((Object)this.stmt)) {
                this.fieldWritePoi.addFlowAllocation(this.sourceQuery);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.sourceQuery == null ? 0 : this.sourceQuery.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ForwardHandleFieldWrite other = (ForwardHandleFieldWrite)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.sourceQuery == null ? other.sourceQuery != null : !this.sourceQuery.equals(other.sourceQuery));
        }

        private WeightedBoomerang getOuterType() {
            return WeightedBoomerang.this;
        }
    }

    private final class ArrayAllocationListener
    extends WPAStateListener<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> {
        private final int arrayAccessIndex;
        private AllocVal val;
        private BackwardQuery key;
        private Node<ControlFlowGraph.Edge, Val> node;

        public ArrayAllocationListener(int arrayAccessIndex, INode<Node<ControlFlowGraph.Edge, Val>> target, AllocVal val, BackwardQuery key, Node<ControlFlowGraph.Edge, Val> node) {
            super(target);
            this.arrayAccessIndex = arrayAccessIndex;
            this.val = val;
            this.key = key;
            this.node = node;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
            ForwardQueryArray forwardQuery;
            if (((Field)t.getLabel()).equals((Object)Field.empty())) {
                forwardQuery = new ForwardQueryArray((ControlFlowGraph.Edge)this.node.stmt(), (Val)this.val, this.arrayAccessIndex);
                WeightedBoomerang.this.forwardSolve(forwardQuery);
                WeightedBoomerang.this.queryGraph.addEdge(this.key, this.node, forwardQuery);
            }
            if (t.getLabel() instanceof Field.ArrayField) {
                forwardQuery = new ForwardQueryMultiDimensionalArray((ControlFlowGraph.Edge)this.node.stmt(), (Val)this.val, this.arrayAccessIndex, ((Field.ArrayField)t.getLabel()).getIndex());
                WeightedBoomerang.this.forwardSolve(forwardQuery);
                WeightedBoomerang.this.queryGraph.addEdge(this.key, this.node, forwardQuery);
            }
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
        }

        private WeightedBoomerang getEnclosingInstance() {
            return WeightedBoomerang.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getEnclosingInstance().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ArrayAllocationListener other = (ArrayAllocationListener)((Object)obj);
            return this.getEnclosingInstance().equals(other.getEnclosingInstance());
        }
    }

    private final class EmptyFieldListener
    extends WPAStateListener<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> {
        private BackwardQuery key;
        private Node<ControlFlowGraph.Edge, Val> node;

        public EmptyFieldListener(BackwardQuery key, Node<ControlFlowGraph.Edge, Val> node) {
            super((State)new SingleNode(node));
            this.key = key;
            this.node = node;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getEnclosingInstance().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            EmptyFieldListener other = (EmptyFieldListener)((Object)obj);
            return this.getEnclosingInstance().equals(other.getEnclosingInstance());
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
            if (!((Field)t.getLabel()).equals((Object)Field.empty()) && !(t.getLabel() instanceof Field.ArrayField)) {
                return;
            }
            Optional<AllocVal> allocNode = WeightedBoomerang.this.isAllocationNode((ControlFlowGraph.Edge)this.node.stmt(), (Val)this.node.fact());
            if (allocNode.isPresent()) {
                AllocVal val = allocNode.get();
                if (t.getLabel() instanceof Field.ArrayField) {
                    WeightedBoomerang.this.backwardSolverIns.getFieldAutomaton().registerListener((WPAStateListener)new ArrayAllocationListener(((Field.ArrayField)t.getLabel()).getIndex(), (INode<Node<ControlFlowGraph.Edge, Val>>)((INode)t.getTarget()), val, this.key, this.node));
                } else {
                    ForwardQuery forwardQuery = new ForwardQuery((ControlFlowGraph.Edge)this.node.stmt(), (Val)val);
                    WeightedBoomerang.this.forwardSolve(forwardQuery);
                    WeightedBoomerang.this.queryGraph.addEdge(this.key, this.node, forwardQuery);
                }
            }
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
        }

        private WeightedBoomerang getEnclosingInstance() {
            return WeightedBoomerang.this;
        }
    }
}

