/*
 * Decompiled with CFR 0.152.
 */
package boomerang.weights;

import boomerang.BoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.WeightedBoomerang;
import boomerang.scene.CallGraph;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DataFlowScope;
import boomerang.scene.Field;
import boomerang.scene.Val;
import boomerang.weights.DataFlowPathWeight;
import boomerang.weights.PathTrackingWeightFunctions;
import sync.pds.solver.OneWeightFunctions;
import sync.pds.solver.WeightFunctions;
import wpds.impl.Weight;

public abstract class PathTrackingBoomerang
extends WeightedBoomerang<DataFlowPathWeight> {
    private OneWeightFunctions<ControlFlowGraph.Edge, Val, Field, DataFlowPathWeight> fieldWeights;
    private PathTrackingWeightFunctions callWeights;

    public PathTrackingBoomerang(CallGraph cg, DataFlowScope scope) {
        super(cg, scope);
    }

    public PathTrackingBoomerang(CallGraph cg, DataFlowScope scope, BoomerangOptions opt) {
        super(cg, scope, opt);
    }

    @Override
    protected WeightFunctions<ControlFlowGraph.Edge, Val, Field, DataFlowPathWeight> getForwardFieldWeights() {
        return this.getOrCreateFieldWeights();
    }

    @Override
    protected WeightFunctions<ControlFlowGraph.Edge, Val, Field, DataFlowPathWeight> getBackwardFieldWeights() {
        return this.getOrCreateFieldWeights();
    }

    @Override
    protected WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, DataFlowPathWeight> getBackwardCallWeights() {
        return this.getOrCreateCallWeights();
    }

    @Override
    protected WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, DataFlowPathWeight> getForwardCallWeights(ForwardQuery sourceQuery) {
        return this.getOrCreateCallWeights();
    }

    private WeightFunctions<ControlFlowGraph.Edge, Val, Field, DataFlowPathWeight> getOrCreateFieldWeights() {
        if (this.fieldWeights == null) {
            this.fieldWeights = new OneWeightFunctions((Weight)DataFlowPathWeight.one());
        }
        return this.fieldWeights;
    }

    private WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, DataFlowPathWeight> getOrCreateCallWeights() {
        if (this.callWeights == null) {
            this.callWeights = new PathTrackingWeightFunctions(this.options.trackDataFlowPath(), this.options.trackPathConditions(), this.options.trackImplicitFlows());
        }
        return this.callWeights;
    }
}

