/*
 * Decompiled with CFR 0.152.
 */
package boomerang.weights;

import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import wpds.impl.Weight;

public class PathConditionWeight
extends Weight {
    private static PathConditionWeight one;
    private Map<Statement, ConditionDomain> ifStatements = Maps.newHashMap();
    private Map<Val, ConditionDomain> variableToValue = Maps.newHashMap();
    private Set<Val> returnVals = Sets.newHashSet();
    private Map<Method, Statement> calleeToCallSite = Maps.newHashMap();
    private String rep;

    private PathConditionWeight(String rep) {
        this.rep = rep;
    }

    public PathConditionWeight(Statement callSite, Method callee) {
        this.calleeToCallSite.put(callee, callSite);
    }

    public static PathConditionWeight one() {
        if (one == null) {
            one = new PathConditionWeight("ONE");
        }
        return one;
    }

    public PathConditionWeight(Val returnVal) {
        this.returnVals.add(returnVal);
    }

    private PathConditionWeight(Map<Statement, ConditionDomain> ifStatements, Map<Val, ConditionDomain> variableToValue, Set<Val> returnVals, Map<Method, Statement> calleeToCallSiteMapping) {
        this.ifStatements = ifStatements;
        this.variableToValue = variableToValue;
        this.returnVals = returnVals;
        this.calleeToCallSite = calleeToCallSiteMapping;
    }

    public PathConditionWeight(Statement ifStatement, Boolean condition) {
        this.ifStatements.put(ifStatement, condition != false ? ConditionDomain.TRUE : ConditionDomain.FALSE);
    }

    public PathConditionWeight(Val val, ConditionDomain c) {
        this.variableToValue.put(val, c);
    }

    public Weight extendWith(Weight o) {
        if (!(o instanceof PathConditionWeight)) {
            throw new RuntimeException("Cannot extend to different types of weight!");
        }
        PathConditionWeight other = (PathConditionWeight)o;
        HashMap newIfs = Maps.newHashMap();
        newIfs.putAll(this.ifStatements);
        for (Map.Entry<Statement, ConditionDomain> e : other.ifStatements.entrySet()) {
            if (newIfs.containsKey(e.getKey()) && e.getValue().equals((Object)ConditionDomain.TOP)) {
                newIfs.put(e.getKey(), ConditionDomain.TOP);
                continue;
            }
            newIfs.put(e.getKey(), e.getValue());
        }
        HashMap newVals = Maps.newHashMap();
        newVals.putAll(this.variableToValue);
        for (Map.Entry entry : other.variableToValue.entrySet()) {
            if (newVals.containsKey(entry.getKey()) && ((ConditionDomain)((Object)entry.getValue())).equals((Object)ConditionDomain.TOP)) {
                newVals.put(entry.getKey(), ConditionDomain.TOP);
                continue;
            }
            newVals.put(entry.getKey(), entry.getValue());
        }
        HashMap returnToAssignedVariableMap = Maps.newHashMap();
        if (!this.returnVals.isEmpty()) {
            for (Map.Entry entry : newVals.entrySet()) {
                Statement s;
                if (!this.returnVals.contains(entry.getKey()) || (s = this.calleeToCallSite.get(((Val)entry.getKey()).m())) == null || !s.isAssign()) continue;
                Val leftOp = s.getLeftOp();
                returnToAssignedVariableMap.put(leftOp, entry.getValue());
            }
        }
        newVals.putAll(returnToAssignedVariableMap);
        HashSet hashSet = Sets.newHashSet(this.returnVals);
        hashSet.addAll(other.returnVals);
        HashMap hashMap = Maps.newHashMap(this.calleeToCallSite);
        hashMap.putAll(other.calleeToCallSite);
        return new PathConditionWeight(newIfs, newVals, hashSet, hashMap);
    }

    public Weight combineWith(Weight o) {
        if (!(o instanceof PathConditionWeight)) {
            throw new RuntimeException("Cannot extend to different types of weight!");
        }
        PathConditionWeight other = (PathConditionWeight)o;
        HashMap newIfs = Maps.newHashMap();
        for (Map.Entry<Statement, ConditionDomain> e : this.ifStatements.entrySet()) {
            if (other.ifStatements.containsKey(e.getKey())) {
                ConditionDomain otherVal = other.ifStatements.get(e.getKey());
                if (((ConditionDomain)((Object)e.getValue())).equals((Object)otherVal)) {
                    newIfs.put(e.getKey(), otherVal);
                    continue;
                }
                newIfs.put(e.getKey(), ConditionDomain.TOP);
                continue;
            }
            newIfs.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<Statement, ConditionDomain> e : other.ifStatements.entrySet()) {
            if (this.ifStatements.containsKey(e.getKey())) continue;
            newIfs.put(e.getKey(), e.getValue());
        }
        HashMap newVals = Maps.newHashMap();
        for (Map.Entry<Val, ConditionDomain> e : this.variableToValue.entrySet()) {
            if (other.variableToValue.containsKey(e.getKey())) {
                ConditionDomain conditionDomain = other.variableToValue.get(e.getKey());
                if (e.getValue().equals((Object)conditionDomain)) {
                    newVals.put(e.getKey(), conditionDomain);
                    continue;
                }
                newVals.put(e.getKey(), ConditionDomain.TOP);
                continue;
            }
            newVals.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<Val, ConditionDomain> e : other.variableToValue.entrySet()) {
            if (this.variableToValue.containsKey(e.getKey())) continue;
            newVals.put(e.getKey(), e.getValue());
        }
        HashMap returnToAssignedVariableMap = Maps.newHashMap();
        if (!this.returnVals.isEmpty()) {
            for (Map.Entry entry : newVals.entrySet()) {
                Statement s;
                if (!this.returnVals.contains(entry.getKey()) || (s = this.calleeToCallSite.get(((Val)entry.getKey()).m())) == null || !s.isAssign()) continue;
                Val leftOp = s.getLeftOp();
                returnToAssignedVariableMap.put(leftOp, entry.getValue());
            }
        }
        newVals.putAll(returnToAssignedVariableMap);
        HashSet newReturnVals = Sets.newHashSet(this.returnVals);
        newReturnVals.addAll(other.returnVals);
        HashMap hashMap = Maps.newHashMap(this.calleeToCallSite);
        hashMap.putAll(other.calleeToCallSite);
        return new PathConditionWeight(newIfs, newVals, newReturnVals, hashMap);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ifStatements == null ? 0 : this.ifStatements.hashCode());
        result = 31 * result + (this.variableToValue == null ? 0 : this.variableToValue.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PathConditionWeight other = (PathConditionWeight)((Object)obj);
        if (this.ifStatements == null ? other.ifStatements != null : !this.ifStatements.equals(other.ifStatements)) {
            return false;
        }
        if (this.variableToValue == null ? other.variableToValue != null : !this.variableToValue.equals(other.variableToValue)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public Map<Statement, ConditionDomain> getConditions() {
        return this.ifStatements;
    }

    public Map<Val, ConditionDomain> getEvaluationMap() {
        return this.variableToValue;
    }

    public String toString() {
        return "\nIf statements: " + this.ifStatements + " Vals: " + this.variableToValue;
    }

    public static enum ConditionDomain {
        TRUE,
        FALSE,
        TOP;

    }
}

