/*
 * Decompiled with CFR 0.152.
 */
package boomerang.weights;

import wpds.impl.Weight;

public class MinDistanceWeight
extends Weight {
    private static MinDistanceWeight one;
    private static MinDistanceWeight zero;
    private Integer minDistance = -1;
    private String rep;

    private MinDistanceWeight(String rep) {
        this.rep = rep;
    }

    public MinDistanceWeight(Integer minDistance) {
        this.minDistance = minDistance;
    }

    public Weight extendWith(Weight o) {
        if (!(o instanceof MinDistanceWeight)) {
            throw new RuntimeException("Cannot extend to different types of weight!");
        }
        MinDistanceWeight other = (MinDistanceWeight)o;
        if (other.equals((Object)MinDistanceWeight.one())) {
            return this;
        }
        if (this.equals((Object)MinDistanceWeight.one())) {
            return other;
        }
        Integer newDistance = this.minDistance + other.minDistance;
        return new MinDistanceWeight(newDistance);
    }

    public Weight combineWith(Weight o) {
        if (!(o instanceof MinDistanceWeight)) {
            throw new RuntimeException("Cannot extend to different types of weight!");
        }
        MinDistanceWeight other = (MinDistanceWeight)o;
        if (other.equals((Object)MinDistanceWeight.one())) {
            return this;
        }
        if (this.equals((Object)MinDistanceWeight.one())) {
            return other;
        }
        return new MinDistanceWeight(Math.min(other.minDistance, this.minDistance));
    }

    public static MinDistanceWeight one() {
        if (one == null) {
            one = new MinDistanceWeight("ONE");
        }
        return one;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.minDistance == null ? 0 : this.minDistance.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MinDistanceWeight other = (MinDistanceWeight)((Object)obj);
        if (this.minDistance == null ? other.minDistance != null : !this.minDistance.equals(other.minDistance)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public String toString() {
        return this.equals((Object)MinDistanceWeight.one()) ? "ONE " : " Distance: " + this.minDistance;
    }

    public Integer getMinDistance() {
        return this.minDistance;
    }
}

