/*
 * Decompiled with CFR 0.152.
 */
package boomerang.stats;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.Util;
import boomerang.WeightedBoomerang;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Field;
import boomerang.scene.Method;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Rule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.interfaces.Location;
import wpds.interfaces.State;

public class CSVBoomerangStatsWriter<W extends Weight>
implements IBoomerangStats<W> {
    private Map<Query, AbstractBoomerangSolver<W>> queries = Maps.newHashMap();
    private Set<WeightedTransition<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W>> globalFieldTransitions = Sets.newHashSet();
    private int fieldTransitionCollisions;
    private Set<WeightedTransition<ControlFlowGraph.Edge, INode<Val>, W>> globalCallTransitions = Sets.newHashSet();
    private int callTransitionCollisions;
    private Set<Rule<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W>> globalFieldRules = Sets.newHashSet();
    private int fieldRulesCollisions;
    private Set<Rule<ControlFlowGraph.Edge, INode<Val>, W>> globalCallRules = Sets.newHashSet();
    private int callRulesCollisions;
    private Set<Node<ControlFlowGraph.Edge, Val>> reachedForwardNodes = Sets.newHashSet();
    private int reachedForwardNodeCollisions;
    private Set<Node<ControlFlowGraph.Edge, Val>> reachedBackwardNodes = Sets.newHashSet();
    private int reachedBackwardNodeCollisions;
    private Set<Method> callVisitedMethods = Sets.newHashSet();
    private Set<Method> fieldVisitedMethods = Sets.newHashSet();
    private Set<ControlFlowGraph.Edge> callVisitedStmts = Sets.newHashSet();
    private Set<ControlFlowGraph.Edge> fieldVisitedStmts = Sets.newHashSet();
    private Set<INode<Node<ControlFlowGraph.Edge, Val>>> fieldGeneratedStates = Sets.newHashSet();
    private Set<INode<Val>> callGeneratedStates = Sets.newHashSet();
    private int arrayFlows;
    private int staticFlows;
    private int fieldWritePOIs;
    private int fieldReadPOIs;
    private String outputFileName;
    private static final String CSV_SEPARATOR = ";";
    private List<String> headers = Lists.newArrayList();
    private Map<String, String> headersToValues = Maps.newHashMap();
    private long memoryBefore;

    public CSVBoomerangStatsWriter(String outputFileName) {
        this.outputFileName = outputFileName;
        for (Headers h : Headers.values()) {
            this.headers.add(h.toString());
        }
        this.memoryBefore = Util.getReallyUsedMemory();
    }

    public static <K> Map<K, Integer> sortByValues(final Map<K, Integer> map) {
        Comparator valueComparator = new Comparator<K>(){

            @Override
            public int compare(K k1, K k2) {
                if ((Integer)map.get(k2) > (Integer)map.get(k1)) {
                    return 1;
                }
                return -1;
            }
        };
        TreeMap<K, Integer> sortedByValues = new TreeMap<K, Integer>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    @Override
    public void registerSolver(Query key, AbstractBoomerangSolver<W> solver) {
        if (this.queries.containsKey(key)) {
            return;
        }
        this.queries.put(key, solver);
        solver.getFieldAutomaton().registerListener((t, w, aut) -> {
            if (!this.globalFieldTransitions.add(new WeightedTransition(t, w))) {
                ++this.fieldTransitionCollisions;
            }
            this.fieldVisitedMethods.add(((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()).getMethod());
            this.fieldVisitedStmts.add((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt());
            if (t.getLabel() instanceof Field.ArrayField) {
                ++this.arrayFlows;
            }
            this.addFieldGeneratedState((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)t.getStart()));
            this.addFieldGeneratedState((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)t.getTarget()));
        });
        solver.getCallAutomaton().registerListener((t, w, aut) -> {
            if (!this.globalCallTransitions.add(new WeightedTransition(t, w))) {
                ++this.callTransitionCollisions;
            }
            this.callVisitedMethods.add(((ControlFlowGraph.Edge)t.getLabel()).getMethod());
            this.fieldVisitedStmts.add((ControlFlowGraph.Edge)t.getLabel());
            if (((Val)((INode)t.getStart()).fact()).isStatic()) {
                ++this.staticFlows;
            }
            this.addCallGeneratedState((INode<Val>)((INode)t.getStart()));
            this.addCallGeneratedState((INode<Val>)((INode)t.getTarget()));
        });
        solver.getFieldPDS().registerUpdateListener(rule -> {
            if (!this.globalFieldRules.add(rule)) {
                ++this.fieldRulesCollisions;
            }
        });
        solver.getCallPDS().registerUpdateListener(rule -> {
            if (!this.globalCallRules.add(rule)) {
                ++this.callRulesCollisions;
            }
        });
        solver.registerListener(reachableNode -> {
            if (solver instanceof ForwardBoomerangSolver) {
                if (!this.reachedForwardNodes.add((Node<ControlFlowGraph.Edge, Val>)reachableNode)) {
                    ++this.reachedForwardNodeCollisions;
                }
            } else if (!this.reachedBackwardNodes.add((Node<ControlFlowGraph.Edge, Val>)reachableNode)) {
                ++this.reachedBackwardNodeCollisions;
            }
        });
    }

    protected void addFieldGeneratedState(INode<Node<ControlFlowGraph.Edge, Val>> s) {
        if (s instanceof GeneratedState) {
            this.fieldGeneratedStates.add(s);
        }
    }

    protected void addCallGeneratedState(INode<Val> s) {
        if (s instanceof GeneratedState) {
            this.callGeneratedStates.add(s);
        }
    }

    @Override
    public void registerFieldWritePOI(WeightedBoomerang.FieldWritePOI key) {
        ++this.fieldWritePOIs;
    }

    public String toString() {
        String s = "=========== Boomerang Stats =============\n";
        int forwardQuery = 0;
        int backwardQuery = 0;
        for (Query q : this.queries.keySet()) {
            if (q instanceof ForwardQuery) {
                ++forwardQuery;
                continue;
            }
            ++backwardQuery;
        }
        s = s + String.format("Queries (Forward/Backward/Total): \t\t %s/%s/%s\n", forwardQuery, backwardQuery, this.queries.keySet().size());
        s = s + String.format("Visited Methods (Field/Call): \t\t %s/%s\n", this.fieldVisitedMethods.size(), this.callVisitedMethods.size());
        s = s + String.format("Reached Forward Nodes(Collisions): \t\t %s (%s)\n", this.reachedForwardNodes.size(), this.reachedForwardNodeCollisions);
        s = s + String.format("Reached Backward Nodes(Collisions): \t\t %s (%s)\n", this.reachedBackwardNodes.size(), this.reachedBackwardNodeCollisions);
        s = s + String.format("Global Field Rules(Collisions): \t\t %s (%s)\n", this.globalFieldRules.size(), this.fieldRulesCollisions);
        s = s + String.format("Global Field Transitions(Collisions): \t\t %s (%s)\n", this.globalFieldTransitions.size(), this.fieldTransitionCollisions);
        s = s + String.format("Global Call Rules(Collisions): \t\t %s (%s)\n", this.globalCallRules.size(), this.callRulesCollisions);
        s = s + String.format("Global Call Transitions(Collisions): \t\t %s (%s)\n", this.globalCallTransitions.size(), this.callTransitionCollisions);
        s = s + String.format("Special Flows (Static/Array): \t\t %s(%s)/%s(%s)\n", this.staticFlows, this.globalCallTransitions.size(), this.arrayFlows, this.globalFieldTransitions.size());
        s = s + this.computeMetrics();
        s = s + "\n";
        return s;
    }

    @Override
    public Set<Method> getCallVisitedMethods() {
        return Sets.newHashSet(this.callVisitedMethods);
    }

    private String computeMetrics() {
        int min = Integer.MAX_VALUE;
        int totalReached = 0;
        int max = 0;
        Query maxQuery = null;
        for (Query q : this.queries.keySet()) {
            int size = this.queries.get(q).getReachedStates().size();
            totalReached += size;
            min = Math.min(size, min);
            if (size > max) {
                maxQuery = q;
            }
            max = Math.max(size, max);
        }
        float average = (float)totalReached / (float)this.queries.keySet().size();
        String s = String.format("Reachable nodes (Min/Avg/Max): \t\t%s/%s/%s\n", min, Float.valueOf(average), max);
        s = s + String.format("Maximal Query: \t\t%s\n", maxQuery);
        return s;
    }

    @Override
    public Collection<? extends Node<ControlFlowGraph.Edge, Val>> getForwardReachesNodes() {
        HashSet res = Sets.newHashSet();
        for (Query q : this.queries.keySet()) {
            if (!(q instanceof ForwardQuery)) continue;
            res.addAll(this.queries.get(q).getReachedStates());
        }
        return res;
    }

    @Override
    public void terminated(ForwardQuery query, ForwardBoomerangResults<W> res) {
        this.writeToFile(query, res.getAnalysisWatch().elapsed(TimeUnit.MILLISECONDS), res.isTimedout());
    }

    @Override
    public void terminated(BackwardQuery query, BackwardBoomerangResults<W> res) {
        this.writeToFile(query, res.getAnalysisWatch().elapsed(TimeUnit.MILLISECONDS), res.isTimedout());
    }

    private void writeToFile(Query query, long queryTime, boolean timeout) {
        long memoryAfter = Util.getReallyUsedMemory();
        this.put(Headers.Query, (Object)query.toString());
        this.put(Headers.QueryType, (Object)(query instanceof BackwardQuery ? "B" : "F"));
        this.put(Headers.QueryTime, (Object)queryTime);
        this.put(Headers.Timeout, (Object)(timeout ? "1" : "0"));
        this.put(Headers.ArrayFlows, (Object)this.arrayFlows);
        this.put(Headers.CallRules, (Object)this.globalCallRules.size());
        this.put(Headers.FieldRules, (Object)this.globalFieldRules.size());
        this.put(Headers.CallTransitions, (Object)this.globalCallTransitions.size());
        this.put(Headers.FieldTransitions, (Object)this.globalFieldTransitions.size());
        this.put(Headers.FieldReadPOIs, (Object)this.fieldReadPOIs);
        this.put(Headers.FieldWritePOIs, (Object)this.fieldWritePOIs);
        this.put(Headers.FieldVisitedMethods, (Object)this.fieldVisitedMethods.size());
        this.put(Headers.CallVisitedMethods, (Object)this.callVisitedMethods.size());
        this.put(Headers.FieldVisitedStmts, (Object)this.fieldVisitedStmts.size());
        this.put(Headers.CallVisitedStmts, (Object)this.callVisitedStmts.size());
        this.put(Headers.ReachedForwardNodes, (Object)this.reachedForwardNodes.size());
        this.put(Headers.ReachedBackwardNodes, (Object)this.reachedBackwardNodes.size());
        this.put(Headers.StaticFlows, (Object)this.staticFlows);
        this.put(Headers.CallGeneratedStates, (Object)this.callGeneratedStates.size());
        this.put(Headers.FieldGeneratedStates, (Object)this.fieldGeneratedStates.size());
        this.put(Headers.CallLongestCallStack, (Object)this.queries.get(query).getCallAutomaton().getLongestPath().size());
        this.put(Headers.FieldLongestAccessPath, (Object)this.queries.get(query).getFieldAutomaton().getLongestPath().size());
        this.put(Headers.CallContainsLoop, (Object)this.queries.get(query).getCallAutomaton().containsLoop());
        this.put(Headers.FieldContainsLoop, (Object)this.queries.get(query).getFieldAutomaton().containsLoop());
        this.put(Headers.MemoryAfter, (Object)memoryAfter);
        this.put(Headers.MemoryBefore, (Object)this.memoryBefore);
        this.put(Headers.MemoryDiff, (Object)(memoryAfter - this.memoryBefore));
        try {
            File reportFile = new File(this.outputFileName).getAbsoluteFile();
            if (!reportFile.getParentFile().exists()) {
                try {
                    Files.createDirectories(reportFile.getParentFile().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Was not able to create directories for IDEViz output!");
                }
            }
            boolean fileExisted = reportFile.exists();
            FileWriter writer = new FileWriter(reportFile, true);
            if (!fileExisted) {
                writer.write(Joiner.on((String)CSV_SEPARATOR).join(this.headers) + "\n");
            }
            ArrayList line = Lists.newArrayList();
            for (String h : this.headers) {
                String string = this.headersToValues.get(h);
                if (string == null) {
                    string = "";
                }
                line.add(string);
            }
            writer.write(Joiner.on((String)CSV_SEPARATOR).join((Iterable)line) + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void put(String key, Object val) {
        if (!this.headers.contains(key)) {
            System.err.println("Did not create a header to this value " + key);
        } else {
            this.headersToValues.put(key, val.toString());
        }
    }

    private void put(Headers key, Object val) {
        this.put(key.toString(), val);
    }

    private static class WeightedTransition<X extends Location, Y extends State, W> {
        final Transition<X, Y> t;
        final W w;

        public WeightedTransition(Transition<X, Y> t, W w) {
            this.t = t;
            this.w = w;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.t == null ? 0 : this.t.hashCode());
            result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeightedTransition other = (WeightedTransition)obj;
            if (this.t == null ? other.t != null : !this.t.equals(other.t)) {
                return false;
            }
            return !(this.w == null ? other.w != null : !this.w.equals(other.w));
        }
    }

    private static enum Headers {
        Query,
        QueryType,
        FieldTransitions,
        CallTransitions,
        CallRules,
        FieldRules,
        ReachedForwardNodes,
        ReachedBackwardNodes,
        CallVisitedMethods,
        FieldVisitedMethods,
        CallVisitedStmts,
        FieldVisitedStmts,
        FieldWritePOIs,
        FieldReadPOIs,
        StaticFlows,
        ArrayFlows,
        QueryTime,
        Timeout,
        ICFGEdges,
        CallGeneratedStates,
        FieldGeneratedStates,
        FieldLongestAccessPath,
        CallLongestCallStack,
        CallContainsLoop,
        FieldContainsLoop,
        MemoryBefore,
        MemoryAfter,
        MemoryDiff;

    }
}

