/*
 * Decompiled with CFR 0.152.
 */
package boomerang.callgraph;

import boomerang.callgraph.CallGraphOptions;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ICallerCalleeResolutionStrategy;
import boomerang.callgraph.ObservableICFG;
import boomerang.controlflowgraph.ObservableControlFlowGraph;
import boomerang.scene.CallGraph;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableDynamicICFG
implements ObservableICFG<Statement, Method> {
    private static final Logger logger = LoggerFactory.getLogger(ObservableDynamicICFG.class);
    private static final int IMPRECISE_CALL_GRAPH_WARN_THRESHOLD = 30;
    private int numberOfEdgesTakenFromPrecomputedCallGraph = 0;
    private CallGraphOptions options = new CallGraphOptions();
    private CallGraph demandDrivenCallGraph = new CallGraph();
    private final Multimap<Statement, CalleeListener<Statement, Method>> calleeListeners = HashMultimap.create();
    private final Multimap<Method, CallerListener<Statement, Method>> callerListeners = HashMultimap.create();
    private final ObservableControlFlowGraph cfg;
    private final ICallerCalleeResolutionStrategy resolutionStrategy;

    public ObservableDynamicICFG(ObservableControlFlowGraph cfg, ICallerCalleeResolutionStrategy resolutionStrategy) {
        this.cfg = cfg;
        this.resolutionStrategy = resolutionStrategy;
    }

    @Override
    public void addCalleeListener(CalleeListener<Statement, Method> listener) {
        if (!this.calleeListeners.put((Object)listener.getObservedCaller(), listener)) {
            return;
        }
        Statement stmt = listener.getObservedCaller();
        Collection edges = this.demandDrivenCallGraph.edgesOutOf(stmt);
        if (edges.size() > 30) {
            logger.debug("Call graph has more than {} callees at {}", (Object)30, (Object)listener.getObservedCaller());
            for (CallGraph.Edge e : Lists.newArrayList((Iterable)edges)) {
                logger.trace("\t callee {}", (Object)e.tgt());
            }
        }
        for (CallGraph.Edge e : Lists.newArrayList((Iterable)edges)) {
            listener.onCalleeAdded(stmt, e.tgt());
        }
        InvokeExpr ie = stmt.getInvokeExpr();
        if (ie.isInstanceInvokeExpr()) {
            if (ie.isSpecialInvokeExpr()) {
                this.addCallIfNotInGraph(stmt, this.resolutionStrategy.resolveSpecialInvoke(ie));
            } else {
                for (Method method : this.resolutionStrategy.resolveInstanceInvoke(stmt)) {
                    this.addCallIfNotInGraph(stmt, method);
                }
            }
        } else {
            this.addCallIfNotInGraph(stmt, this.resolutionStrategy.resolveStaticInvoke(ie));
        }
    }

    @Override
    public void addCallerListener(CallerListener<Statement, Method> listener) {
        if (!this.callerListeners.put((Object)listener.getObservedCallee(), listener)) {
            return;
        }
        Method method = listener.getObservedCallee();
        logger.debug("Queried for callers of {}.", (Object)method);
        Collection edges = this.demandDrivenCallGraph.edgesInto(method);
        if (edges.size() > 30) {
            logger.debug("Call graph has more than {} caller of {}", (Object)30, (Object)listener.getObservedCallee());
            for (CallGraph.Edge e : edges) {
                logger.trace("\t callsite {}", (Object)e.src());
            }
        }
        for (CallGraph.Edge e : Lists.newArrayList((Iterable)edges)) {
            listener.onCallerAdded(e.src(), method);
        }
    }

    protected boolean addCallIfNotInGraph(Statement caller, Method callee) {
        CallGraph.Edge edge = new CallGraph.Edge(caller, callee);
        if (!this.demandDrivenCallGraph.addEdge(edge)) {
            return false;
        }
        logger.debug("Added call from unit '{}' to method '{}'", (Object)caller, (Object)callee);
        for (Object listener : Lists.newArrayList((Iterable)this.calleeListeners.get((Object)caller))) {
            listener.onCalleeAdded(caller, callee);
        }
        for (Object listener : Lists.newArrayList((Iterable)this.callerListeners.get((Object)callee))) {
            listener.onCallerAdded(caller, callee);
        }
        return true;
    }

    protected void notifyNoCalleeFound(Statement s) {
        for (CalleeListener l : Lists.newArrayList((Iterable)this.calleeListeners.get((Object)s))) {
            l.onNoCalleeFound();
        }
    }

    @Override
    public boolean isCallStmt(Statement unit) {
        return unit.containsInvokeExpr();
    }

    @Override
    public boolean isExitStmt(Statement unit) {
        return unit.getMethod().getControlFlowGraph().getEndPoints().contains(unit);
    }

    @Override
    public boolean isStartPoint(Statement unit) {
        return unit.getMethod().getControlFlowGraph().getStartPoints().contains(unit);
    }

    @Override
    public Collection<Statement> getStartPointsOf(Method m) {
        return m.getControlFlowGraph().getStartPoints();
    }

    @Override
    public Collection<Statement> getEndPointsOf(Method m) {
        return m.getControlFlowGraph().getEndPoints();
    }

    @Override
    public int getNumberOfEdgesTakenFromPrecomputedGraph() {
        return this.numberOfEdgesTakenFromPrecomputedCallGraph;
    }

    @Override
    public void resetCallGraph() {
        this.demandDrivenCallGraph = new CallGraph();
        this.numberOfEdgesTakenFromPrecomputedCallGraph = 0;
        this.calleeListeners.clear();
        this.callerListeners.clear();
    }

    @Override
    public void computeFallback() {
        this.resolutionStrategy.computeFallback(this);
    }

    @Override
    public void addEdges(CallGraph.Edge e) {
        this.demandDrivenCallGraph.addEdge(e);
    }
}

