/*
 * Decompiled with CFR 0.152.
 */
package boomerang;

import boomerang.BoomerangOptions;
import boomerang.flowfunction.DefaultBackwardFlowFunction;
import boomerang.flowfunction.DefaultForwardFlowFunction;
import boomerang.flowfunction.IBackwardFlowFunction;
import boomerang.flowfunction.IForwardFlowFunction;
import boomerang.scene.AllocVal;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.scene.sparse.SparseCFGCache;
import boomerang.stats.IBoomerangStats;
import boomerang.stats.SimpleBoomerangStats;
import com.google.common.base.Joiner;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Optional;

public class DefaultBoomerangOptions
implements BoomerangOptions {
    public boolean isAllocationVal(Val val) {
        if (!this.trackStrings() && val.isStringBufferOrBuilder()) {
            return false;
        }
        if (this.trackNullAssignments() && val.isNull()) {
            return true;
        }
        if (this.getArrayStrategy() != BoomerangOptions.ArrayStrategy.DISABLED && val.isArrayAllocationVal()) {
            return true;
        }
        if (this.trackStrings() && val.isStringConstant()) {
            return true;
        }
        if (!this.trackAnySubclassOfThrowable() && val.isThrowableAllocationType()) {
            return false;
        }
        return val.isNewExpr();
    }

    @Override
    public BoomerangOptions.StaticFieldStrategy getStaticFieldStrategy() {
        return BoomerangOptions.StaticFieldStrategy.SINGLETON;
    }

    @Override
    public BoomerangOptions.ArrayStrategy getArrayStrategy() {
        return BoomerangOptions.ArrayStrategy.INDEX_SENSITIVE;
    }

    @Override
    public boolean typeCheck() {
        return true;
    }

    @Override
    public boolean trackReturnOfInstanceOf() {
        return false;
    }

    @Override
    public boolean onTheFlyCallGraph() {
        return false;
    }

    @Override
    public boolean throwFlows() {
        return false;
    }

    @Override
    public boolean callSummaries() {
        return false;
    }

    @Override
    public boolean fieldSummaries() {
        return false;
    }

    public boolean trackAnySubclassOfThrowable() {
        return false;
    }

    public boolean trackStrings() {
        return true;
    }

    public boolean trackNullAssignments() {
        return true;
    }

    @Override
    public Optional<AllocVal> getAllocationVal(Method m, Statement stmt, Val fact) {
        if (!stmt.isAssign()) {
            return Optional.empty();
        }
        if (!stmt.getLeftOp().equals((Object)fact)) {
            return Optional.empty();
        }
        if (this.isAllocationVal(stmt.getRightOp())) {
            return Optional.of(new AllocVal(stmt.getLeftOp(), stmt, stmt.getRightOp()));
        }
        return Optional.empty();
    }

    @Override
    public int analysisTimeoutMS() {
        return 10000;
    }

    @Override
    public IBoomerangStats statsFactory() {
        return new SimpleBoomerangStats();
    }

    @Override
    public boolean aliasing() {
        return true;
    }

    @Override
    public boolean killNullAtCast() {
        return false;
    }

    @Override
    public boolean trackStaticFieldAtEntryPointToClinit() {
        return false;
    }

    @Override
    public boolean trackFields() {
        return true;
    }

    @Override
    public int maxCallDepth() {
        return -1;
    }

    @Override
    public int maxUnbalancedCallDepth() {
        return -1;
    }

    @Override
    public int maxFieldDepth() {
        return -1;
    }

    @Override
    public boolean onTheFlyControlFlow() {
        return false;
    }

    public String toString() {
        Class<?> cls = this.getClass();
        ArrayList<String> methodToVal = new ArrayList<String>();
        String s = cls.getName();
        for (java.lang.reflect.Method m : cls.getMethods()) {
            String name = m.getName();
            if (name.contains("toString") || m.getParameterCount() != 0) continue;
            try {
                Object val = m.invoke((Object)this, new Object[0]);
                methodToVal.add(name + "=" + val);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        String joined = Joiner.on((String)",").join(methodToVal);
        return "[" + s + "{" + joined + "}]";
    }

    @Override
    public boolean ignoreInnerClassFields() {
        return false;
    }

    @Override
    public boolean trackPathConditions() {
        return false;
    }

    @Override
    public boolean prunePathConditions() {
        return false;
    }

    @Override
    public boolean trackDataFlowPath() {
        return true;
    }

    @Override
    public boolean trackImplicitFlows() {
        return false;
    }

    @Override
    public boolean allowMultipleQueries() {
        return false;
    }

    @Override
    public SparseCFGCache.SparsificationStrategy getSparsificationStrategy() {
        return SparseCFGCache.SparsificationStrategy.NONE;
    }

    @Override
    public boolean handleSpecialInvokeAsNormalPropagation() {
        return false;
    }

    @Override
    public boolean ignoreSparsificationAfterQuery() {
        return true;
    }

    @Override
    public void checkValid() {
        if (!this.trackPathConditions() && this.prunePathConditions()) {
            throw new RuntimeException("InvalidCombinations of Options, Path Conditions must be ables when pruning path conditions");
        }
    }

    @Override
    public boolean handleMaps() {
        return true;
    }

    @Override
    public IForwardFlowFunction getForwardFlowFunctions() {
        return new DefaultForwardFlowFunction(this);
    }

    @Override
    public IBackwardFlowFunction getBackwardFlowFunction() {
        return new DefaultBackwardFlowFunction(this);
    }
}

