/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import crypto.interfaces.ICrySLPredicateParameter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CrySLMethod
implements Serializable,
ICrySLPredicateParameter {
    public static final String VOID = "void";
    public static final String ANY_TYPE = "AnyType";
    public static final String NO_NAME = "_";
    private static final long serialVersionUID = 1L;
    private final String methodName;
    private final Map.Entry<String, String> retObject;
    private final List<Map.Entry<String, String>> parameters;

    public CrySLMethod(String methodName, List<Map.Entry<String, String>> parameters, Map.Entry<String, String> retObject) {
        this.methodName = methodName;
        this.parameters = parameters;
        this.retObject = retObject;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getShortMethodName() {
        return this.methodName.substring(this.methodName.lastIndexOf(".") + 1);
    }

    public List<Map.Entry<String, String>> getParameters() {
        return this.parameters;
    }

    public Map.Entry<String, String> getRetObject() {
        return this.retObject;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        StringBuilder stmntBuilder = new StringBuilder();
        String returnValue = this.retObject.getKey();
        if (!NO_NAME.equals(returnValue)) {
            stmntBuilder.append(returnValue);
            stmntBuilder.append(" = ");
        }
        stmntBuilder.append(this.methodName);
        stmntBuilder.append("(");
        stmntBuilder.append(this.parameters.stream().map(param -> String.format("%s %s", param.getValue(), param.getKey())).collect(Collectors.joining(", ")));
        stmntBuilder.append(");");
        return stmntBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrySLMethod)) {
            return false;
        }
        CrySLMethod other = (CrySLMethod)obj;
        return this.getMethodName().equals(other.getMethodName()) && this.parameters.equals(other.parameters);
    }
}

