/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import boomerang.BackwardQuery;
import boomerang.Query;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.base.CharMatcher;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.CrySLAnalysisListener;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ConstraintError;
import crypto.analysis.errors.ErrorVisitor;
import crypto.analysis.errors.ForbiddenMethodError;
import crypto.analysis.errors.ForbiddenPredicateError;
import crypto.analysis.errors.HardCodedError;
import crypto.analysis.errors.ImpreciseValueExtractionError;
import crypto.analysis.errors.IncompleteOperationError;
import crypto.analysis.errors.NeverTypeOfError;
import crypto.analysis.errors.PredicateContradictionError;
import crypto.analysis.errors.RequiredPredicateError;
import crypto.analysis.errors.TypestateError;
import crypto.analysis.errors.UncaughtExceptionError;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;

public class ErrorMarkerListener
extends CrySLAnalysisListener {
    protected final Table<SootClass, SootMethod, Set<AbstractError>> errorMarkers = HashBasedTable.create();
    protected final Map<Class<?>, Integer> errorMarkerCount = new HashMap();
    protected final List<IAnalysisSeed> secureObjects = new ArrayList<IAnalysisSeed>();

    private void addMarker(AbstractError error) {
        int errorCount;
        SootMethod method = error.getErrorLocation().getMethod();
        SootClass sootClass = method.getDeclaringClass();
        Set set = (Set)this.errorMarkers.get((Object)sootClass, (Object)method);
        if (set == null) {
            set = Sets.newHashSet();
        }
        int n = errorCount = this.errorMarkerCount.get(error.getClass()) == null ? 0 : this.errorMarkerCount.get(error.getClass());
        if (set.add(error)) {
            this.errorMarkerCount.put(error.getClass(), ++errorCount);
        }
        this.errorMarkers.put((Object)sootClass, (Object)method, (Object)set);
    }

    @Override
    public void reportError(AbstractError error) {
        error.accept(new ErrorVisitor(){

            @Override
            public void visit(ConstraintError constraintError) {
                ErrorMarkerListener.this.addMarker(constraintError);
            }

            @Override
            public void visit(ForbiddenMethodError forbiddenMethodError) {
                ErrorMarkerListener.this.addMarker(forbiddenMethodError);
            }

            @Override
            public void visit(IncompleteOperationError incompleteOperationError) {
                ErrorMarkerListener.this.addMarker(incompleteOperationError);
            }

            @Override
            public void visit(TypestateError typestateError) {
                ErrorMarkerListener.this.addMarker(typestateError);
            }

            @Override
            public void visit(RequiredPredicateError predicateError) {
                ErrorMarkerListener.this.addMarker(predicateError);
            }

            @Override
            public void visit(ImpreciseValueExtractionError extractionError) {
                ErrorMarkerListener.this.addMarker(extractionError);
            }

            @Override
            public void visit(NeverTypeOfError neverTypeOfError) {
                ErrorMarkerListener.this.addMarker(neverTypeOfError);
            }

            @Override
            public void visit(PredicateContradictionError predicateContradictionError) {
                ErrorMarkerListener.this.addMarker(predicateContradictionError);
            }

            @Override
            public void visit(UncaughtExceptionError uncaughtExceptionError) {
                ErrorMarkerListener.this.addMarker(uncaughtExceptionError);
            }

            @Override
            public void visit(HardCodedError hardcodedError) {
                ErrorMarkerListener.this.addMarker(hardcodedError);
            }

            @Override
            public void visit(ForbiddenPredicateError forbiddenPredicateError) {
                ErrorMarkerListener.this.addMarker(forbiddenPredicateError);
            }
        });
    }

    @Override
    public void afterAnalysis() {
    }

    @Override
    public void afterConstraintCheck(AnalysisSeedWithSpecification arg0) {
    }

    @Override
    public void afterPredicateCheck(AnalysisSeedWithSpecification arg0) {
    }

    @Override
    public void beforeAnalysis() {
    }

    @Override
    public void beforeConstraintCheck(AnalysisSeedWithSpecification arg0) {
    }

    @Override
    public void beforePredicateCheck(AnalysisSeedWithSpecification arg0) {
    }

    @Override
    public void boomerangQueryFinished(Query arg0, BackwardQuery arg1) {
    }

    @Override
    public void boomerangQueryStarted(Query arg0, BackwardQuery arg1) {
    }

    @Override
    public void checkedConstraints(AnalysisSeedWithSpecification arg0, Collection<ISLConstraint> arg1) {
    }

    @Override
    public void collectedValues(AnalysisSeedWithSpecification arg0, Multimap<CallSiteWithParamIndex, ExtractedValue> arg1) {
    }

    @Override
    public void discoveredSeed(IAnalysisSeed arg0) {
    }

    @Override
    public void ensuredPredicates(Table<Statement, Val, Set<EnsuredCrySLPredicate>> arg0, Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> arg1, Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> arg2) {
    }

    @Override
    public void onSeedFinished(IAnalysisSeed analysisObject, ForwardBoomerangResults<TransitionFunction> arg1) {
    }

    @Override
    public void onSecureObjectFound(IAnalysisSeed analysisObject) {
        this.secureObjects.add(analysisObject);
    }

    @Override
    public void onSeedTimeout(Node<Statement, Val> arg0) {
    }

    @Override
    public void seedStarted(IAnalysisSeed arg0) {
    }

    public static String filterQuotes(String dirty) {
        return CharMatcher.anyOf((CharSequence)"\"").removeFrom((CharSequence)dirty);
    }

    @Override
    public void addProgress(int processedSeeds, int workListsize) {
    }
}

