/*
 * Decompiled with CFR 0.152.
 */
package crypto.preanalysis;

import boomerang.preanalysis.BoomerangPretransformer;
import crypto.preanalysis.CastTransformer;
import crypto.preanalysis.ExceptionAwareTransformer;
import crypto.rules.CrySLRule;
import java.util.List;

public class TransformerSetup {
    private static TransformerSetup instance;

    public void setupPreTransformer(List<CrySLRule> rules) {
        this.setupCastTransformer();
        this.setupExceptionAwareTransformer(rules);
        this.setupBoomerangTransformer();
    }

    public void setupCastTransformer() {
        CastTransformer.v().reset();
        CastTransformer.v().apply();
    }

    public void setupExceptionAwareTransformer(List<CrySLRule> rules) {
        for (CrySLRule rule : rules) {
            ExceptionAwareTransformer transformer = new ExceptionAwareTransformer(rule);
            transformer.apply();
        }
    }

    public void setupBoomerangTransformer() {
        BoomerangPretransformer.v().reset();
        BoomerangPretransformer.v().apply();
    }

    public static TransformerSetup v() {
        if (instance == null) {
            instance = new TransformerSetup();
        }
        return instance;
    }

    public void reset() {
        instance = null;
    }
}

