/*
 * Decompiled with CFR 0.152.
 */
package crypto.constraints;

import boomerang.jimple.Statement;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import crypto.analysis.AlternativeReqPredicate;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.ClassSpecification;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.RequiredCrySLPredicate;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ImpreciseValueExtractionError;
import crypto.constraints.EvaluableConstraint;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLConstraint;
import crypto.rules.CrySLPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import soot.Type;

public class ConstraintSolver {
    public static final List<String> predefinedPreds = Arrays.asList("callTo", "noCallTo", "neverTypeOf", "length", "notHardCoded", "instanceOf");
    private final Set<ISLConstraint> relConstraints = Sets.newHashSet();
    private final List<ISLConstraint> requiredPredicates = Lists.newArrayList();
    private final Collection<Statement> collectedCalls;
    private final CrySLResultsReporter reporter;
    private final AnalysisSeedWithSpecification object;

    public ConstraintSolver(AnalysisSeedWithSpecification object, Collection<Statement> collectedCalls, CrySLResultsReporter crySLResultsReporter) {
        this.object = object;
        this.collectedCalls = collectedCalls;
        this.reporter = crySLResultsReporter;
        this.partitionConstraints();
    }

    public Multimap<CallSiteWithParamIndex, Type> getPropagatedTypes() {
        return this.object.getParameterAnalysis().getPropagatedTypes();
    }

    public Collection<CallSiteWithParamIndex> getParameterAnalysisQuerySites() {
        return this.object.getParameterAnalysis().getAllQuerySites();
    }

    public ClassSpecification getClassSpec() {
        return this.object.getSpec();
    }

    public Collection<Statement> getCollectedCalls() {
        return this.collectedCalls;
    }

    public CrySLResultsReporter getReporter() {
        return this.reporter;
    }

    public AnalysisSeedWithSpecification getObject() {
        return this.object;
    }

    public Multimap<CallSiteWithParamIndex, ExtractedValue> getParsAndVals() {
        return this.object.getParameterAnalysis().getCollectedValues();
    }

    public List<ISLConstraint> getAllConstraints() {
        return this.getClassSpec().getRule().getConstraints();
    }

    public Set<ISLConstraint> getRelConstraints() {
        return this.relConstraints;
    }

    public List<ISLConstraint> getRequiredPredicates() {
        return this.requiredPredicates;
    }

    public int evaluateRelConstraints() {
        int fail = 0;
        block0: for (ISLConstraint con : this.getRelConstraints()) {
            EvaluableConstraint currentConstraint = EvaluableConstraint.getInstance(con, this);
            currentConstraint.evaluate();
            for (AbstractError e : currentConstraint.getErrors()) {
                if (e instanceof ImpreciseValueExtractionError) {
                    this.getReporter().reportError(this.getObject(), new ImpreciseValueExtractionError(con, e.getErrorLocation(), e.getRule()));
                    continue block0;
                }
                ++fail;
                this.object.addError(e);
                this.getReporter().reportError(this.getObject(), e);
            }
        }
        return fail;
    }

    private void partitionConstraints() {
        for (ISLConstraint cons : this.getAllConstraints()) {
            Set<String> involvedVarNames = cons.getInvolvedVarNames();
            for (CallSiteWithParamIndex cwpi : this.getParameterAnalysisQuerySites()) {
                involvedVarNames.remove(cwpi.getVarName());
            }
            if (!involvedVarNames.isEmpty() && (!cons.toString().contains("speccedKey") || involvedVarNames.size() != 1)) continue;
            if (cons instanceof CrySLPredicate) {
                List<RequiredCrySLPredicate> preds = this.retrieveValuesForPred(cons);
                for (RequiredCrySLPredicate pred : preds) {
                    CrySLPredicate innerPred = pred.getPred();
                    if (innerPred == null) continue;
                    this.relConstraints.add(innerPred);
                    this.requiredPredicates.add(pred);
                }
                continue;
            }
            if (cons instanceof CrySLConstraint) {
                ISLConstraint left = ((CrySLConstraint)cons).getLeft();
                if (left instanceof CrySLPredicate && !predefinedPreds.contains(((CrySLPredicate)left).getPredName())) {
                    this.requiredPredicates.addAll(this.collectAlternativePredicates((CrySLConstraint)cons, Lists.newArrayList()));
                    continue;
                }
                this.relConstraints.add(cons);
                continue;
            }
            this.relConstraints.add(cons);
        }
    }

    private List<AlternativeReqPredicate> collectAlternativePredicates(CrySLConstraint cons, List<AlternativeReqPredicate> alts) {
        CrySLPredicate left = (CrySLPredicate)cons.getLeft();
        if (alts.isEmpty()) {
            for (CallSiteWithParamIndex cwpi : this.getParameterAnalysisQuerySites()) {
                for (ICrySLPredicateParameter p : left.getParameters()) {
                    if (p.getName().equals("transformation") || !cwpi.getVarName().equals(p.getName())) continue;
                    alts.add(new AlternativeReqPredicate(left, cwpi.stmt()));
                }
            }
        } else {
            for (AlternativeReqPredicate alt : alts) {
                alt.addAlternative(left);
            }
        }
        if (cons.getRight() instanceof CrySLPredicate) {
            for (AlternativeReqPredicate alt : alts) {
                alt.addAlternative((CrySLPredicate)cons.getRight());
            }
        } else {
            return this.collectAlternativePredicates((CrySLConstraint)cons.getRight(), alts);
        }
        return alts;
    }

    private List<RequiredCrySLPredicate> retrieveValuesForPred(ISLConstraint cons) {
        CrySLPredicate pred = (CrySLPredicate)cons;
        ArrayList result = Lists.newArrayList();
        for (CallSiteWithParamIndex cwpi : this.getParameterAnalysisQuerySites()) {
            for (ICrySLPredicateParameter p : pred.getParameters()) {
                if (p.getName().equals("transformation") || cwpi.getVarName().equals("_") || !cwpi.getVarName().equals(p.getName())) continue;
                result.add(new RequiredCrySLPredicate(pred, cwpi.stmt()));
            }
        }
        if (pred.getParameters().stream().anyMatch(param -> param.getName().equals("this"))) {
            result.add(new RequiredCrySLPredicate(pred, this.object.stmt()));
        }
        return result;
    }
}

