/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.ErrorVisitor;
import crypto.analysis.errors.ErrorWithObjectAllocation;
import crypto.rules.CrySLRule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class IncompleteOperationError
extends ErrorWithObjectAllocation {
    private final Collection<SootMethod> expectedMethodCalls;
    private final Set<String> expectedMethodCallsSet;
    private final boolean multiplePaths;

    public IncompleteOperationError(IAnalysisSeed objectLocation, Statement errorLocation, CrySLRule rule, Collection<SootMethod> expectedMethodsToBeCalled) {
        this(objectLocation, errorLocation, rule, expectedMethodsToBeCalled, false);
    }

    public IncompleteOperationError(IAnalysisSeed objectLocation, Statement errorLocation, CrySLRule rule, Collection<SootMethod> expectedMethodsToBeCalled, boolean multiplePaths) {
        super(errorLocation, rule, objectLocation);
        this.expectedMethodCalls = expectedMethodsToBeCalled;
        this.multiplePaths = multiplePaths;
        this.expectedMethodCallsSet = new HashSet<String>();
        for (SootMethod method : this.expectedMethodCalls) {
            this.expectedMethodCallsSet.add(method.getSignature());
        }
    }

    public Collection<SootMethod> getExpectedMethodCalls() {
        return this.expectedMethodCalls;
    }

    @Override
    public void accept(ErrorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toErrorMarkerString() {
        if (this.multiplePaths) {
            return this.getErrorMarkerStringForMultipleDataflowPaths();
        }
        return this.getErrorMarkerStringForSingleDataflowPath();
    }

    private String getErrorMarkerStringForSingleDataflowPath() {
        StringBuilder msg = new StringBuilder();
        msg.append("Operation");
        msg.append(this.getObjectType());
        msg.append(" not completed. Expected call to ");
        Set<String> altMethods = this.getFormattedExpectedCalls();
        msg.append(Joiner.on((String)", ").join(altMethods));
        return msg.toString();
    }

    private String getErrorMarkerStringForMultipleDataflowPaths() {
        if (!this.getErrorLocation().isCallsite() || !this.getErrorLocation().getUnit().isPresent()) {
            return "Unable to describe error";
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Call to ");
        InvokeExpr invokeExpr = ((Stmt)this.getErrorLocation().getUnit().get()).getInvokeExpr();
        msg.append(invokeExpr.getMethod().getName());
        msg.append(this.getObjectType());
        msg.append(" is on a dataflow path with an incomplete operation. Potential missing call to ");
        Set<String> altMethods = this.getFormattedExpectedCalls();
        msg.append(Joiner.on((String)", ").join(altMethods));
        return msg.toString();
    }

    private Set<String> getFormattedExpectedCalls() {
        HashSet<String> altMethods = new HashSet<String>();
        for (SootMethod expectedCall : this.getExpectedMethodCalls()) {
            if (this.stmtInvokesExpectedCallName(expectedCall.getName())) {
                altMethods.add(expectedCall.getSignature().replace("<", "").replace(">", ""));
                continue;
            }
            altMethods.add(expectedCall.getName().replace("<", "").replace(">", ""));
        }
        return altMethods;
    }

    private boolean stmtInvokesExpectedCallName(String expectedCallName) {
        Statement errorLocation = this.getErrorLocation();
        if (!errorLocation.isCallsite()) {
            return false;
        }
        Optional stmtOptional = errorLocation.getUnit().toJavaUtil();
        if (!stmtOptional.isPresent()) {
            return false;
        }
        Stmt stmt = (Stmt)stmtOptional.get();
        if (stmt.containsInvokeExpr()) {
            InvokeExpr call = stmt.getInvokeExpr();
            SootMethod calledMethod = call.getMethod();
            return calledMethod.getName().equals(expectedCallName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expectedMethodCallsSet == null ? 0 : this.expectedMethodCallsSet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncompleteOperationError other = (IncompleteOperationError)obj;
        return !(this.expectedMethodCalls == null ? other.expectedMethodCalls != null : this.expectedMethodCallsSet != other.expectedMethodCallsSet);
    }

    private int expectedMethodCallsHashCode(Collection<SootMethod> expectedMethodCalls) {
        HashSet expectedMethodCallsSet = Sets.newHashSet();
        for (SootMethod method : expectedMethodCalls) {
            expectedMethodCallsSet.add(method.getSignature());
        }
        return expectedMethodCallsSet.hashCode();
    }
}

