/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import boomerang.ForwardQuery;
import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import crypto.analysis.AlternativeReqPredicate;
import crypto.analysis.AnalysisSeedWithEnsuredPredicate;
import crypto.analysis.ClassSpecification;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.CryptoScanner;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.HiddenPredicate;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.RequiredCrySLPredicate;
import crypto.analysis.ResultsHandler;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.IncompleteOperationError;
import crypto.analysis.errors.RequiredPredicateError;
import crypto.analysis.errors.TypestateError;
import crypto.constraints.ConstraintSolver;
import crypto.constraints.EvaluableConstraint;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractParameterAnalysis;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLCondPredicate;
import crypto.rules.CrySLMethod;
import crypto.rules.CrySLObject;
import crypto.rules.CrySLPredicate;
import crypto.rules.StateNode;
import crypto.rules.TransitionEdge;
import crypto.typestate.CrySLMethodToSootMethod;
import crypto.typestate.ExtendedIDEALAnaylsis;
import crypto.typestate.ReportingErrorStateNode;
import crypto.typestate.SootBasedStateMachineGraph;
import crypto.typestate.WrappedState;
import ideal.IDEALSeedSolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;
import typestate.finiteautomata.ITransition;
import typestate.finiteautomata.State;

public class AnalysisSeedWithSpecification
extends IAnalysisSeed {
    private final ClassSpecification spec;
    private ExtendedIDEALAnaylsis analysis;
    private ForwardBoomerangResults<TransitionFunction> results;
    private Collection<EnsuredCrySLPredicate> ensuredPredicates = Sets.newHashSet();
    private Multimap<Statement, State> typeStateChange = HashMultimap.create();
    private Collection<EnsuredCrySLPredicate> indirectlyEnsuredPredicates = Sets.newHashSet();
    private Set<HiddenPredicate> hiddenPredicates = Sets.newHashSet();
    private ConstraintSolver constraintSolver;
    private boolean internalConstraintsSatisfied;
    protected Map<Statement, SootMethod> allCallsOnObject = Maps.newLinkedHashMap();
    private ExtractParameterAnalysis parameterAnalysis;
    private Set<ResultsHandler> resultHandlers = Sets.newHashSet();
    private boolean secure = true;
    private static final List<String> trackedTypes = Arrays.asList("java.lang.String", "int", "java.lang.Integer");

    public AnalysisSeedWithSpecification(final CryptoScanner cryptoScanner, Statement stmt, Val val, final ClassSpecification spec) {
        super(cryptoScanner, stmt, val, spec.getFSM().getInitialWeight(stmt));
        this.spec = spec;
        this.analysis = new ExtendedIDEALAnaylsis(){

            @Override
            public SootBasedStateMachineGraph getStateMachine() {
                return spec.getFSM();
            }

            @Override
            protected ObservableICFG<Unit, SootMethod> icfg() {
                return cryptoScanner.icfg();
            }

            @Override
            protected Debugger<TransitionFunction> debugger(IDEALSeedSolver<TransitionFunction> solver) {
                return cryptoScanner.debugger(solver, AnalysisSeedWithSpecification.this);
            }

            @Override
            public CrySLResultsReporter analysisListener() {
                return cryptoScanner.getAnalysisListener();
            }
        };
    }

    public String toString() {
        return "AnalysisSeed [" + super.toString() + " with spec " + this.spec.getRule().getClassName() + "]";
    }

    @Override
    public void execute() {
        this.cryptoScanner.getAnalysisListener().seedStarted(this);
        this.runTypestateAnalysis();
        if (this.results == null) {
            return;
        }
        this.allCallsOnObject = this.results.getInvokedMethodOnInstance();
        this.runExtractParameterAnalysis();
        this.internalConstraintsSatisfied = this.checkInternalConstraints();
        this.computeTypestateErrorUnits();
        this.computeTypestateErrorsForEndOfObjectLifeTime();
        this.activateIndirectlyEnsuredPredicates();
        this.checkConstraintsAndEnsurePredicates();
        this.cryptoScanner.getAnalysisListener().onSeedFinished(this, this.results);
        this.cryptoScanner.getAnalysisListener().collectedValues(this, this.parameterAnalysis.getCollectedValues());
    }

    public void registerResultsHandler(ResultsHandler handler) {
        if (this.results != null) {
            handler.done(this.results);
        } else {
            this.resultHandlers.add(handler);
        }
    }

    private void runTypestateAnalysis() {
        this.analysis.run((ForwardQuery)this);
        this.results = this.analysis.getResults();
        if (this.results != null) {
            for (ResultsHandler handler : Lists.newArrayList(this.resultHandlers)) {
                handler.done(this.results);
            }
        }
    }

    private void runExtractParameterAnalysis() {
        this.parameterAnalysis = new ExtractParameterAnalysis(this.cryptoScanner, this.allCallsOnObject, this.spec.getFSM());
        this.parameterAnalysis.run();
    }

    private void computeTypestateErrorUnits() {
        HashSet allTypestateChangeStatements = Sets.newHashSet();
        for (Table.Cell c : this.results.asStatementValWeightTable().cellSet()) {
            allTypestateChangeStatements.addAll(((TransitionFunction)c.getValue()).getLastStateChangeStatements());
        }
        for (Table.Cell c : this.results.asStatementValWeightTable().cellSet()) {
            Statement curr = (Statement)c.getRowKey();
            if (!allTypestateChangeStatements.contains(curr)) continue;
            Collection<? extends State> targetStates = this.getTargetStates((TransitionFunction)c.getValue());
            for (State state : targetStates) {
                this.typeStateChangeAtStatement(curr, state);
            }
        }
    }

    private void computeTypestateErrorsForEndOfObjectLifeTime() {
        Table endPathOfPropagation = this.results.getObjectDestructingStatements();
        HashMap incompleteOperations = new HashMap();
        for (Table.Cell cell : endPathOfPropagation.cellSet()) {
            HashSet<SootMethod> expectedMethodsToBeCalled = new HashSet<SootMethod>();
            for (ITransition n : ((TransitionFunction)cell.getValue()).values()) {
                if (n.to() == null || n.to().isAccepting() || !(n.to() instanceof WrappedState)) continue;
                WrappedState wrappedState = (WrappedState)n.to();
                for (TransitionEdge t : this.spec.getRule().getUsagePattern().getAllTransitions()) {
                    if (!t.getLeft().equals(wrappedState.delegate()) || t.from().equals(t.to())) continue;
                    Collection<SootMethod> converted = CrySLMethodToSootMethod.v().convert(t.getLabel());
                    expectedMethodsToBeCalled.addAll(converted);
                }
            }
            if (expectedMethodsToBeCalled.isEmpty()) continue;
            incompleteOperations.put((Statement)cell.getRowKey(), expectedMethodsToBeCalled);
        }
        if (incompleteOperations.entrySet().isEmpty()) {
            return;
        }
        if (incompleteOperations.entrySet().size() == 1) {
            Map.Entry entry = incompleteOperations.entrySet().iterator().next();
            Statement statement = (Statement)entry.getKey();
            Set methodsToBeCalled = (Set)entry.getValue();
            if (!statement.getUnit().isPresent()) {
                return;
            }
            if (statement.getUnit().get() instanceof ThrowStmt) {
                return;
            }
            IncompleteOperationError incompleteOperationError = new IncompleteOperationError(this, statement, this.spec.getRule(), methodsToBeCalled);
            this.addError(incompleteOperationError);
            this.cryptoScanner.getAnalysisListener().reportError(this, incompleteOperationError);
        }
        if (incompleteOperations.size() > 1) {
            for (Map.Entry entry : incompleteOperations.entrySet()) {
                InvokeExpr invokeExpr;
                Statement statement = (Statement)entry.getKey();
                Set expectedMethodsToBeCalled = (Set)entry.getValue();
                if (!statement.getUnit().isPresent() || statement.getUnit().get() instanceof ThrowStmt || !((Stmt)statement.getUnit().get()).containsInvokeExpr() || this.isMethodToAcceptingState((invokeExpr = ((Stmt)statement.getUnit().get()).getInvokeExpr()).getMethod())) continue;
                IncompleteOperationError incompleteOperationError = new IncompleteOperationError(this, statement, this.spec.getRule(), expectedMethodsToBeCalled, true);
                this.addError(incompleteOperationError);
                this.cryptoScanner.getAnalysisListener().reportError(this, incompleteOperationError);
            }
        }
    }

    private boolean isMethodToAcceptingState(SootMethod method) {
        Collection<TransitionEdge> transitions = this.spec.getRule().getUsagePattern().getAllTransitions();
        Collection<CrySLMethod> methods = CrySLMethodToSootMethod.v().convert(method);
        for (TransitionEdge edge : transitions) {
            if (edge.getLabel().stream().noneMatch(e -> methods.contains(e)) || !edge.to().getAccepting().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void typeStateChangeAtStatement(Statement curr, State stateNode) {
        if (this.typeStateChange.put((Object)curr, (Object)stateNode) && stateNode instanceof ReportingErrorStateNode) {
            ReportingErrorStateNode errorStateNode = (ReportingErrorStateNode)stateNode;
            TypestateError typestateError = new TypestateError(curr, this.getSpec().getRule(), this, errorStateNode.getExpectedCalls());
            this.addError(typestateError);
            this.cryptoScanner.getAnalysisListener().reportError(this, typestateError);
        }
    }

    public void addEnsuredPredicate(EnsuredCrySLPredicate ensPred) {
        if (ensPred instanceof HiddenPredicate) {
            HiddenPredicate hiddenPredicate = (HiddenPredicate)ensPred;
            this.hiddenPredicates.add(hiddenPredicate);
            return;
        }
        if (this.ensuredPredicates.add(ensPred)) {
            this.checkConstraintsAndEnsurePredicates();
        }
    }

    private void checkConstraintsAndEnsurePredicates() {
        boolean satisfiesConstraintSystem = this.isConstraintSystemSatisfied();
        for (CrySLPredicate predToBeEnsured : this.spec.getRule().getPredicates()) {
            boolean isPredicateGeneratingStateAvailable = false;
            for (Map.Entry entry : this.typeStateChange.entries()) {
                State state = (State)entry.getValue();
                if (!this.isPredicateGeneratingState(predToBeEnsured, state) || this.isPredicateNegatingState(predToBeEnsured, state)) continue;
                isPredicateGeneratingStateAvailable = true;
                EnsuredCrySLPredicate ensPred = !satisfiesConstraintSystem && !predToBeEnsured.getConstraint().isPresent() ? new HiddenPredicate(predToBeEnsured, this.parameterAnalysis.getCollectedValues(), this, HiddenPredicate.HiddenPredicateType.ConstraintsAreNotSatisfied) : (predToBeEnsured.getConstraint().isPresent() && !this.isPredConditionSatisfied(predToBeEnsured) ? new HiddenPredicate(predToBeEnsured, this.parameterAnalysis.getCollectedValues(), this, HiddenPredicate.HiddenPredicateType.ConditionIsNotSatisfied) : new EnsuredCrySLPredicate(predToBeEnsured, this.parameterAnalysis.getCollectedValues()));
                this.ensurePredicate(ensPred, (Statement)entry.getKey(), (State)entry.getValue());
            }
            if (this.parameterAnalysis == null || isPredicateGeneratingStateAvailable) continue;
            HiddenPredicate hiddenPredicate = new HiddenPredicate(predToBeEnsured, this.parameterAnalysis.getCollectedValues(), this, HiddenPredicate.HiddenPredicateType.GeneratingStateIsNeverReached);
            for (Map.Entry entry : this.typeStateChange.entries()) {
                this.ensurePredicate(hiddenPredicate, (Statement)entry.getKey(), (State)entry.getValue());
            }
        }
    }

    private void ensurePredicate(EnsuredCrySLPredicate ensuredPred, Statement currStmt, State stateNode) {
        for (ICrySLPredicateParameter predicateParam : ensuredPred.getPredicate().getParameters()) {
            if (!predicateParam.getName().equals("this")) continue;
            this.expectPredicateWhenThisObjectIsInState(ensuredPred, stateNode, currStmt);
        }
        if (!currStmt.isCallsite()) {
            return;
        }
        if (!currStmt.getUnit().isPresent()) {
            return;
        }
        InvokeExpr invokeExpr = ((Stmt)currStmt.getUnit().get()).getInvokeExpr();
        SootMethod invokedMethod = invokeExpr.getMethod();
        Collection<CrySLMethod> convert = CrySLMethodToSootMethod.v().convert(invokedMethod);
        for (CrySLMethod crySLMethod : convert) {
            Map.Entry<String, String> retObject = crySLMethod.getRetObject();
            if (!retObject.getKey().equals("_") && currStmt.getUnit().get() instanceof AssignStmt && this.predicateParameterEquals(ensuredPred.getPredicate().getParameters(), retObject.getKey())) {
                AssignStmt as = (AssignStmt)currStmt.getUnit().get();
                Value leftOp = as.getLeftOp();
                AllocVal val = new AllocVal(leftOp, currStmt.getMethod(), as.getRightOp(), new Statement((Stmt)as, currStmt.getMethod()));
                this.expectPredicateOnOtherObject(ensuredPred, currStmt, (Val)val);
            }
            int i = 0;
            for (Map.Entry<String, String> p : crySLMethod.getParameters()) {
                Value param;
                if (this.predicateParameterEquals(ensuredPred.getPredicate().getParameters(), p.getKey()) && (param = invokeExpr.getArg(i)) instanceof Local) {
                    Val val = new Val(param, currStmt.getMethod());
                    this.expectPredicateOnOtherObject(ensuredPred, currStmt, val);
                }
                ++i;
            }
        }
    }

    private boolean predicateParameterEquals(List<ICrySLPredicateParameter> parameters, String key) {
        for (ICrySLPredicateParameter predicateParam : parameters) {
            if (!key.equals(predicateParam.getName())) continue;
            return true;
        }
        return false;
    }

    private void expectPredicateWhenThisObjectIsInState(EnsuredCrySLPredicate ensuredPred, State stateNode, Statement currStmt) {
        this.predicateHandler.expectPredicate(this, currStmt, ensuredPred.getPredicate());
        for (Table.Cell e : this.results.asStatementValWeightTable().cellSet()) {
            if (!this.containsTargetState((TransitionFunction)e.getValue(), stateNode)) continue;
            this.predicateHandler.addNewPred(this, (Statement)e.getRowKey(), (Val)e.getColumnKey(), ensuredPred);
        }
    }

    private boolean containsTargetState(TransitionFunction value, State stateNode) {
        return this.getTargetStates(value).contains(stateNode);
    }

    private Collection<? extends State> getTargetStates(TransitionFunction value) {
        HashSet res = Sets.newHashSet();
        for (ITransition t : value.values()) {
            if (t.to() == null) continue;
            res.add(t.to());
        }
        return res;
    }

    private void expectPredicateOnOtherObject(EnsuredCrySLPredicate ensPred, Statement currStmt, Val accessGraph) {
        boolean specificationExists = false;
        for (ClassSpecification spec : this.cryptoScanner.getClassSpecifications()) {
            Type baseType;
            if (accessGraph.value() == null || !((baseType = accessGraph.value().getType()) instanceof RefType)) continue;
            RefType refType = (RefType)baseType;
            if (!spec.getRule().getClassName().equals(refType.getSootClass().getName())) continue;
            AnalysisSeedWithSpecification seed = this.cryptoScanner.getOrCreateSeedWithSpec(new AnalysisSeedWithSpecification(this.cryptoScanner, currStmt, accessGraph, spec));
            seed.addEnsuredPredicateFromOtherRule(ensPred);
            this.cryptoScanner.getPredicateHandler().reportForbiddenPredicate(ensPred, currStmt, seed);
            specificationExists = true;
        }
        if (!specificationExists) {
            AnalysisSeedWithEnsuredPredicate seed = this.cryptoScanner.getOrCreateSeed((Node<Statement, Val>)new Node((Object)currStmt, (Object)accessGraph));
            this.predicateHandler.expectPredicate(seed, currStmt, ensPred.getPredicate());
            seed.addEnsuredPredicate(ensPred);
        }
    }

    private void addEnsuredPredicateFromOtherRule(EnsuredCrySLPredicate ensuredCrySLPredicate) {
        this.indirectlyEnsuredPredicates.add(ensuredCrySLPredicate);
        if (this.results == null) {
            return;
        }
        this.activateIndirectlyEnsuredPredicates();
    }

    private void activateIndirectlyEnsuredPredicates() {
        for (EnsuredCrySLPredicate pred : this.indirectlyEnsuredPredicates) {
            EnsuredCrySLPredicate predWithThis;
            List<ICrySLPredicateParameter> parameters = pred.getPredicate().getParameters();
            String specName = this.spec.getRule().getClassName();
            boolean hasThisParameter = parameters.stream().anyMatch(p -> p instanceof CrySLObject && ((CrySLObject)p).getJavaType().equals(specName));
            if (!hasThisParameter) continue;
            List<ICrySLPredicateParameter> updatedParams = parameters.stream().map(p -> p instanceof CrySLObject && ((CrySLObject)p).getJavaType().equals(specName) ? new CrySLObject("this", specName) : p).collect(Collectors.toList());
            CrySLPredicate updatedPred = new CrySLPredicate(null, pred.getPredicate().getPredName(), updatedParams, false);
            if (pred instanceof HiddenPredicate) {
                HiddenPredicate hiddenPredicate = (HiddenPredicate)pred;
                predWithThis = new HiddenPredicate(updatedPred, hiddenPredicate.getParametersToValues(), hiddenPredicate.getGeneratingSeed(), hiddenPredicate.getType());
            } else {
                predWithThis = new EnsuredCrySLPredicate(updatedPred, pred.getParametersToValues());
            }
            this.addEnsuredPredicate(predWithThis);
            for (Table.Cell c : this.results.asStatementValWeightTable().cellSet()) {
                Collection<? extends State> states = this.getTargetStates((TransitionFunction)c.getValue());
                for (State state : states) {
                    if (this.isPredicateNegatingState(predWithThis.getPredicate(), state) || !state.isAccepting()) continue;
                    this.predicateHandler.addNewPred(this, (Statement)c.getRowKey(), (Val)c.getColumnKey(), predWithThis);
                }
            }
        }
    }

    private boolean isPredicateGeneratingState(CrySLPredicate ensPred, State stateNode) {
        if (ensPred instanceof CrySLCondPredicate && this.isConditionalState(((CrySLCondPredicate)ensPred).getConditionalMethods(), stateNode)) {
            return true;
        }
        return !(ensPred instanceof CrySLCondPredicate) && stateNode.isAccepting();
    }

    private boolean isConditionalState(Set<StateNode> conditionalMethods, State state) {
        if (conditionalMethods == null) {
            return false;
        }
        for (StateNode s : conditionalMethods) {
            if (!new WrappedState(s).equals(state)) continue;
            return true;
        }
        return false;
    }

    private boolean isPredicateNegatingState(CrySLPredicate ensPred, State stateNode) {
        for (CrySLPredicate negPred : this.spec.getRule().getNegatedPredicates()) {
            if (!ensPred.getPredName().equals(negPred.getPredName()) || !this.doParametersMatch(ensPred, negPred)) continue;
            if (!(negPred instanceof CrySLCondPredicate)) {
                return true;
            }
            CrySLCondPredicate condNegPred = (CrySLCondPredicate)negPred;
            for (StateNode s : condNegPred.getConditionalMethods()) {
                if (!new WrappedState(s).equals(stateNode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doParametersMatch(CrySLPredicate ensPred, CrySLPredicate negPred) {
        if (ensPred.getParameters().size() != negPred.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < ensPred.getParameters().size(); ++i) {
            CrySLObject ensParameter = (CrySLObject)ensPred.getParameters().get(i);
            CrySLObject negParameter = (CrySLObject)negPred.getParameters().get(i);
            if (ensParameter.getJavaType().equals("null") || negParameter.getJavaType().equals("null") || ensParameter.getJavaType().equals(negParameter.getJavaType())) continue;
            return false;
        }
        return true;
    }

    private boolean checkInternalConstraints() {
        this.cryptoScanner.getAnalysisListener().beforeConstraintCheck(this);
        this.constraintSolver = new ConstraintSolver(this, this.allCallsOnObject.keySet(), this.cryptoScanner.getAnalysisListener());
        this.cryptoScanner.getAnalysisListener().checkedConstraints(this, this.constraintSolver.getRelConstraints());
        boolean constraintsSatisfied = 0 == this.constraintSolver.evaluateRelConstraints();
        this.cryptoScanner.getAnalysisListener().afterConstraintCheck(this);
        return constraintsSatisfied;
    }

    private boolean isConstraintSystemSatisfied() {
        if (this.internalConstraintsSatisfied) {
            this.cryptoScanner.getAnalysisListener().beforePredicateCheck(this);
            boolean requiredPredicatesEnsured = this.checkPredicates().isEmpty();
            this.cryptoScanner.getAnalysisListener().afterPredicateCheck(this);
            return requiredPredicatesEnsured;
        }
        return false;
    }

    public Collection<ISLConstraint> checkPredicates() {
        ArrayList requiredPredicates = Lists.newArrayList();
        for (ISLConstraint con : this.constraintSolver.getRequiredPredicates()) {
            if (ConstraintSolver.predefinedPreds.contains(con instanceof RequiredCrySLPredicate ? ((RequiredCrySLPredicate)con).getPred().getPredName() : ((AlternativeReqPredicate)con).getAlternatives().get(0).getPredName())) continue;
            requiredPredicates.add(con);
        }
        HashSet remainingPredicates = Sets.newHashSet((Iterable)requiredPredicates);
        for (ISLConstraint pred : requiredPredicates) {
            if (pred instanceof RequiredCrySLPredicate) {
                RequiredCrySLPredicate reqPred = (RequiredCrySLPredicate)pred;
                if (reqPred.getPred().isNegated().booleanValue()) {
                    boolean violated = false;
                    for (EnsuredCrySLPredicate ensPred : this.ensuredPredicates) {
                        if (!reqPred.getPred().equals(ensPred.getPredicate()) || !this.doPredsMatch(reqPred.getPred(), ensPred)) continue;
                        violated = true;
                    }
                    if (violated) continue;
                    remainingPredicates.remove(pred);
                    continue;
                }
                for (EnsuredCrySLPredicate ensPred : this.ensuredPredicates) {
                    if (!reqPred.getPred().equals(ensPred.getPredicate()) || !this.doPredsMatch(reqPred.getPred(), ensPred)) continue;
                    remainingPredicates.remove(pred);
                }
                continue;
            }
            if (!(pred instanceof AlternativeReqPredicate)) continue;
            AlternativeReqPredicate alt = (AlternativeReqPredicate)pred;
            List<CrySLPredicate> alternatives = alt.getAlternatives();
            List positives = alternatives.stream().filter(e -> e.isNegated() == false).collect(Collectors.toList());
            List negatives = alternatives.stream().filter(e -> e.isNegated()).collect(Collectors.toList());
            boolean satisfied = false;
            List ensuredNegatives = alternatives.stream().filter(e -> e.isNegated()).collect(Collectors.toList());
            for (EnsuredCrySLPredicate ensPred : this.ensuredPredicates) {
                if (positives.stream().anyMatch(e -> e.equals(ensPred.getPredicate()) && this.doPredsMatch((CrySLPredicate)e, ensPred))) {
                    satisfied = true;
                }
                List violatedNegAlternatives = negatives.stream().filter(e -> e.equals(ensPred.getPredicate()) && this.doPredsMatch((CrySLPredicate)e, ensPred)).collect(Collectors.toList());
                ensuredNegatives.removeAll(violatedNegAlternatives);
            }
            if (!satisfied && ensuredNegatives.isEmpty()) continue;
            remainingPredicates.remove(pred);
        }
        for (ISLConstraint rem : Lists.newArrayList((Iterable)remainingPredicates)) {
            List<CrySLPredicate> altPred;
            if (rem instanceof RequiredCrySLPredicate) {
                RequiredCrySLPredicate singlePred = (RequiredCrySLPredicate)rem;
                if (!this.isPredConditionSatisfied(singlePred.getPred())) continue;
                remainingPredicates.remove(singlePred);
                continue;
            }
            if (!(rem instanceof AlternativeReqPredicate) || !(altPred = ((AlternativeReqPredicate)rem).getAlternatives()).parallelStream().anyMatch(e -> this.isPredConditionSatisfied((CrySLPredicate)e))) continue;
            remainingPredicates.remove(rem);
        }
        return remainingPredicates;
    }

    private boolean isPredConditionSatisfied(CrySLPredicate pred) {
        return pred.getConstraint().map(conditional -> {
            EvaluableConstraint evalCons = EvaluableConstraint.getInstance(conditional, this.constraintSolver);
            evalCons.evaluate();
            return evalCons.hasErrors();
        }).orElse(false);
    }

    public Collection<AbstractError> retrieveErrorsForPredCondition(CrySLPredicate pred) {
        if (!pred.getConstraint().isPresent()) {
            return Collections.emptyList();
        }
        ISLConstraint condition = pred.getConstraint().get();
        return Collections.emptyList();
    }

    private boolean doPredsMatch(CrySLPredicate pred, EnsuredCrySLPredicate ensPred) {
        boolean requiredPredicatesExist = true;
        for (int i = 0; i < pred.getParameters().size(); ++i) {
            String var = pred.getParameters().get(i).getName();
            if (this.isOfNonTrackableType(var)) continue;
            if (pred.getInvolvedVarNames().contains(var)) {
                CrySLObject obj;
                String parameterI = ensPred.getPredicate().getParameters().get(i).getName();
                Collection<Object> actVals = Collections.emptySet();
                Collection<Object> expVals = Collections.emptySet();
                for (CallSiteWithParamIndex cswpi : ensPred.getParametersToValues().keySet()) {
                    if (!cswpi.getVarName().equals(parameterI)) continue;
                    actVals = this.retrieveValueFromUnit(cswpi, ensPred.getParametersToValues().get((Object)cswpi));
                }
                for (CallSiteWithParamIndex cswpi : this.parameterAnalysis.getCollectedValues().keySet()) {
                    if (!cswpi.getVarName().equals(var)) continue;
                    expVals = this.retrieveValueFromUnit(cswpi, this.parameterAnalysis.getCollectedValues().get((Object)cswpi));
                }
                String splitter = "";
                int index = -1;
                if (pred.getParameters().get(i) instanceof CrySLObject && (obj = (CrySLObject)pred.getParameters().get(i)).getSplitter() != null) {
                    splitter = obj.getSplitter().getSplitter();
                    index = obj.getSplitter().getIndex();
                }
                for (String foundVal : expVals) {
                    if (index > -1) {
                        foundVal = foundVal.split(splitter)[index];
                    }
                    actVals = actVals.parallelStream().map(e -> e.toLowerCase()).collect(Collectors.toList());
                    requiredPredicatesExist &= actVals.contains(foundVal.toLowerCase());
                }
                continue;
            }
            requiredPredicatesExist = false;
        }
        return requiredPredicatesExist;
    }

    public void addHiddenPredicatesToError(RequiredPredicateError reqPredError) {
        for (CrySLPredicate pred : reqPredError.getContradictedPredicates()) {
            Collection hiddenPredicatesEnsuringReqPred = this.hiddenPredicates.parallelStream().filter(p -> p.getPredicate().equals(pred) && this.doPredsMatch(pred, (EnsuredCrySLPredicate)p)).collect(Collectors.toList());
            reqPredError.addHiddenPredicates(hiddenPredicatesEnsuringReqPred);
        }
    }

    private Collection<String> retrieveValueFromUnit(CallSiteWithParamIndex cswpi, Collection<ExtractedValue> collection) {
        ArrayList<String> values = new ArrayList<String>();
        for (ExtractedValue q : collection) {
            Value rightSide;
            Unit u = (Unit)q.stmt().getUnit().get();
            if (cswpi.stmt().equals((Object)q.stmt())) {
                if (u instanceof AssignStmt) {
                    values.add(this.retrieveConstantFromValue(((ValueBox)((AssignStmt)u).getRightOp().getUseBoxes().get(cswpi.getIndex())).getValue()));
                    continue;
                }
                values.add(this.retrieveConstantFromValue(((ValueBox)u.getUseBoxes().get(cswpi.getIndex())).getValue()));
                continue;
            }
            if (!(u instanceof AssignStmt) || !((rightSide = ((AssignStmt)u).getRightOp()) instanceof Constant)) continue;
            values.add(this.retrieveConstantFromValue(rightSide));
        }
        return values;
    }

    private String retrieveConstantFromValue(Value val) {
        if (val instanceof StringConstant) {
            return ((StringConstant)val).value;
        }
        if (val instanceof IntConstant || val.getType() instanceof IntType) {
            return val.toString();
        }
        return "";
    }

    private boolean isOfNonTrackableType(String varName) {
        for (Map.Entry<String, String> object : this.spec.getRule().getObjects()) {
            if (!object.getKey().equals(varName) || !trackedTypes.contains(object.getValue())) continue;
            return false;
        }
        return true;
    }

    public ClassSpecification getSpec() {
        return this.spec;
    }

    public ExtractParameterAnalysis getParameterAnalysis() {
        return this.parameterAnalysis;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.spec == null ? 0 : this.spec.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AnalysisSeedWithSpecification other = (AnalysisSeedWithSpecification)((Object)obj);
        return !(this.spec == null ? other.spec != null : !this.spec.equals(other.spec));
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public Set<Node<Statement, Val>> getDataFlowPath() {
        return this.results.getDataFlowPath();
    }

    public Map<Statement, SootMethod> getAllCallsOnObject() {
        return this.allCallsOnObject;
    }
}

