/*
 * Decompiled with CFR 0.152.
 */
package crypto.typestate;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import crypto.cryslhandler.CrySLReaderUtils;
import crypto.rules.CrySLMethod;
import crypto.typestate.CrySLMethodToSootMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;

public class LabeledMatcherTransition
extends MatcherTransition {
    private final Multimap<CrySLMethod, SootMethod> label;
    private final CrySLMethod NO_METHOD = new CrySLMethod("", Collections.emptyList(), CrySLReaderUtils.resolveObject(null));

    public static LabeledMatcherTransition getTransition(State from, Collection<CrySLMethod> label, MatcherTransition.Parameter param, State to, MatcherTransition.Type type) {
        HashMultimap resolvedLabel = HashMultimap.create((int)label.size(), (int)1);
        for (CrySLMethod method : label) {
            resolvedLabel.putAll((Object)method, CrySLMethodToSootMethod.v().convert(method));
        }
        return new LabeledMatcherTransition(from, (Multimap<CrySLMethod, SootMethod>)resolvedLabel, param, to, type);
    }

    public static MatcherTransition getErrorTransition(State from, Collection<SootMethod> matchingMethods, MatcherTransition.Parameter param, State to, MatcherTransition.Type type) {
        return new LabeledMatcherTransition(from, matchingMethods, param, to, type);
    }

    public static boolean matches(SootMethod called, SootMethod declared) {
        if (!called.getName().equals(declared.getName())) {
            return false;
        }
        if (!LabeledMatcherTransition.isSubtype(called.getDeclaringClass(), declared.getDeclaringClass())) {
            return false;
        }
        if (called.getParameterCount() != declared.getParameterCount()) {
            return false;
        }
        return called.getParameterTypes().equals(declared.getParameterTypes());
    }

    public static boolean isSubtype(SootClass child, SootClass parent) {
        if (child.equals(parent)) {
            return true;
        }
        if (child.isInterface()) {
            return parent.isInterface() && Scene.v().getActiveHierarchy().isInterfaceSubinterfaceOf(child, parent);
        }
        return Scene.v().getActiveHierarchy().isClassSubclassOf(child, parent) || child.getInterfaces().contains((Object)parent);
    }

    private LabeledMatcherTransition(State from, Collection<SootMethod> matchingMethods, MatcherTransition.Parameter param, State to, MatcherTransition.Type type) {
        super(from, matchingMethods, param, to, type);
        this.label = HashMultimap.create((int)1, (int)matchingMethods.size());
        this.label.putAll((Object)this.NO_METHOD, matchingMethods);
    }

    private LabeledMatcherTransition(State from, Multimap<CrySLMethod, SootMethod> label, MatcherTransition.Parameter param, State to, MatcherTransition.Type type) {
        super(from, label.values(), param, to, type);
        this.label = label;
    }

    public boolean matches(SootMethod method) {
        for (SootMethod m : this.label.values()) {
            if (!LabeledMatcherTransition.matches(method, m)) continue;
            return true;
        }
        return false;
    }

    public Optional<CrySLMethod> getMatching(SootMethod method) {
        for (Map.Entry m : this.label.entries()) {
            if (!LabeledMatcherTransition.matches(method, (SootMethod)m.getValue())) continue;
            return Optional.of((CrySLMethod)m.getKey());
        }
        return Optional.empty();
    }

    public String toString() {
        return super.toString();
    }
}

