/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import crypto.interfaces.ICrySLPredicateParameter;
import crypto.rules.CrySLLiteral;
import java.util.HashSet;
import java.util.Set;

public class CrySLArithmeticConstraint
extends CrySLLiteral {
    private static final long serialVersionUID = 1L;
    private ArithOp operator;
    private ICrySLPredicateParameter left;
    private ICrySLPredicateParameter right;

    public CrySLArithmeticConstraint(ICrySLPredicateParameter l, ICrySLPredicateParameter r, ArithOp op) {
        this.left = l;
        this.right = r;
        this.operator = op;
    }

    public ArithOp getOperator() {
        return this.operator;
    }

    public ICrySLPredicateParameter getLeft() {
        return this.left;
    }

    public ICrySLPredicateParameter getRight() {
        return this.right;
    }

    public String toString() {
        return this.left + " " + (this.operator.equals((Object)ArithOp.p) ? "+" : (this.operator.equals((Object)ArithOp.m) ? "%" : "-")) + " " + this.right;
    }

    @Override
    public Set<String> getInvolvedVarNames() {
        HashSet<String> varNames = new HashSet<String>();
        String name = this.left.getName();
        if (!this.isIntOrBoolean(name)) {
            varNames.add(name);
        }
        if (!this.isIntOrBoolean(name = this.right.getName())) {
            varNames.add(name);
        }
        return varNames;
    }

    private boolean isIntOrBoolean(String name) {
        try {
            Integer.parseInt(name);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return name.equalsIgnoreCase("false") || name.equalsIgnoreCase("true");
        }
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public static enum ArithOp {
        p,
        n,
        m;

    }
}

