/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import com.google.common.collect.Table;
import crypto.HeadlessCryptoScanner;
import crypto.analysis.errors.AbstractError;
import crypto.reporting.CommandLineReporter;
import crypto.rules.CrySLRule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import soot.SootClass;
import soot.tagkit.Host;

public class GitHubAnnotationReporter
extends CommandLineReporter {
    private final String basePath = GitHubAnnotationReporter.getInput("basePath");

    public GitHubAnnotationReporter(String softwareID, List<CrySLRule> rules, long callgraphConstructionTime, boolean includeStatistics) {
        super(softwareID, rules, callgraphConstructionTime, includeStatistics);
    }

    @Override
    public void handleAnalysisResults() {
        System.out.println("::group::Annotations");
        for (Table.Cell cell : this.errorMarkers.cellSet()) {
            SootClass clazz = (SootClass)cell.getRowKey();
            Path path = this.classToSourcePath(clazz);
            boolean sourceExists = Files.exists(path, new LinkOption[0]);
            for (AbstractError error : (Set)cell.getValue()) {
                Integer column;
                String title = error.getClass().getSimpleName() + " violating CrySL rule for " + error.getRule().getClassName();
                Integer line = (Integer)error.getErrorLocation().getUnit().transform(Host::getJavaSourceStartLineNumber).or((Object)-1);
                if (line == -1) {
                    line = null;
                }
                if ((column = (Integer)error.getErrorLocation().getUnit().transform(Host::getJavaSourceStartColumnNumber).or((Object)-1)) == -1) {
                    column = null;
                }
                if (sourceExists) {
                    ActionsAnnotation.printAnnotation(error.toErrorMarkerString(), title, path.toString(), line, null, column, null);
                    continue;
                }
                StringBuilder message = new StringBuilder(error.toErrorMarkerString());
                if (line != null) {
                    message.append(System.lineSeparator()).append("at line ").append(line);
                }
                if (column != null) {
                    message.append(System.lineSeparator()).append("at column ").append(column);
                }
                message.append(System.lineSeparator()).append(System.lineSeparator()).append("Corresponding source file could not be found (at ").append(path).append("). The base path might be set incorrectly.");
                ActionsAnnotation.printAnnotation(message.toString(), title, null, null, null, null, null);
            }
        }
        StringBuilder summary = new StringBuilder();
        summary.append(String.format("Number of CrySL rules: %s\n", this.getRules().size()));
        summary.append(String.format("Number of Objects Analyzed: %s\n", this.getObjects().size()));
        int errorCount = this.errorMarkerCount.values().stream().reduce(0, Integer::sum);
        summary.append(String.format("Number of violations: %s\n", errorCount));
        if (this.includeStatistics() && this.statistics != null) {
            summary.append("\nAdditional analysis statistics:\n");
            summary.append(String.format("SoftwareID: %s\n", this.statistics.getSoftwareID()));
            summary.append(String.format("SeedObjectCount: %d\n", this.statistics.getSeedObjectCount()));
            summary.append(String.format("CryptoAnalysisTime (in ms): %d\n", this.statistics.getAnalysisTime()));
            summary.append(String.format("CallgraphConstructionTime (in ms): %d\n", this.statistics.getCallgraphTime()));
            summary.append(String.format("CallgraphReachableMethods: %d\n", this.statistics.getCallgraphReachableMethods()));
            summary.append(String.format("CallgraphReachableMethodsWithActiveBodies: %d\n", this.statistics.getCallgraphReachableMethodsWithActiveBodies()));
            summary.append(String.format("DataflowVisitedMethods: %d\n", this.statistics.getDataflowVisitedMethods()));
        }
        if (errorCount > 10) {
            String missingAnnotationsMessage = "There are more violations than the GitHub annotations interface displays. Please check the log for additional violations.";
            System.out.println("::warning ::" + missingAnnotationsMessage);
            summary.append("\nWarning: ").append(missingAnnotationsMessage).append("\n");
        }
        GitHubAnnotationReporter.setSummary(summary.toString());
        if (errorCount != 0) {
            HeadlessCryptoScanner.exitCode = 1;
        }
        System.out.println("::endgroup::");
        super.handleAnalysisResults();
    }

    private Path classToSourcePath(SootClass clazz) {
        return Paths.get(this.basePath, clazz.getName().replace('.', File.separatorChar) + ".java");
    }

    private static String getInput(String name) {
        name = name.replaceAll(" ", "_");
        name = "INPUT_" + name.toUpperCase(Locale.ROOT);
        return System.getenv(name);
    }

    private static void setSummary(String summary) {
        String filePath = System.getenv("GITHUB_STEP_SUMMARY");
        try {
            Files.write(Paths.get(filePath, new String[0]), summary.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);
        }
        catch (IOException | NullPointerException e) {
            throw new IllegalStateException("Exception while trying to write to GITHUB_STEP_SUMMARY file. Make sure you are running inside GitHub Actions.", e);
        }
    }

    private static class ActionsAnnotation {
        private ActionsAnnotation() {
        }

        public static void printAnnotation(@Nonnull String message, @Nullable String title, @Nullable String file, @Nullable Integer startLine, @Nullable Integer endLine, @Nullable Integer startColumn, @Nullable Integer endColumn) throws IllegalArgumentException {
            Objects.requireNonNull(message);
            if (endLine != null && startLine == null) {
                throw new IllegalArgumentException("Invalid annotation. `startLine` needs to be set if `endLine` was provided.");
            }
            if (endColumn != null && startColumn == null) {
                throw new IllegalArgumentException("Invalid annotation. `startColumn` needs to be set if `endColumn` was provided.");
            }
            if (startColumn != null && startLine == null) {
                throw new IllegalArgumentException("Invalid annotation. `startLine` needs to be set if `startColumn` was provided.");
            }
            if (endLine != null && !Objects.equals(startLine, endLine) && startColumn != null) {
                throw new IllegalArgumentException("Invalid annotation. `startColumn` can't be set when `startLine` and `endLine` have different values.");
            }
            if (startLine != null && endLine != null && startLine > endLine) {
                throw new IllegalArgumentException("Invalid annotation. `startLine` can't have a higher value than `endLine`.");
            }
            if (startColumn != null && endColumn != null && startColumn > endColumn) {
                throw new IllegalArgumentException("Invalid annotation. `startColumn` can't have a higher value than `endColumn`.");
            }
            ActionsAnnotation.print(message, title, file, startLine, endLine, startColumn, endColumn);
        }

        private static void print(@Nonnull String message, @Nullable String title, @Nullable String file, @Nullable Integer startLine, @Nullable Integer endLine, @Nullable Integer startColumn, @Nullable Integer endColumn) {
            StringBuilder builder = new StringBuilder();
            builder.append("::").append("error").append(' ');
            StringJoiner properties = new StringJoiner(",");
            if (title != null) {
                properties.add("title=" + ActionsAnnotation.escapeParameter(title));
            }
            if (file != null) {
                properties.add("file=" + ActionsAnnotation.escapeParameter(file));
            }
            if (startLine != null) {
                properties.add("line=" + ActionsAnnotation.escapeParameter(String.valueOf(startLine)));
            }
            if (endLine != null) {
                properties.add("endLine=" + ActionsAnnotation.escapeParameter(String.valueOf(endLine)));
            }
            if (startColumn != null) {
                properties.add("col=" + ActionsAnnotation.escapeParameter(String.valueOf(startColumn)));
            }
            if (endColumn != null) {
                properties.add("endColumn=" + ActionsAnnotation.escapeParameter(String.valueOf(endColumn)));
            }
            builder.append(properties);
            builder.append("::").append(ActionsAnnotation.escapeMessage(message));
            System.out.println(builder);
        }

        private static String escapeParameter(String property) {
            return property.replaceAll("%", "%25").replaceAll("\r", "%0D").replaceAll("\n", "%0A").replaceAll(":", "%3A").replaceAll(",", "%2C");
        }

        private static String escapeMessage(String data) {
            return data.replaceAll("%", "%25").replaceAll("\r", "%0D").replaceAll("\n", "%0A");
        }
    }
}

