/*
 * Decompiled with CFR 0.152.
 */
package crypto.providerdetection;

import boomerang.BackwardQuery;
import boomerang.Boomerang;
import boomerang.BoomerangOptions;
import boomerang.DefaultBoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.BackwardBoomerangResults;
import boomerang.seedfactory.SeedFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import crypto.exceptions.CryptoAnalysisException;
import crypto.rules.CrySLRule;
import crypto.rules.CrySLRuleReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JIfStmt;
import soot.jimple.internal.JStaticInvokeExpr;
import wpds.impl.Weight;

public class ProviderDetection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderDetection.class);
    private String provider = null;
    private String rulesDirectory = null;
    private final CrySLRuleReader reader;
    private static final String BOUNCY_CASTLE = "BouncyCastle";
    private static final String[] PROVIDER_VALUES = new String[]{"BC", "BCPQC", "BCJSSE"};
    private static final Set<String> SUPPORTED_PROVIDERS = new HashSet<String>(Arrays.asList(PROVIDER_VALUES));

    public ProviderDetection() {
        this(new CrySLRuleReader());
    }

    public ProviderDetection(CrySLRuleReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        this.reader = reader;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getRulesDirectory() {
        return this.rulesDirectory;
    }

    protected void setRulesDirectory(String rulesDirectory) {
        this.rulesDirectory = rulesDirectory;
    }

    public String doAnalysis(ObservableICFG<Unit, SootMethod> observableDynamicICFG, String rootRulesDirectory) {
        for (SootClass sootClass : Scene.v().getApplicationClasses()) {
            for (SootMethod sootMethod : sootClass.getMethods()) {
                if (!sootMethod.hasActiveBody()) continue;
                Body body = sootMethod.getActiveBody();
                for (Unit unit : body.getUnits()) {
                    JAssignStmt statement;
                    Value rightSideOfStatement;
                    if (!(unit instanceof JAssignStmt) || !((rightSideOfStatement = (statement = (JAssignStmt)unit).getRightOp()) instanceof JStaticInvokeExpr)) continue;
                    JStaticInvokeExpr expression = (JStaticInvokeExpr)rightSideOfStatement;
                    SootMethod method = expression.getMethod();
                    String methodName = method.getName();
                    SootClass declaringClass = method.getDeclaringClass();
                    String declaringClassName = declaringClass.toString();
                    declaringClassName = declaringClassName.substring(declaringClassName.lastIndexOf(".") + 1);
                    int methodParameterCount = method.getParameterCount();
                    if (!methodName.matches("getInstance") || methodParameterCount != 2) continue;
                    Value providerValue = expression.getArg(1);
                    String providerType = this.getProviderType(providerValue);
                    if (providerType.matches("java.security.Provider")) {
                        this.provider = this.getProviderWhenTypeProvider(statement, sootMethod, providerValue, observableDynamicICFG);
                        if (this.provider == null || !this.rulesExist(rootRulesDirectory + File.separator + this.provider)) continue;
                        this.rulesDirectory = rootRulesDirectory + File.separator + this.provider;
                        return this.provider;
                    }
                    if (!providerType.matches("java.lang.String")) continue;
                    if (SUPPORTED_PROVIDERS.contains(providerValue.toString().replaceAll("\"", "")) && providerValue.toString().replaceAll("\"", "").contains("BC")) {
                        return "BouncyCastle-JCA";
                    }
                    this.provider = this.getProviderWhenTypeString(providerValue, body);
                    boolean ifStmt = this.checkIfStmt(providerValue, body);
                    boolean switchStmt = this.checkSwitchStmt(providerValue, body);
                    if (ifStmt || switchStmt || this.provider == null || !this.rulesExist(rootRulesDirectory + File.separator + this.provider)) continue;
                    this.rulesDirectory = rootRulesDirectory + File.separator + this.provider;
                    return this.provider;
                }
            }
        }
        return this.provider;
    }

    private String getProviderType(Value providerValue) {
        String providerType = providerValue.getType().toString();
        return providerType;
    }

    private String getProviderWhenTypeProvider(JAssignStmt statement, SootMethod sootMethod, Value providerValue, final ObservableICFG<Unit, SootMethod> observableDynamicICFG) {
        String provider = null;
        Boomerang solver = new Boomerang((BoomerangOptions)new DefaultBoomerangOptions(){

            public boolean onTheFlyCallGraph() {
                return false;
            }
        }){

            public ObservableICFG<Unit, SootMethod> icfg() {
                return observableDynamicICFG;
            }

            public SeedFactory<Weight.NoWeight> getSeedFactory() {
                return null;
            }
        };
        HashMap map = Maps.newHashMap();
        for (Unit unit : observableDynamicICFG.getPredsOf((Object)statement)) {
            BackwardQuery query = new BackwardQuery(new Statement((Stmt)unit, sootMethod), new Val(providerValue, sootMethod));
            BackwardBoomerangResults backwardQueryResults = solver.solve(query);
            map.putAll(backwardQueryResults.getAllocationSites());
        }
        if (map.size() == 1) {
            for (Map.Entry entry : map.entrySet()) {
                ForwardQuery forwardQuery = (ForwardQuery)entry.getKey();
                Val forwardQueryVal = forwardQuery.var();
                Value value = forwardQueryVal.value();
                Type valueType = value.getType();
                String valueTypeString = valueType.toString();
                if (!valueTypeString.contains(BOUNCY_CASTLE)) continue;
                provider = "BouncyCastle-JCA";
            }
        } else if (map.size() > 1) {
            LOGGER.error("The provider parameter must be passed directly to the getInstance() method call, and not through IF-ELSE, SWITCH statements or TERNARY operators.");
        } else {
            LOGGER.error("Error occured to detect provider in the Provider Detection analysis.");
        }
        return provider;
    }

    private String getProviderWhenTypeString(Value providerValue, Body body) {
        for (Unit unit : body.getUnits()) {
            String provider;
            JAssignStmt assignStatement;
            if (!(unit instanceof JAssignStmt) || !(assignStatement = (JAssignStmt)unit).getLeftOp().equals(providerValue) || !(provider = assignStatement.getRightOp().toString().replaceAll("\"", "")).equals("BC") && !provider.equals("BCPQC") && !provider.equals("BCJSSE")) continue;
            provider = "BouncyCastle-JCA";
            return provider;
        }
        return null;
    }

    private boolean checkIfStmt(Value providerValue, Body body) {
        String value = providerValue.toString();
        for (Unit unit : body.getUnits()) {
            JIfStmt ifStatement;
            if (!(unit instanceof JIfStmt) || !(ifStatement = (JIfStmt)unit).toString().contains(value)) continue;
            LOGGER.error("The provider parameter must be passed directly to the getInstance() method call, and not through IF-ELSE statements or TERNARY operators.");
            return true;
        }
        return false;
    }

    private boolean checkSwitchStmt(Value providerValue, Body body) {
        String value = providerValue.toString();
        for (Unit unit : body.getUnits()) {
            TableSwitchStmt switchStatement;
            if (!(unit instanceof TableSwitchStmt) || !(switchStatement = (TableSwitchStmt)unit).toString().contains(value)) continue;
            LOGGER.error("The provider parameter must be passed directly to the getInstance() method call, and not through SWITCH statements.");
            return true;
        }
        return false;
    }

    private boolean rulesExist(String providerRulesDirectory) {
        File rulesDirectory = new File(providerRulesDirectory);
        return rulesDirectory.exists();
    }

    public List<CrySLRule> chooseRules(String providerRulesDirectory) {
        ArrayList rules = Lists.newArrayList();
        this.rulesDirectory = providerRulesDirectory;
        try {
            rules.addAll(this.reader.readFromDirectory(new File(providerRulesDirectory)));
        }
        catch (CryptoAnalysisException e) {
            LOGGER.error("Error happened when getting the CrySL rules from the specified directory: " + providerRulesDirectory, (Throwable)e);
        }
        return rules;
    }

    public List<CrySLRule> chooseRulesZip(String providerRulesZip) {
        ArrayList rules = Lists.newArrayList();
        this.rulesDirectory = providerRulesZip;
        try {
            rules.addAll(this.reader.readFromZipFile(new File(providerRulesZip)));
        }
        catch (CryptoAnalysisException e) {
            LOGGER.error("Error happened when getting the CrySL rules from the specified zip file: " + providerRulesZip, (Throwable)e);
        }
        return rules;
    }
}

