/*
 * Decompiled with CFR 0.152.
 */
package crypto.cryslhandler;

import com.google.common.base.Splitter;
import crypto.HeadlessCryptoScanner;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrySLModelReaderClassPath {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadlessCryptoScanner.class);
    private static final URL[] javaRuntimeClassPath;
    private final Set<URL> virtualClassPath;
    public static final CrySLModelReaderClassPath JAVA_CLASS_PATH;

    private CrySLModelReaderClassPath() {
        this.virtualClassPath = Collections.emptySet();
    }

    public CrySLModelReaderClassPath(Set<URL> virtualClassPath) {
        this.virtualClassPath = virtualClassPath;
    }

    public static CrySLModelReaderClassPath createFromPaths(Collection<Path> virtualClassPath) {
        Set<URL> urlClassPath = virtualClassPath.stream().map(it -> {
            try {
                return it.toAbsolutePath().toUri().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Unable to get URL from virtual classpath element '" + it.toAbsolutePath() + "'.", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        return new CrySLModelReaderClassPath(urlClassPath);
    }

    public static CrySLModelReaderClassPath createFromURIs(Collection<URI> virtualClassPath) {
        Set<URL> urlClassPath = virtualClassPath.stream().map(it -> {
            try {
                return it.toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Unable to get URL from virtual classpath element '" + it + "'.", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        return new CrySLModelReaderClassPath(urlClassPath);
    }

    public URL[] getClassPath() {
        if (this.virtualClassPath.size() == 0) {
            return (URL[])javaRuntimeClassPath.clone();
        }
        HashSet<URL> classPath = new HashSet<URL>();
        classPath.addAll(Arrays.asList(javaRuntimeClassPath));
        classPath.addAll(this.virtualClassPath);
        return classPath.toArray(new URL[0]);
    }

    static {
        JAVA_CLASS_PATH = new CrySLModelReaderClassPath();
        List runtimeClassPath = Splitter.on((char)File.pathSeparatorChar).splitToList((CharSequence)System.getProperty("java.class.path"));
        javaRuntimeClassPath = (URL[])runtimeClassPath.stream().map(it -> {
            try {
                return new File((String)it).toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Unable to get URL from java classpath element '" + it + "'.", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
    }
}

