/*
 * Decompiled with CFR 0.152.
 */
package crypto.constraints;

import boomerang.jimple.Statement;
import crypto.analysis.errors.UncaughtExceptionError;
import crypto.constraints.ConstraintSolver;
import crypto.constraints.EvaluableConstraint;
import crypto.rules.CrySLExceptionConstraint;
import crypto.typestate.CrySLMethodToSootMethod;
import crypto.typestate.LabeledMatcherTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.Stmt;

public class ExceptionConstraint
extends EvaluableConstraint {
    private final Set<SootMethod> method;
    private final SootClass exception;

    public ExceptionConstraint(CrySLExceptionConstraint cons, ConstraintSolver context) {
        super(cons, context);
        this.method = new HashSet<SootMethod>(CrySLMethodToSootMethod.v().convert(cons.getMethod()));
        this.exception = Scene.v().getSootClass(cons.getException().getException());
    }

    @Override
    public void evaluate() {
        for (Statement call : this.context.getCollectedCalls()) {
            this.evaluate(call);
        }
    }

    public void evaluate(Statement call) {
        try {
            Stmt stmt = (Stmt)call.getUnit().get();
            if (!this.isSameMethod(stmt.getInvokeExpr().getMethod())) {
                return;
            }
            if (!ExceptionConstraint.getTrap(call.getMethod().getActiveBody(), (Unit)stmt, this.exception).isPresent()) {
                this.errors.add(new UncaughtExceptionError(call, this.context.getClassSpec().getRule(), this.exception));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean trapsUnit(Body body, Trap trap, Unit trapped) {
        boolean begun = false;
        for (Unit unit : ExceptionConstraint.getUnits(body)) {
            if (unit.equals(trap.getEndUnit())) break;
            if (unit.equals(trap.getBeginUnit())) {
                begun = true;
            }
            if (!begun || !unit.equals(trapped)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Trap> getTrap(Body body, Unit unit, SootClass exception) {
        for (Trap trap : body.getTraps()) {
            if (!ExceptionConstraint.isCaughtAs(trap.getException(), exception) || !ExceptionConstraint.trapsUnit(body, trap, unit)) continue;
            return Optional.of(trap);
        }
        return Optional.empty();
    }

    public static Collection<Unit> getUnits(Body body) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (Unit item : body.getUnits()) {
            ExceptionConstraint.getAllUnits(item, units);
        }
        return units;
    }

    private static Collection<Unit> getAllUnits(Unit unit, Collection<Unit> units) {
        if (unit == null) {
            return units;
        }
        units.add(unit);
        for (UnitBox item : unit.getUnitBoxes()) {
            ExceptionConstraint.getAllUnits(item.getUnit(), units);
        }
        return units;
    }

    public static boolean isCaughtAs(SootClass catchClause, SootClass exception) {
        return LabeledMatcherTransition.isSubtype(exception, catchClause);
    }

    public boolean isSameMethod(SootMethod method) {
        return this.method.stream().anyMatch(declared -> LabeledMatcherTransition.matches(method, declared));
    }
}

