/*
 * Decompiled with CFR 0.152.
 */
package crypto.constraints;

import crypto.constraints.ConstraintSolver;
import crypto.constraints.EvaluableConstraint;
import crypto.rules.CrySLConstraint;

class BinaryConstraint
extends EvaluableConstraint {
    public BinaryConstraint(CrySLConstraint origin, ConstraintSolver context) {
        super(origin, context);
    }

    @Override
    public void evaluate() {
        CrySLConstraint binaryConstraint = (CrySLConstraint)this.origin;
        EvaluableConstraint left = EvaluableConstraint.getInstance(binaryConstraint.getLeft(), this.context);
        EvaluableConstraint right = EvaluableConstraint.getInstance(binaryConstraint.getRight(), this.context);
        left.evaluate();
        CrySLConstraint.LogOps ops = binaryConstraint.getOperator();
        if (ops.equals((Object)CrySLConstraint.LogOps.implies)) {
            if (left.hasErrors()) {
                return;
            }
            right.evaluate();
            this.errors.addAll(right.getErrors());
            return;
        }
        if (ops.equals((Object)CrySLConstraint.LogOps.or)) {
            right.evaluate();
            this.errors.addAll(left.getErrors());
            this.errors.addAll(right.getErrors());
            return;
        }
        if (ops.equals((Object)CrySLConstraint.LogOps.and)) {
            if (left.hasErrors()) {
                this.errors.addAll(left.getErrors());
                return;
            }
            right.evaluate();
            this.errors.addAll(right.getErrors());
            return;
        }
        if (ops.equals((Object)CrySLConstraint.LogOps.eq)) {
            right.evaluate();
            if (left.hasErrors() && right.hasErrors() || !left.hasErrors() && !right.hasErrors()) {
                return;
            }
            this.errors.addAll(right.getErrors());
            return;
        }
        this.errors.addAll(left.getErrors());
    }
}

