/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import com.google.common.io.Files;
import crypto.exceptions.CryptoAnalysisParserException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true)
public class CryptoScannerSettings
implements Callable<Integer> {
    @CommandLine.Option(names={"--appPath"}, description={"The path to the jar file to be analyzed"}, required=true)
    private String appPath = null;
    @CommandLine.Option(names={"--rulesDir"}, description={"The path to the ruleset directory. Can be a simple directory or a ZIP file. If you areusing a ZIP file, please make sure that the path ends with '.zip'"}, required=true)
    private String rulesDir = null;
    @CommandLine.Option(names={"--cg"}, description={"The call graph to resolve method calls. Possible values are CHA, SPARK and SPARKLIB (default: CHA)"})
    private String cg = null;
    @CommandLine.Option(names={"--sootPath"}, description={"The absolute path of the whole project"})
    private String sootPath = "";
    @CommandLine.Option(names={"--identifier"}, description={"An identifier for the analysis to label output files"})
    private String identifier = "";
    @CommandLine.Option(names={"--reportPath"}, description={"Path for a directory to write the reports into"})
    private String reportPath = null;
    @CommandLine.Option(names={"--reportFormat"}, split=",", description={"The format of the report. Possible values are CMD, TXT, SARIF, CSV and CSV_SUMMARY (default: CMD). Multiple formats should be split with a comma (e.g. CMD,TXT,CSV)"})
    private String[] reportFormat = null;
    @CommandLine.Option(names={"--preanalysis"}, description={"Enable a preanalysis"})
    private boolean preanalysis = false;
    @CommandLine.Option(names={"--visualization"}, description={"Enable visualization"})
    private boolean visualization = false;
    @CommandLine.Option(names={"--providerdetection"}, description={"Enable provider detection"})
    private boolean providerdetection = false;
    @CommandLine.Option(names={"--dstats"}, description={"Disable the output of analysis statistics in the reports"})
    private boolean includeStatistics = true;
    @CommandLine.Option(names={"--forbiddenPredicates"}, description={"Facilitates the specification of forbidden predicates. Any occurrence will be flagged by the analysis. This input expects a path to a file containing one predicate per line"})
    private String forbiddenPredicatesPath = null;
    @CommandLine.Option(names={"--ignoreSections"}, description={"Names of packages, classes and methods to be ignored during the analysis. This input expects path to a file containing one name per line. For example, 'de.example.testClass' ignores the class 'testClass', 'de.example.exampleClass.exampleMethod ignores the method 'exampleMethod' in 'exampleClass', and 'de.example.*' ignores all classes and methods in the package 'example'. Using this option may increase the analysis performance. Note that constructors are methods that can be specified with '<init>'."})
    private String ignoreSectionsPath = null;
    private ControlGraph controlGraph = ControlGraph.CHA;
    private RulesetPathType rulesetPathType = RulesetPathType.NONE;
    private Set<ReportFormat> reportFormats = new HashSet<ReportFormat>(Arrays.asList(ReportFormat.CMD));
    private Collection<String> forbiddenPredicates = new ArrayList<String>();
    private Collection<String> ignoredSections = new ArrayList<String>();

    public void parseSettingsFromCLI(String[] settings) throws CryptoAnalysisParserException {
        CommandLine parser = new CommandLine((Object)this);
        parser.setOptionsCaseInsensitive(true);
        int exitCode = parser.execute(settings);
        this.rulesetPathType = this.isZipFile(this.rulesDir) ? RulesetPathType.ZIP : RulesetPathType.DIR;
        if (this.cg != null) {
            this.parseControlGraphValue(this.cg);
        }
        if (this.reportFormat != null) {
            this.parseReportFormatValues(this.reportFormat);
        }
        if (this.forbiddenPredicatesPath != null) {
            this.parseForbiddenPredicates(this.forbiddenPredicatesPath);
        }
        if (this.ignoreSectionsPath != null) {
            this.parseIgnoredSections(this.ignoreSectionsPath);
        }
        if (exitCode != 0) {
            throw new CryptoAnalysisParserException("Error while parsing the CLI arguments");
        }
    }

    public ControlGraph getControlGraph() {
        return this.controlGraph;
    }

    public RulesetPathType getRulesetPathType() {
        return this.rulesetPathType;
    }

    public String getRulesetPathDir() {
        return this.rulesDir;
    }

    public String getSootPath() {
        return this.sootPath;
    }

    public String getApplicationPath() {
        return this.appPath;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getReportDirectory() {
        return this.reportPath;
    }

    public Set<ReportFormat> getReportFormats() {
        return this.reportFormats;
    }

    public boolean isPreAnalysis() {
        return this.preanalysis;
    }

    public boolean isVisualization() {
        return this.visualization;
    }

    public boolean isProviderDetectionAnalysis() {
        return this.providerdetection;
    }

    public boolean isIncludeStatistics() {
        return this.includeStatistics;
    }

    public Collection<String> getForbiddenPredicates() {
        return this.forbiddenPredicates;
    }

    public Collection<String> getIgnoredSections() {
        return this.ignoredSections;
    }

    private void parseControlGraphValue(String value) throws CryptoAnalysisParserException {
        String CGValue;
        switch (CGValue = value.toLowerCase()) {
            case "cha": {
                this.controlGraph = ControlGraph.CHA;
                break;
            }
            case "spark": {
                this.controlGraph = ControlGraph.SPARK;
                break;
            }
            case "sparklib": {
                this.controlGraph = ControlGraph.SPARKLIB;
                break;
            }
            default: {
                throw new CryptoAnalysisParserException("Incorrect value " + CGValue + " for --cg option. Available options are: CHA, SPARK and SPARKLIB.\n");
            }
        }
    }

    private void parseReportFormatValues(String[] settings) throws CryptoAnalysisParserException {
        this.reportFormats = new HashSet<ReportFormat>();
        block16: for (String format : settings) {
            String reportFormatValue;
            switch (reportFormatValue = format.toLowerCase()) {
                case "cmd": {
                    this.reportFormats.add(ReportFormat.CMD);
                    continue block16;
                }
                case "txt": {
                    this.reportFormats.add(ReportFormat.TXT);
                    continue block16;
                }
                case "sarif": {
                    this.reportFormats.add(ReportFormat.SARIF);
                    continue block16;
                }
                case "csv": {
                    this.reportFormats.add(ReportFormat.CSV);
                    continue block16;
                }
                case "csv_summary": {
                    this.reportFormats.add(ReportFormat.CSV_SUMMARY);
                    continue block16;
                }
                case "github_annotation": {
                    this.reportFormats.add(ReportFormat.GITHUB_ANNOTATION);
                    continue block16;
                }
                default: {
                    throw new CryptoAnalysisParserException("Incorrect value " + reportFormatValue + " for --reportFormat option. Available options are: CMD, TXT, SARIF, CSV and CSV_SUMMARY.\n");
                }
            }
        }
    }

    private boolean isZipFile(String path) throws CryptoAnalysisParserException {
        File file = new File(path);
        int fileSignature = 0;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            fileSignature = raf.readInt();
        }
        catch (IOException e) {
            return false;
        }
        return fileSignature == 1347093252 || fileSignature == 1347093766 || fileSignature == 1347094280;
    }

    private void parseForbiddenPredicates(String path) throws CryptoAnalysisParserException {
        File forbPredFile = new File(path);
        this.forbiddenPredicates = new ArrayList<String>();
        if (forbPredFile.isFile() && forbPredFile.canRead()) {
            try {
                List lines = Files.readLines((File)forbPredFile, (Charset)Charset.defaultCharset());
                this.forbiddenPredicates.addAll(lines);
            }
            catch (IOException e) {
                throw new CryptoAnalysisParserException("Error while reading file " + forbPredFile + ": " + e.getMessage());
            }
        } else {
            throw new CryptoAnalysisParserException(forbPredFile + " is not a file or cannot be read");
        }
    }

    private void parseIgnoredSections(String path) throws CryptoAnalysisParserException {
        File ignorePackageFile = new File(path);
        this.ignoredSections = new ArrayList<String>();
        if (ignorePackageFile.isFile() && ignorePackageFile.canRead()) {
            try {
                List lines = Files.readLines((File)ignorePackageFile, (Charset)Charset.defaultCharset());
                this.ignoredSections.addAll(lines);
            }
            catch (IOException e) {
                throw new CryptoAnalysisParserException("Error while reading file " + ignorePackageFile + ": " + e.getMessage());
            }
        } else {
            throw new CryptoAnalysisParserException(ignorePackageFile + " is not a file or cannot be read");
        }
    }

    @Override
    public Integer call() throws Exception {
        return 0;
    }

    public static enum RulesetPathType {
        DIR,
        ZIP,
        NONE;

    }

    public static enum ReportFormat {
        CMD,
        TXT,
        SARIF,
        CSV,
        CSV_SUMMARY,
        GITHUB_ANNOTATION;

    }

    public static enum ControlGraph {
        CHA,
        SPARK,
        SPARKLIB;

    }
}

