/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import boomerang.Query;
import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import crypto.analysis.AnalysisSeedWithEnsuredPredicate;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.ClassSpecification;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.IAnalysisSeed;
import crypto.predicates.PredicateHandler;
import crypto.rules.CrySLRule;
import crypto.typestate.CrySLMethodToSootMethod;
import heros.utilities.DefaultValueMap;
import ideal.IDEALSeedSolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;

public abstract class CryptoScanner {
    private final LinkedList<IAnalysisSeed> worklist = Lists.newLinkedList();
    private final List<ClassSpecification> specifications = Lists.newLinkedList();
    private final PredicateHandler predicateHandler = new PredicateHandler(this);
    private CrySLResultsReporter resultsAggregator = new CrySLResultsReporter();
    private static final Logger logger = LoggerFactory.getLogger(CryptoScanner.class);
    private DefaultValueMap<Node<Statement, Val>, AnalysisSeedWithEnsuredPredicate> seedsWithoutSpec = new DefaultValueMap<Node<Statement, Val>, AnalysisSeedWithEnsuredPredicate>(){

        protected AnalysisSeedWithEnsuredPredicate createItem(Node<Statement, Val> key) {
            return new AnalysisSeedWithEnsuredPredicate(CryptoScanner.this, key);
        }
    };
    private DefaultValueMap<AnalysisSeedWithSpecification, AnalysisSeedWithSpecification> seedsWithSpec = new DefaultValueMap<AnalysisSeedWithSpecification, AnalysisSeedWithSpecification>(){

        protected AnalysisSeedWithSpecification createItem(AnalysisSeedWithSpecification key) {
            return new AnalysisSeedWithSpecification(CryptoScanner.this, key.stmt(), key.var(), key.getSpec());
        }
    };
    private int solvedObject;
    private Stopwatch analysisWatch;

    public abstract ObservableICFG<Unit, SootMethod> icfg();

    public CrySLResultsReporter getAnalysisListener() {
        return this.resultsAggregator;
    }

    public CryptoScanner() {
        CrySLMethodToSootMethod.reset();
    }

    public void scan(List<CrySLRule> specs) {
        int processedSeeds = 0;
        for (CrySLRule rule : specs) {
            this.specifications.add(new ClassSpecification(rule, this));
        }
        CrySLResultsReporter listener = this.getAnalysisListener();
        listener.beforeAnalysis();
        this.analysisWatch = Stopwatch.createStarted();
        logger.info("Searching for seeds for the analysis!");
        this.initialize();
        long elapsed = this.analysisWatch.elapsed(TimeUnit.SECONDS);
        logger.info("Discovered " + this.worklist.size() + " analysis seeds within " + elapsed + " seconds!");
        while (!this.worklist.isEmpty()) {
            IAnalysisSeed curr = this.worklist.poll();
            listener.discoveredSeed(curr);
            curr.execute();
            listener.addProgress(++processedSeeds, this.worklist.size());
            this.estimateAnalysisTime();
        }
        this.predicateHandler.checkPredicates();
        for (AnalysisSeedWithSpecification seed : this.getAnalysisSeeds()) {
            if (!seed.isSecure()) continue;
            listener.onSecureObjectFound(seed);
        }
        listener.afterAnalysis();
        elapsed = this.analysisWatch.elapsed(TimeUnit.SECONDS);
        logger.info("Static Analysis took " + elapsed + " seconds!");
    }

    private void estimateAnalysisTime() {
        int remaining = this.worklist.size();
        ++this.solvedObject;
        if (remaining != 0) {
            logger.info(String.format("Analyzed Objects: %s of %s", this.solvedObject, remaining + this.solvedObject));
            logger.info(String.format("Percentage Completed: %s\n", Float.valueOf((float)Math.round((float)this.solvedObject * 100.0f / (float)(remaining + this.solvedObject)) / 100.0f)));
        }
    }

    private void initialize() {
        ReachableMethods rm = Scene.v().getReachableMethods();
        QueueReader listener = rm.listener();
        while (listener.hasNext()) {
            MethodOrMethodContext next = (MethodOrMethodContext)listener.next();
            SootMethod method = next.method();
            if (method == null || !method.hasActiveBody() || !method.getDeclaringClass().isApplicationClass() || this.isOnIgnoreSectionList(method)) continue;
            for (ClassSpecification spec : this.getClassSpecifications()) {
                spec.invokesForbiddenMethod(method);
                for (Query query : spec.getInitialSeeds(method)) {
                    this.getOrCreateSeedWithSpec(new AnalysisSeedWithSpecification(this, query.stmt(), query.var(), spec));
                }
            }
        }
    }

    public List<ClassSpecification> getClassSpecifications() {
        return this.specifications;
    }

    protected void addToWorkList(IAnalysisSeed analysisSeedWithSpecification) {
        this.worklist.add(analysisSeedWithSpecification);
    }

    protected boolean isOnIgnoreSectionList(SootMethod method) {
        String declaringClass = method.getDeclaringClass().getName();
        String methodName = declaringClass + "." + method.getName();
        for (String ignoredSection : this.getIgnoredSections()) {
            if (ignoredSection.equals(declaringClass)) {
                logger.info("Ignoring seeds in class " + declaringClass);
                return true;
            }
            if (ignoredSection.equals(methodName)) {
                logger.info("Ignoring seeds in method " + methodName);
                return true;
            }
            if (!ignoredSection.endsWith(".*") || !declaringClass.startsWith(ignoredSection.substring(0, ignoredSection.length() - 2))) continue;
            logger.info("Ignoring seeds in class " + declaringClass + " and method " + methodName);
            return true;
        }
        return false;
    }

    public AnalysisSeedWithEnsuredPredicate getOrCreateSeed(Node<Statement, Val> factAtStatement) {
        boolean addToWorklist = false;
        if (!this.seedsWithoutSpec.containsKey(factAtStatement)) {
            addToWorklist = true;
        }
        AnalysisSeedWithEnsuredPredicate seed = (AnalysisSeedWithEnsuredPredicate)((Object)this.seedsWithoutSpec.getOrCreate(factAtStatement));
        if (addToWorklist) {
            this.addToWorkList(seed);
        }
        return seed;
    }

    public AnalysisSeedWithSpecification getOrCreateSeedWithSpec(AnalysisSeedWithSpecification factAtStatement) {
        boolean addToWorklist = false;
        if (!this.seedsWithSpec.containsKey((Object)factAtStatement)) {
            addToWorklist = true;
        }
        AnalysisSeedWithSpecification seed = (AnalysisSeedWithSpecification)((Object)this.seedsWithSpec.getOrCreate((Object)factAtStatement));
        if (addToWorklist) {
            this.addToWorkList(seed);
        }
        return seed;
    }

    public Debugger<TransitionFunction> debugger(IDEALSeedSolver<TransitionFunction> solver, IAnalysisSeed analyzedObject) {
        return new Debugger();
    }

    public PredicateHandler getPredicateHandler() {
        return this.predicateHandler;
    }

    public Collection<AnalysisSeedWithSpecification> getAnalysisSeeds() {
        return this.seedsWithSpec.values();
    }

    public Collection<String> getForbiddenPredicates() {
        return new ArrayList<String>();
    }

    public Collection<String> getIgnoredSections() {
        return new ArrayList<String>();
    }
}

