/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import com.google.common.collect.Lists;
import crypto.exceptions.CryptoAnalysisException;
import crypto.rules.CrySLRule;
import crypto.rules.CrySLRuleReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrySLRulesetSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrySLRulesetSelector.class);

    public static List<CrySLRule> makeFromRuleset(String rulesBasePath, Ruleset ... set) throws CryptoAnalysisException {
        ArrayList rules = Lists.newArrayList();
        for (Ruleset s : set) {
            rules.addAll(CrySLRulesetSelector.getRuleset(rulesBasePath, s));
        }
        if (rules.isEmpty()) {
            LOGGER.info("No CrySL rules found for rulesset " + set);
        }
        return rules;
    }

    public static List<CrySLRule> makeFromRulesetPath(String path) throws CryptoAnalysisException {
        return CrySLRulesetSelector.getRuleset(path, null);
    }

    public static List<CrySLRule> makeFromRulesetString(String rulesBasePath, String rulesetString) throws CryptoAnalysisException {
        String[] set = rulesetString.split(",");
        ArrayList ruleset = Lists.newArrayList();
        for (String s : set) {
            if (s.equalsIgnoreCase(Ruleset.JavaCryptographicArchitecture.name())) {
                ruleset.add(Ruleset.JavaCryptographicArchitecture);
            }
            if (s.equalsIgnoreCase(Ruleset.BouncyCastle.name())) {
                ruleset.add(Ruleset.BouncyCastle);
            }
            if (!s.equalsIgnoreCase(Ruleset.Tink.name())) continue;
            ruleset.add(Ruleset.Tink);
        }
        if (ruleset.isEmpty()) {
            throw new CryptoAnalysisException("Could not parse " + rulesetString + ". Was not able to find rulesets.");
        }
        return CrySLRulesetSelector.makeFromRuleset(rulesBasePath, ruleset.toArray(new Ruleset[ruleset.size()]));
    }

    private static List<CrySLRule> getRuleset(String rulesBasePath, Ruleset s) throws CryptoAnalysisException {
        File[] listFiles = s == null ? new File(rulesBasePath + "/").listFiles() : new File(rulesBasePath + (Object)((Object)s) + "/").listFiles();
        List<File> files = Arrays.asList(listFiles);
        List<CrySLRule> rules = new CrySLRuleReader().readFromSourceFiles(files);
        if (rules.isEmpty()) {
            throw new CryptoAnalysisException("No CrySL rules found in " + rulesBasePath + (Object)((Object)s) + "/");
        }
        return rules;
    }

    public static CrySLRule makeSingleRule(String rulesBasePath, Ruleset ruleset, String rulename) throws CryptoAnalysisException {
        File file = new File(rulesBasePath + "/" + (Object)((Object)ruleset) + "/" + rulename + ".crysl");
        if (file.exists() && file.isFile()) {
            CrySLRule rule = new CrySLRuleReader().readFromSourceFile(file);
            if (rule != null) {
                return rule;
            }
            throw new CryptoAnalysisException("CrySL rule couldn't created from path " + file.getAbsolutePath());
        }
        throw new CryptoAnalysisException("The specified path is not a file " + file.getAbsolutePath());
    }

    public static enum Ruleset {
        JavaCryptographicArchitecture,
        BouncyCastle,
        Tink,
        CustomRules;

    }
}

