/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import boomerang.BackwardQuery;
import boomerang.Query;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.CrySLAnalysisListener;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.ICrySLResultsListener;
import crypto.analysis.errors.AbstractError;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;

public class CrySLResultsReporter {
    private List<ICrySLResultsListener> listeners = new ArrayList<ICrySLResultsListener>();

    public boolean addReportListener(ICrySLResultsListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeReportListener(CrySLAnalysisListener listener) {
        return this.listeners.remove(listener);
    }

    public void collectedValues(AnalysisSeedWithSpecification seed, Multimap<CallSiteWithParamIndex, ExtractedValue> parametersToValues) {
        for (ICrySLResultsListener listen : this.listeners) {
            listen.collectedValues(seed, parametersToValues);
        }
    }

    public void discoveredSeed(IAnalysisSeed curr) {
        for (ICrySLResultsListener listen : this.listeners) {
            listen.discoveredSeed(curr);
        }
    }

    public void ensuredPredicates(Table<Statement, Val, Set<EnsuredCrySLPredicate>> existingPredicates, Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> expectedPredicates, Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> missingPredicates) {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).ensuredPredicates(existingPredicates, expectedPredicates, missingPredicates);
        }
    }

    public void checkedConstraints(AnalysisSeedWithSpecification analysisSeedWithSpecification, Collection<ISLConstraint> relConstraints) {
        for (ICrySLResultsListener listen : this.listeners) {
            listen.checkedConstraints(analysisSeedWithSpecification, relConstraints);
        }
    }

    public void beforeAnalysis() {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).beforeAnalysis();
        }
    }

    public void afterAnalysis() {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).afterAnalysis();
        }
    }

    public void beforeConstraintCheck(AnalysisSeedWithSpecification analysisSeedWithSpecification) {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).beforeConstraintCheck(analysisSeedWithSpecification);
        }
    }

    public void afterConstraintCheck(AnalysisSeedWithSpecification analysisSeedWithSpecification) {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).afterConstraintCheck(analysisSeedWithSpecification);
        }
    }

    public void beforePredicateCheck(AnalysisSeedWithSpecification analysisSeedWithSpecification) {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).beforePredicateCheck(analysisSeedWithSpecification);
        }
    }

    public void afterPredicateCheck(AnalysisSeedWithSpecification analysisSeedWithSpecification) {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).afterPredicateCheck(analysisSeedWithSpecification);
        }
    }

    public void seedStarted(IAnalysisSeed analysisSeedWithSpecification) {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).seedStarted(analysisSeedWithSpecification);
        }
    }

    public void boomerangQueryStarted(Query seed, BackwardQuery q) {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).boomerangQueryStarted(seed, q);
        }
    }

    public void boomerangQueryFinished(Query seed, BackwardQuery q) {
        for (ICrySLResultsListener listen : this.listeners) {
            if (!(listen instanceof CrySLAnalysisListener)) continue;
            ((CrySLAnalysisListener)listen).boomerangQueryFinished(seed, q);
        }
    }

    public void onSeedFinished(IAnalysisSeed seed, ForwardBoomerangResults<TransitionFunction> analysisResults) {
        for (ICrySLResultsListener listen : this.listeners) {
            listen.onSeedFinished(seed, analysisResults);
        }
    }

    public void onSeedTimeout(Node<Statement, Val> seed) {
        for (ICrySLResultsListener listen : this.listeners) {
            listen.onSeedTimeout(seed);
        }
    }

    public void reportError(IAnalysisSeed object, AbstractError err) {
        if (object != null && object instanceof AnalysisSeedWithSpecification) {
            ((AnalysisSeedWithSpecification)object).setSecure(false);
        }
        for (ICrySLResultsListener listen : this.listeners) {
            listen.reportError(err);
        }
    }

    public void onSecureObjectFound(IAnalysisSeed seed) {
        for (ICrySLResultsListener listen : this.listeners) {
            listen.onSecureObjectFound(seed);
        }
    }

    public void addProgress(int processedSeeds, int workListsize) {
        for (ICrySLResultsListener listen : this.listeners) {
            listen.addProgress(processedSeeds, workListsize);
        }
    }
}

