/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import crypto.interfaces.Transition;
import crypto.rules.CrySLMethod;
import crypto.rules.StateNode;
import java.io.Serializable;
import java.util.List;

public class TransitionEdge
implements Transition<StateNode>,
Serializable {
    private static final long serialVersionUID = 1L;
    private StateNode left = null;
    private StateNode right = null;
    private List<CrySLMethod> methods = null;

    public TransitionEdge(List<CrySLMethod> _methods, StateNode _left, StateNode _right) {
        this.left = _left;
        this.right = _right;
        this.methods = _methods;
    }

    public StateNode getLeft() {
        return this.left;
    }

    public StateNode getRight() {
        return this.right;
    }

    @Override
    public List<CrySLMethod> getLabel() {
        return this.methods;
    }

    public String toString() {
        StringBuilder edgeSB = new StringBuilder();
        edgeSB.append("Left: ");
        edgeSB.append(this.left.getName());
        edgeSB.append(" ====");
        edgeSB.append(this.methods);
        edgeSB.append("====> Right:");
        edgeSB.append(this.right.getName());
        return edgeSB.toString();
    }

    @Override
    public StateNode from() {
        return this.left;
    }

    @Override
    public StateNode to() {
        return this.right;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransitionEdge other = (TransitionEdge)obj;
        if (this.methods == null ? other.methods != null : !this.methods.equals(other.methods)) {
            return false;
        }
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }
}

