/*
 * Decompiled with CFR 0.152.
 */
package crypto.cryslhandler;

import com.google.common.collect.Sets;
import crypto.cryslhandler.CrySLReaderUtils;
import crypto.rules.CrySLMethod;
import crypto.rules.StateMachineGraph;
import crypto.rules.StateNode;
import crypto.rules.TransitionEdge;
import de.darmstadt.tu.crossing.crySL.Event;
import de.darmstadt.tu.crossing.crySL.Order;
import de.darmstadt.tu.crossing.crySL.OrderOperator;
import de.darmstadt.tu.crossing.crySL.Primary;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class StateMachineGraphBuilder {
    private final Order order;
    private final StateMachineGraph result;
    private final List<Event> events;
    private final Set<CrySLMethod> allMethods = Sets.newHashSet();

    public static StateMachineGraph buildSMG(Order order, List<Event> events) {
        return new StateMachineGraphBuilder(order, events).buildSMG();
    }

    protected StateMachineGraphBuilder(Order order, List<Event> events) {
        this.order = order;
        this.events = events;
        this.result = new StateMachineGraph();
    }

    protected StateMachineGraph buildSMG() {
        StateNode initialNode = new StateNode("-1", true, false);
        this.result.addNode(initialNode);
        SubStateMachine subSmg = this.buildSubSMG(this.order, Collections.singleton(initialNode));
        subSmg.getEndNodes().parallelStream().forEach(StateNode::makeAccepting);
        return this.result;
    }

    /*
     * Unable to fully structure code
     */
    private SubStateMachine buildSubSMG(Order order, Set<StateNode> startNodes) {
        if (order == null) {
            node = this.result.createNewNode();
            label = new ArrayList<CrySLMethod>(this.retrieveAllMethodsFromEvents());
            for (StateNode startNode : startNodes) {
                this.result.createNewEdge(label, startNode, node);
            }
            this.result.createNewEdge(label, node, node);
            return new SubStateMachine(Collections.singleton(node), startNodes);
        }
        if (order instanceof Primary) {
            event = ((Primary)order).getEvent();
            node = this.result.createNewNode();
            label = CrySLReaderUtils.resolveEventToCryslMethods(event);
            for (StateNode startNode : startNodes) {
                this.result.createNewEdge(label, startNode, node);
            }
            return new SubStateMachine(node, node);
        }
        end = Sets.newHashSet();
        start = Sets.newHashSet();
        switch (1.$SwitchMap$de$darmstadt$tu$crossing$crySL$OrderOperator[order.getOp().ordinal()]) {
            case 1: {
                left = this.buildSubSMG(order.getLeft(), startNodes);
                right = this.buildSubSMG(order.getRight(), left.getEndNodes());
                start.addAll(left.getStartNodes());
                end.addAll(right.getEndNodes());
                break;
            }
            case 2: {
                left = this.buildSubSMG(order.getLeft(), startNodes);
                right = this.buildSubSMG(order.getRight(), startNodes);
                start.addAll(left.getStartNodes());
                start.addAll(right.getStartNodes());
                end.addAll(left.getEndNodes());
                end.addAll(right.getEndNodes());
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                left = this.buildSubSMG(order.getLeft(), startNodes);
                start.addAll(left.getStartNodes());
                end.addAll(left.getEndNodes());
                if (order.getOp() == OrderOperator.ZERO_OR_MORE) ** GOTO lbl54
                if (order.getOp() != OrderOperator.ONE_OR_MORE) ** GOTO lbl55
lbl54:
                // 2 sources

                startNodes.stream().map((Function<StateNode, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getAllOutgoingEdges(crypto.rules.StateNode ), (Lcrypto/rules/StateNode;)Ljava/util/Set;)((StateMachineGraph)this.result)).flatMap((Function<Set, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Set;)Ljava/util/stream/Stream;)()).filter((Predicate<TransitionEdge>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$buildSubSMG$0(crypto.cryslhandler.StateMachineGraphBuilder$SubStateMachine crypto.rules.TransitionEdge ), (Lcrypto/rules/TransitionEdge;)Z)((SubStateMachine)left)).forEach((Consumer<TransitionEdge>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$buildSubSMG$2(crypto.cryslhandler.StateMachineGraphBuilder$SubStateMachine crypto.rules.TransitionEdge ), (Lcrypto/rules/TransitionEdge;)V)((StateMachineGraphBuilder)this, (SubStateMachine)left));
lbl55:
                // 2 sources

                if (order.getOp() != OrderOperator.ZERO_OR_MORE && order.getOp() != OrderOperator.ZERO_OR_ONE) break;
                end.addAll(startNodes);
            }
        }
        return new SubStateMachine(start, end);
    }

    private Set<CrySLMethod> retrieveAllMethodsFromEvents() {
        if (this.allMethods.isEmpty()) {
            this.allMethods.addAll(CrySLReaderUtils.resolveEventsToCryslMethods(this.events));
        }
        return this.allMethods;
    }

    private /* synthetic */ void lambda$buildSubSMG$2(SubStateMachine left, TransitionEdge edge) {
        left.getEndNodes().stream().forEach(endNode -> this.result.createNewEdge(edge.getLabel(), (StateNode)endNode, edge.getRight()));
    }

    private static /* synthetic */ boolean lambda$buildSubSMG$0(SubStateMachine left, TransitionEdge edge) {
        return left.getStartNodes().contains(edge.getRight());
    }

    private static class SubStateMachine {
        private final Set<StateNode> startNodes;
        private final Set<StateNode> endNodes;

        public SubStateMachine(StateNode startNode, StateNode endNode) {
            this(Collections.singleton(startNode), Collections.singleton(endNode));
        }

        public SubStateMachine(Set<StateNode> startNodes, Set<StateNode> endNodes) {
            this.startNodes = Collections.unmodifiableSet(startNodes);
            this.endNodes = Collections.unmodifiableSet(endNodes);
        }

        public Set<StateNode> getStartNodes() {
            return this.startNodes;
        }

        public Set<StateNode> getEndNodes() {
            return this.endNodes;
        }
    }
}

