/*
 * Decompiled with CFR 0.152.
 */
package crypto.cryslhandler;

import crypto.interfaces.ICrySLPredicateParameter;
import crypto.rules.CrySLArithmeticConstraint;
import crypto.rules.CrySLComparisonConstraint;
import crypto.rules.CrySLConstraint;
import crypto.rules.CrySLException;
import crypto.rules.CrySLMethod;
import crypto.rules.CrySLObject;
import de.darmstadt.tu.crossing.crySL.Aggregate;
import de.darmstadt.tu.crossing.crySL.AnyParameterType;
import de.darmstadt.tu.crossing.crySL.BooleanLiteral;
import de.darmstadt.tu.crossing.crySL.Constraint;
import de.darmstadt.tu.crossing.crySL.Event;
import de.darmstadt.tu.crossing.crySL.Exception;
import de.darmstadt.tu.crossing.crySL.ExceptionAggregate;
import de.darmstadt.tu.crossing.crySL.ExceptionDeclaration;
import de.darmstadt.tu.crossing.crySL.ForbiddenMethod;
import de.darmstadt.tu.crossing.crySL.IntLiteral;
import de.darmstadt.tu.crossing.crySL.LabeledMethodCall;
import de.darmstadt.tu.crossing.crySL.Literal;
import de.darmstadt.tu.crossing.crySL.Method;
import de.darmstadt.tu.crossing.crySL.Operator;
import de.darmstadt.tu.crossing.crySL.StringLiteral;
import java.io.File;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.xtext.common.types.JvmTypeParameter;

public class CrySLReaderUtils {
    public static List<CrySLMethod> resolveEventToCryslMethods(Event event) {
        return CrySLReaderUtils.resolveEventToCryslMethodsStream(event).collect(Collectors.toList());
    }

    public static List<ICrySLPredicateParameter> resolveEventToPredicateParameters(Event event) {
        return CrySLReaderUtils.resolveEventToCryslMethodsStream(event).collect(Collectors.toList());
    }

    public static List<CrySLMethod> resolveEventsToCryslMethods(Collection<Event> events) {
        return CrySLReaderUtils.resolveEventsToCryslMethodsStream(events).collect(Collectors.toList());
    }

    public static Stream<CrySLMethod> resolveEventsToCryslMethodsStream(Collection<Event> events) {
        return events.parallelStream().flatMap(CrySLReaderUtils::resolveEventToCryslMethodsStream);
    }

    public static Stream<CrySLMethod> resolveEventToCryslMethodsStream(Event event) {
        if (event instanceof Aggregate) {
            return CrySLReaderUtils.resolveEventToCryslMethodsStream((Aggregate)event);
        }
        if (event instanceof LabeledMethodCall) {
            return CrySLReaderUtils.resolveEventToCryslMethodsStream((LabeledMethodCall)event);
        }
        return Stream.empty();
    }

    protected static Stream<CrySLMethod> resolveEventToCryslMethodsStream(Aggregate aggregate) {
        return aggregate.getEvents().parallelStream().flatMap(CrySLReaderUtils::resolveEventToCryslMethodsStream);
    }

    protected static Stream<CrySLMethod> resolveEventToCryslMethodsStream(LabeledMethodCall event) {
        return Stream.of(CrySLReaderUtils.toCrySLMethod(event.getMethod()));
    }

    public static CrySLMethod toCrySLMethod(ForbiddenMethod method) {
        String name = method.getMethod().getQualifiedName();
        List<Map.Entry<String, String>> parameters = method.getParameters().stream().map(parameter -> new AbstractMap.SimpleEntry<String, String>(parameter.getSimpleName(), parameter.getType().getQualifiedName())).collect(Collectors.toList());
        return new CrySLMethod(name, parameters, CrySLReaderUtils.resolveObject(null));
    }

    public static CrySLMethod toCrySLMethod(Method method) {
        String name = method.getMethod().getQualifiedName();
        List<Map.Entry<String, String>> parameters = method.getParameters().stream().map(parameter -> parameter instanceof AnyParameterType ? new AbstractMap.SimpleEntry<String, String>("_", "AnyType") : CrySLReaderUtils.resolveObject(parameter.getValue())).collect(Collectors.toList());
        return new CrySLMethod(name, parameters, CrySLReaderUtils.resolveObject(method.getReturn()));
    }

    public static CrySLObject toCrySLObject(de.darmstadt.tu.crossing.crySL.Object object) {
        return new CrySLObject(object.getName(), object.getType().getQualifiedName());
    }

    public static CrySLObject toCrySLObject(Literal literal) {
        String value = literal.getValue();
        String type = literal instanceof IntLiteral ? "int" : (literal instanceof BooleanLiteral ? "boolean" : (literal instanceof StringLiteral ? String.class.getName() : "void"));
        return new CrySLObject(value, type);
    }

    public static Collection<CrySLException> resolveExceptions(Exception exception) {
        return CrySLReaderUtils.resolveExceptionsStream(exception).collect(Collectors.toList());
    }

    public static Stream<CrySLException> resolveExceptionsStream(Exception exception) {
        if (exception instanceof ExceptionDeclaration) {
            return CrySLReaderUtils.resolveExceptionsStream((ExceptionDeclaration)exception);
        }
        if (exception instanceof ExceptionAggregate) {
            return CrySLReaderUtils.resolveExceptionsStream((ExceptionAggregate)exception);
        }
        return Stream.empty();
    }

    protected static Stream<CrySLException> resolveExceptionsStream(ExceptionAggregate exception) {
        return exception.getExceptions().stream().flatMap(CrySLReaderUtils::resolveExceptionsStream);
    }

    protected static Stream<CrySLException> resolveExceptionsStream(ExceptionDeclaration exception) {
        return Stream.of(CrySLReaderUtils.toCrySLException(exception));
    }

    public static CrySLException toCrySLException(ExceptionDeclaration exception) {
        return new CrySLException(exception.getException().getIdentifier());
    }

    public static Map.Entry<String, String> resolveObject(de.darmstadt.tu.crossing.crySL.Object o) {
        if (o == null) {
            return new AbstractMap.SimpleEntry<String, String>("_", "void");
        }
        if (o.getType().getType() instanceof JvmTypeParameter) {
            return new AbstractMap.SimpleEntry<String, String>(o.getName(), "java.lang.Object");
        }
        return new AbstractMap.SimpleEntry<String, String>(o.getName(), o.getType().getQualifiedName());
    }

    public static File getResourceFromWithin(String inputPath) {
        return new File(inputPath);
    }

    public static Optional<CrySLArithmeticConstraint.ArithOp> arithOpFromOperator(Operator operator) {
        switch (operator) {
            case PLUS: {
                return Optional.of(CrySLArithmeticConstraint.ArithOp.p);
            }
            case MINUS: {
                return Optional.of(CrySLArithmeticConstraint.ArithOp.n);
            }
            case MODULO: {
                return Optional.of(CrySLArithmeticConstraint.ArithOp.m);
            }
        }
        return Optional.empty();
    }

    public static Optional<CrySLConstraint.LogOps> logOpFromOperator(Operator operator) {
        switch (operator) {
            case AND: {
                return Optional.of(CrySLConstraint.LogOps.and);
            }
            case OR: {
                return Optional.of(CrySLConstraint.LogOps.or);
            }
            case IMPLY: {
                return Optional.of(CrySLConstraint.LogOps.implies);
            }
        }
        return Optional.empty();
    }

    public static Optional<CrySLComparisonConstraint.CompOp> compOpFromOperator(Operator operator) {
        switch (operator) {
            case EQUAL: {
                return Optional.of(CrySLComparisonConstraint.CompOp.eq);
            }
            case UNEQUAL: {
                return Optional.of(CrySLComparisonConstraint.CompOp.neq);
            }
            case LESS: {
                return Optional.of(CrySLComparisonConstraint.CompOp.l);
            }
            case LESS_OR_EQUAL: {
                return Optional.of(CrySLComparisonConstraint.CompOp.le);
            }
            case GREATER: {
                return Optional.of(CrySLComparisonConstraint.CompOp.g);
            }
            case GREATER_OR_EQUAL: {
                return Optional.of(CrySLComparisonConstraint.CompOp.ge);
            }
        }
        return Optional.empty();
    }

    public static boolean isArithmeticExpression(Constraint constraint) {
        return CrySLReaderUtils.arithOpFromOperator(constraint.getOp()).isPresent();
    }

    public static boolean isLogicExpression(Constraint constraint) {
        return CrySLReaderUtils.logOpFromOperator(constraint.getOp()).isPresent();
    }

    public static boolean isComparisonExpression(Constraint constraint) {
        return CrySLReaderUtils.compOpFromOperator(constraint.getOp()).isPresent();
    }
}

