/*
 * Decompiled with CFR 0.152.
 */
package crypto.constraints;

import boomerang.jimple.Statement;
import crypto.analysis.errors.ForbiddenMethodError;
import crypto.analysis.errors.HardCodedError;
import crypto.analysis.errors.InstanceOfError;
import crypto.analysis.errors.NeverTypeOfError;
import crypto.constraints.ConstraintSolver;
import crypto.constraints.EvaluableConstraint;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLMethod;
import crypto.rules.CrySLObject;
import crypto.rules.CrySLPredicate;
import crypto.typestate.CrySLMethodToSootMethod;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import soot.SootMethod;
import soot.Type;
import soot.jimple.IntConstant;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;

public class PredicateConstraint
extends EvaluableConstraint {
    protected PredicateConstraint(ISLConstraint origin, ConstraintSolver context) {
        super(origin, context);
    }

    @Override
    public void evaluate() {
        CrySLPredicate predicateConstraint = (CrySLPredicate)this.origin;
        String predName = predicateConstraint.getPredName();
        if (ConstraintSolver.predefinedPreds.contains(predName)) {
            this.handlePredefinedNames(predicateConstraint);
        }
    }

    public boolean isHardCoded(ExtractedValue val) {
        return val.getValue() instanceof IntConstant || val.getValue() instanceof StringConstant || val.getValue() instanceof NewExpr && ((NewExpr)val.getValue()).getType().toString().equals("java.math.BigInteger");
    }

    protected boolean isSubType(String typeOne, String typeTwo) {
        boolean subTypes = typeOne.equals(typeTwo);
        if (!(subTypes |= (typeOne + "[]").equals(typeTwo))) {
            try {
                subTypes = Class.forName(typeOne).isAssignableFrom(Class.forName(typeTwo));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return subTypes;
    }

    private void handlePredefinedNames(CrySLPredicate pred) {
        List<ICrySLPredicateParameter> parameters = pred.getParameters();
        switch (pred.getPredName()) {
            case "callTo": {
                List<ICrySLPredicateParameter> predMethods = parameters;
                for (ICrySLPredicateParameter predMethod : predMethods) {
                    CrySLMethod reqMethod = (CrySLMethod)predMethod;
                    for (Statement unit : this.context.getCollectedCalls()) {
                        if (!unit.isCallsite()) continue;
                        SootMethod foundCall = ((Stmt)unit.getUnit().get()).getInvokeExpr().getMethod();
                        Collection<SootMethod> convert = CrySLMethodToSootMethod.v().convert(reqMethod);
                        if (!convert.contains(foundCall)) continue;
                        return;
                    }
                }
                return;
            }
            case "noCallTo": {
                if (this.context.getCollectedCalls().isEmpty()) {
                    return;
                }
                List<ICrySLPredicateParameter> predForbiddenMethods = parameters;
                for (ICrySLPredicateParameter predForbMethod : predForbiddenMethods) {
                    CrySLMethod reqMethod = (CrySLMethod)predForbMethod;
                    for (Statement call : this.context.getCollectedCalls()) {
                        if (!call.isCallsite()) continue;
                        SootMethod foundCall = ((Stmt)call.getUnit().get()).getInvokeExpr().getMethod();
                        Collection<SootMethod> convert = CrySLMethodToSootMethod.v().convert(reqMethod);
                        if (!convert.contains(foundCall)) continue;
                        this.errors.add(new ForbiddenMethodError(call, this.context.getClassSpec().getRule(), foundCall, convert));
                        return;
                    }
                }
                return;
            }
            case "neverTypeOf": {
                String varName = ((CrySLObject)parameters.get(0)).getVarName();
                for (CallSiteWithParamIndex cs : this.context.getParameterAnalysisQuerySites()) {
                    if (!cs.getVarName().equals(varName)) continue;
                    Collection vals = this.context.getPropagatedTypes().get((Object)cs);
                    for (Type t : vals) {
                        if (!t.toQuotedString().equals(parameters.get(1).getName())) continue;
                        for (ExtractedValue v : this.context.getParsAndVals().get((Object)cs)) {
                            this.errors.add(new NeverTypeOfError(new CallSiteWithExtractedValue(cs, v), this.context.getClassSpec().getRule(), this.context.getObject(), pred));
                        }
                        return;
                    }
                }
                return;
            }
            case "length": {
                return;
            }
            case "notHardCoded": {
                CrySLObject varNotToBeHardCoded = (CrySLObject)pred.getParameters().get(0);
                String name = varNotToBeHardCoded.getVarName();
                String type = varNotToBeHardCoded.getJavaType();
                for (CallSiteWithParamIndex cs : this.context.getParsAndVals().keySet()) {
                    if (!cs.getVarName().equals(name)) continue;
                    Collection values = this.context.getParsAndVals().get((Object)cs);
                    for (ExtractedValue v : values) {
                        if (!this.isSubType(type, v.getValue().getType().toQuotedString()) || !this.isHardCoded(v) && !this.isHardCodedArray(this.extractSootArray(cs, v))) continue;
                        this.errors.add(new HardCodedError(new CallSiteWithExtractedValue(cs, v), this.context.getClassSpec().getRule(), this.context.getObject(), pred));
                    }
                }
                return;
            }
            case "instanceOf": {
                String varName = ((CrySLObject)parameters.get(0)).getVarName();
                for (CallSiteWithParamIndex cs : this.context.getParameterAnalysisQuerySites()) {
                    Collection vals;
                    if (!cs.getVarName().equals(varName) || (vals = this.context.getPropagatedTypes().get((Object)cs)).parallelStream().anyMatch(e -> this.isSubType(e.toQuotedString(), ((ICrySLPredicateParameter)parameters.get(1)).getName()) || this.isSubType(((ICrySLPredicateParameter)parameters.get(1)).getName(), e.toQuotedString()))) continue;
                    for (ExtractedValue v : this.context.getParsAndVals().get((Object)cs)) {
                        this.errors.add(new InstanceOfError(new CallSiteWithExtractedValue(cs, v), this.context.getClassSpec().getRule(), this.context.getObject(), pred));
                    }
                }
                return;
            }
        }
    }

    private boolean isHardCodedArray(Map<String, CallSiteWithExtractedValue> extractSootArray) {
        return extractSootArray.keySet().size() != 1 || !extractSootArray.containsKey("");
    }
}

