/*
 * Decompiled with CFR 0.152.
 */
package crypto.constraints;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import crypto.analysis.errors.AbstractError;
import crypto.constraints.BinaryConstraint;
import crypto.constraints.ComparisonConstraint;
import crypto.constraints.ConstraintSolver;
import crypto.constraints.ExceptionConstraint;
import crypto.constraints.PredicateConstraint;
import crypto.constraints.ValueConstraint;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLComparisonConstraint;
import crypto.rules.CrySLConstraint;
import crypto.rules.CrySLExceptionConstraint;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLValueConstraint;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.IntType;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.LongConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.internal.JNewArrayExpr;

public abstract class EvaluableConstraint {
    protected static final Logger LOGGER = LoggerFactory.getLogger(EvaluableConstraint.class);
    final Set<AbstractError> errors = Sets.newHashSet();
    final ConstraintSolver context;
    final ISLConstraint origin;

    public static EvaluableConstraint getInstance(ISLConstraint con, ConstraintSolver context) {
        if (con instanceof CrySLComparisonConstraint) {
            return new ComparisonConstraint((CrySLComparisonConstraint)con, context);
        }
        if (con instanceof CrySLValueConstraint) {
            return new ValueConstraint((CrySLValueConstraint)con, context);
        }
        if (con instanceof CrySLPredicate) {
            return new PredicateConstraint((CrySLPredicate)con, context);
        }
        if (con instanceof CrySLConstraint) {
            return new BinaryConstraint((CrySLConstraint)con, context);
        }
        if (con instanceof CrySLExceptionConstraint) {
            return new ExceptionConstraint((CrySLExceptionConstraint)con, context);
        }
        return null;
    }

    protected EvaluableConstraint(ISLConstraint origin, ConstraintSolver context) {
        this.origin = origin;
        this.context = context;
    }

    public abstract void evaluate();

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    protected Collection<AbstractError> getErrors() {
        return this.errors;
    }

    protected Map<String, CallSiteWithExtractedValue> extractValueAsString(String varName, ISLConstraint cons) {
        HashMap varVal = Maps.newHashMap();
        for (CallSiteWithParamIndex wrappedCallSite : this.context.getParsAndVals().keySet()) {
            Stmt callSite = (Stmt)wrappedCallSite.stmt().getUnit().get();
            for (ExtractedValue wrappedAllocSite : this.context.getParsAndVals().get((Object)wrappedCallSite)) {
                Stmt allocSite = (Stmt)wrappedAllocSite.stmt().getUnit().get();
                if (!wrappedCallSite.getVarName().equals(varName)) continue;
                InvokeExpr invoker = callSite.getInvokeExpr();
                if (callSite.equals(allocSite)) {
                    varVal.put(this.retrieveConstantFromValue(invoker.getArg(wrappedCallSite.getIndex())), new CallSiteWithExtractedValue(wrappedCallSite, wrappedAllocSite));
                    continue;
                }
                if (!(allocSite instanceof AssignStmt)) continue;
                if (wrappedAllocSite.getValue() instanceof Constant) {
                    String retrieveConstantFromValue = this.retrieveConstantFromValue(wrappedAllocSite.getValue());
                    int pos = -1;
                    for (int i = 0; i < invoker.getArgs().size(); ++i) {
                        if (!((AssignStmt)allocSite).getLeftOpBox().getValue().toString().equals(((Value)invoker.getArgs().get(i)).toString())) continue;
                        pos = i;
                    }
                    if (pos > -1 && "boolean".equals(invoker.getMethodRef().getParameterType(pos).toQuotedString())) {
                        varVal.put("0".equals(retrieveConstantFromValue) ? "false" : "true", new CallSiteWithExtractedValue(wrappedCallSite, wrappedAllocSite));
                        continue;
                    }
                    varVal.put(retrieveConstantFromValue, new CallSiteWithExtractedValue(wrappedCallSite, wrappedAllocSite));
                    continue;
                }
                if (!(wrappedAllocSite.getValue() instanceof JNewArrayExpr)) continue;
                varVal.putAll(this.extractSootArray(wrappedCallSite, wrappedAllocSite));
            }
        }
        return varVal;
    }

    protected Map<String, CallSiteWithExtractedValue> extractSootArray(CallSiteWithParamIndex callSite, ExtractedValue allocSite) {
        Value arrayLocal = allocSite.getValue();
        Body methodBody = allocSite.stmt().getMethod().getActiveBody();
        HashMap arrVal = Maps.newHashMap();
        if (methodBody == null) {
            return arrVal;
        }
        Iterator unitIterator = methodBody.getUnits().snapshotIterator();
        while (unitIterator.hasNext()) {
            Unit unit = (Unit)unitIterator.next();
            if (!(unit instanceof AssignStmt)) continue;
            AssignStmt uStmt = (AssignStmt)unit;
            Value leftValue = uStmt.getLeftOp();
            Value rightValue = uStmt.getRightOp();
            if (!leftValue.toString().contains(arrayLocal.toString()) || rightValue.toString().contains("newarray")) continue;
            arrVal.put(this.retrieveConstantFromValue(rightValue), new CallSiteWithExtractedValue(callSite, allocSite));
        }
        return arrVal;
    }

    private String retrieveConstantFromValue(Value val) {
        if (val instanceof StringConstant) {
            return ((StringConstant)val).value;
        }
        if (val instanceof IntConstant || val.getType() instanceof IntType) {
            return val.toString();
        }
        if (val instanceof LongConstant) {
            return val.toString().replaceAll("L", "");
        }
        return "";
    }
}

