/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import crypto.analysis.errors.IError;
import crypto.rules.CrySLRule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.jimple.Stmt;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JIfStmt;
import soot.jimple.internal.JReturnStmt;
import soot.jimple.internal.JReturnVoidStmt;

public abstract class AbstractError
implements IError {
    private Statement errorLocation;
    private CrySLRule rule;
    private final String outerMethod;
    private final String invokeMethod;
    private final String declaringClass;
    private Set<AbstractError> causedByErrors;
    private Set<AbstractError> willCauseErrors;

    public AbstractError(Statement errorLocation, CrySLRule rule) {
        this.errorLocation = errorLocation;
        this.rule = rule;
        this.outerMethod = errorLocation.getMethod().getSignature();
        this.declaringClass = errorLocation.getMethod().getDeclaringClass().toString();
        this.causedByErrors = new HashSet<AbstractError>();
        this.willCauseErrors = new HashSet<AbstractError>();
        Stmt errorStmt = (Stmt)errorLocation.getUnit().get();
        this.invokeMethod = errorStmt.containsInvokeExpr() ? errorStmt.getInvokeExpr().getMethod().toString() : (errorStmt instanceof JReturnStmt || errorStmt instanceof JReturnVoidStmt ? errorStmt.toString() : (errorStmt instanceof JIfStmt ? ((JIfStmt)errorStmt).getCondition().toString() : ((JAssignStmt)errorStmt).getLeftOp().toString()));
    }

    public void addCausingError(AbstractError parent) {
        this.causedByErrors.add(parent);
    }

    public void addCausingError(Collection<AbstractError> parents) {
        this.causedByErrors.addAll(parents);
    }

    public void addSubsequentError(AbstractError subsequentError) {
        this.willCauseErrors.add(subsequentError);
    }

    public Set<AbstractError> getSubsequentErrors() {
        return this.willCauseErrors;
    }

    public Set<AbstractError> getRootErrors() {
        return this.causedByErrors;
    }

    public Statement getErrorLocation() {
        return this.errorLocation;
    }

    public CrySLRule getRule() {
        return this.rule;
    }

    public abstract String toErrorMarkerString();

    public String toString() {
        return this.toErrorMarkerString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.invokeMethod == null ? 0 : this.invokeMethod.hashCode());
        result = 31 * result + (this.outerMethod == null ? 0 : this.outerMethod.hashCode());
        result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractError other = (AbstractError)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.invokeMethod == null ? other.invokeMethod != null : !this.invokeMethod.equals(other.invokeMethod)) {
            return false;
        }
        if (this.outerMethod == null ? other.outerMethod != null : !this.outerMethod.equals(other.outerMethod)) {
            return false;
        }
        if (this.rule == null) {
            if (other.rule != null) {
                return false;
            }
        } else {
            if (!this.rule.equals(other.rule)) {
                return false;
            }
            if (!this.errorLocation.equals((Object)other.getErrorLocation())) {
                return false;
            }
        }
        return true;
    }
}

