/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ConstraintError;
import crypto.analysis.errors.HardCodedError;
import crypto.analysis.errors.ImpreciseValueExtractionError;
import crypto.analysis.errors.IncompleteOperationError;
import crypto.analysis.errors.InstanceOfError;
import crypto.analysis.errors.NeverTypeOfError;
import crypto.analysis.errors.RequiredPredicateError;
import crypto.analysis.errors.TypestateError;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.rules.CrySLPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class HiddenPredicate
extends EnsuredCrySLPredicate {
    private final AnalysisSeedWithSpecification generatingSeed;
    private final HiddenPredicateType type;

    public HiddenPredicate(CrySLPredicate predicate, Multimap<CallSiteWithParamIndex, ExtractedValue> parametersToValues2, AnalysisSeedWithSpecification generatingSeed, HiddenPredicateType type) {
        super(predicate, parametersToValues2);
        this.generatingSeed = generatingSeed;
        this.type = type;
    }

    public AnalysisSeedWithSpecification getGeneratingSeed() {
        return this.generatingSeed;
    }

    public HiddenPredicateType getType() {
        return this.type;
    }

    public List<AbstractError> getPrecedingErrors() {
        ArrayList results = Lists.newArrayList();
        List<AbstractError> allErrors = this.generatingSeed.getErrors();
        switch (this.type) {
            case GeneratingStateIsNeverReached: {
                List typestateErrors = allErrors.stream().filter(e -> e instanceof IncompleteOperationError || e instanceof TypestateError).collect(Collectors.toList());
                if (typestateErrors.isEmpty()) {
                    // empty if block
                }
                return allErrors;
            }
            case ConstraintsAreNotSatisfied: {
                return allErrors.stream().filter(e -> e instanceof RequiredPredicateError || e instanceof ConstraintError || e instanceof HardCodedError || e instanceof ImpreciseValueExtractionError || e instanceof InstanceOfError || e instanceof NeverTypeOfError).collect(Collectors.toList());
            }
            case ConditionIsNotSatisfied: {
                ArrayList precedingErrors = Lists.newArrayList(this.generatingSeed.retrieveErrorsForPredCondition(this.getPredicate()));
                precedingErrors.forEach(e -> this.generatingSeed.cryptoScanner.getAnalysisListener().reportError(this.generatingSeed, (AbstractError)e));
                for (AbstractError e2 : precedingErrors) {
                    if (!(e2 instanceof RequiredPredicateError)) continue;
                    ((RequiredPredicateError)e2).mapPrecedingErrors();
                }
                return precedingErrors;
            }
        }
        return results;
    }

    public static enum HiddenPredicateType {
        GeneratingStateIsNeverReached,
        ConstraintsAreNotSatisfied,
        ConditionIsNotSatisfied;

    }
}

