/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import com.google.common.collect.Lists;
import crypto.interfaces.FiniteStateMachine;
import crypto.rules.CrySLMethod;
import crypto.rules.StateNode;
import crypto.rules.TransitionEdge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class StateMachineGraph
implements FiniteStateMachine<StateNode>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<StateNode> nodes = new HashSet<StateNode>();
    private final List<TransitionEdge> edges = new ArrayList<TransitionEdge>();
    private int nodeNameCounter = 0;

    public StateNode createNewNode() {
        StateNode node = new StateNode(String.valueOf(this.nodeNameCounter++), false, false);
        this.nodes.add(node);
        return node;
    }

    public boolean createNewEdge(List<CrySLMethod> methods, StateNode left, StateNode right) {
        return this.addEdge(new TransitionEdge(methods, left, right));
    }

    private Boolean addEdge(TransitionEdge edge) {
        StateNode right = edge.getRight();
        StateNode left = edge.getLeft();
        if (!this.nodes.parallelStream().anyMatch(e -> e.equals(left)) && !this.nodes.parallelStream().anyMatch(e -> e.equals(right))) {
            return false;
        }
        if (this.edges.contains(edge)) {
            return false;
        }
        this.edges.add(edge);
        return true;
    }

    public void wrapUpCreation() {
        this.getAcceptingStates().parallelStream().forEach(e -> {
            e.setHopsToAccepting(0);
            this.updateHops((StateNode)e);
        });
    }

    public Set<TransitionEdge> getAllOutgoingEdges(StateNode node) {
        return this.edges.parallelStream().filter(edge -> edge.from().equals(node)).collect(Collectors.toSet());
    }

    public void addAllOutgoingEdgesFromOneNodeToOtherNodes(StateNode node, Collection<StateNode> otherNodes) {
        List edgesFromNode = this.edges.parallelStream().filter(e -> node.equals(e.from())).collect(Collectors.toList());
        otherNodes.forEach(otherNode -> edgesFromNode.forEach(edge -> this.createNewEdge(edge.getLabel(), (StateNode)otherNode, edge.getLeft())));
    }

    public StateNode aggregateNodesToOneNode(Set<StateNode> endNodes, StateNode newNode) {
        this.aggregateNodestoOtherNodes(endNodes, Lists.newArrayList((Object[])new StateNode[]{newNode}));
        return newNode;
    }

    public Collection<StateNode> aggregateNodestoOtherNodes(Collection<StateNode> nodesToAggr, Collection<StateNode> startNodes) {
        List edgesToAnyAggrNode = this.edges.parallelStream().filter(e -> nodesToAggr.contains(e.to())).collect(Collectors.toList());
        startNodes.forEach(node -> edgesToAnyAggrNode.forEach(edgeToAggrNode -> this.createNewEdge(edgeToAggrNode.getLabel(), edgeToAggrNode.getLeft(), (StateNode)node)));
        nodesToAggr.removeAll(startNodes);
        this.removeNodesWithAllEdges(nodesToAggr);
        return startNodes;
    }

    private void removeNodesWithAllEdges(Collection<StateNode> nodesToRemove) {
        nodesToRemove.forEach(node -> this.removeNodeWithAllEdges((StateNode)node));
    }

    private void removeNodeWithAllEdges(StateNode node) {
        this.removeAllEdgesHavingNode(node);
        this.nodes.remove(node);
    }

    private void removeAllEdgesHavingNode(StateNode node) {
        List filteredEdges = this.edges.parallelStream().filter(e -> node.equals(e.to()) || node.equals(e.from())).collect(Collectors.toList());
        this.edges.removeAll(filteredEdges);
    }

    private void updateHops(StateNode node) {
        int newPath = node.getHopsToAccepting() + 1;
        this.getAllTransitions().parallelStream().forEach(e -> {
            StateNode theNewRight = e.getLeft();
            if (e.getRight().equals(node) && theNewRight.getHopsToAccepting() > newPath) {
                theNewRight.setHopsToAccepting(newPath);
                this.updateHops(theNewRight);
            }
        });
    }

    public Boolean addNode(StateNode node) {
        return this.nodes.parallelStream().anyMatch(n -> n.getName().equals(node.getName())) ? false : this.nodes.add(node);
    }

    public String toString() {
        StringBuilder graphSB = new StringBuilder();
        for (StateNode node : this.nodes) {
            graphSB.append(node.toString());
            graphSB.append(System.lineSeparator());
        }
        for (TransitionEdge te : this.edges) {
            graphSB.append(te.toString());
            graphSB.append(System.lineSeparator());
        }
        return graphSB.toString();
    }

    public Set<StateNode> getNodes() {
        return this.nodes;
    }

    public List<TransitionEdge> getEdges() {
        return this.edges;
    }

    public TransitionEdge getInitialTransition() {
        return this.edges.get(0);
    }

    @Override
    public Collection<StateNode> getAcceptingStates() {
        return this.nodes.parallelStream().filter(node -> node.getAccepting()).collect(Collectors.toList());
    }

    @Override
    public Collection<TransitionEdge> getAllTransitions() {
        return this.getEdges();
    }
}

