/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import crypto.cryslhandler.CrySLModelReader;
import crypto.exceptions.CryptoAnalysisException;
import crypto.rules.CrySLRule;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CrySLRuleReader {
    private static CrySLModelReader csmr;

    private static CrySLModelReader getReader() {
        if (csmr == null) {
            try {
                csmr = new CrySLModelReader();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return csmr;
    }

    public static CrySLRule readFromSourceFile(File file) throws CryptoAnalysisException {
        return CrySLRuleReader.getReader().readRule(file);
    }

    public static List<CrySLRule> readFromDirectory(File directory) throws CryptoAnalysisException {
        return CrySLRuleReader.readFromDirectory(directory, false);
    }

    public static List<CrySLRule> readFromDirectory(File directory, boolean recursive) throws CryptoAnalysisException {
        HashMap<String, CrySLRule> ruleMap = new HashMap<String, CrySLRule>();
        if (!directory.exists() || !directory.isDirectory()) {
            throw new CryptoAnalysisException("The specified path is not a directory " + directory.getAbsolutePath());
        }
        ArrayList<File> cryptSLFiles = new ArrayList<File>();
        CrySLRuleReader.findCryptSLFiles(directory, recursive, cryptSLFiles);
        CrySLModelReader reader = CrySLRuleReader.getReader();
        for (File file : cryptSLFiles) {
            CrySLRule rule = reader.readRule(file);
            if (rule == null || ruleMap.containsKey(rule.getClassName())) continue;
            ruleMap.put(rule.getClassName(), rule);
        }
        return new ArrayList<CrySLRule>(ruleMap.values());
    }

    public static List<CrySLRule> readFromZipFile(File file) throws CryptoAnalysisException {
        if (!(file.exists() && file.isFile() && file.getName().endsWith(".zip"))) {
            throw new CryptoAnalysisException("The specified path is not a ZIP file " + file.getAbsolutePath());
        }
        HashMap<String, CrySLRule> ruleMap = new HashMap<String, CrySLRule>();
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                CrySLRule rule;
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory() || (rule = CrySLRuleReader.getCrySLRuleFromZipEntry(entry, zip, file)) == null || ruleMap.containsKey(rule.getClassName())) continue;
                ruleMap.put(rule.getClassName(), rule);
            }
        }
        catch (IOException e) {
            throw new CryptoAnalysisException(e.getMessage());
        }
        return new ArrayList<CrySLRule>(ruleMap.values());
    }

    private static void findCryptSLFiles(File directory, boolean recursive, Collection<File> resultCollection) {
        for (File file : directory.listFiles()) {
            if (file.isFile() && file.getName().endsWith(".crysl")) {
                resultCollection.add(file);
            }
            if (!recursive || !file.isDirectory()) continue;
            CrySLRuleReader.findCryptSLFiles(file, recursive, resultCollection);
        }
    }

    private static CrySLRule getCrySLRuleFromZipEntry(ZipEntry entry, ZipFile zip, File zipFile) throws CryptoAnalysisException {
        if (entry.isDirectory() || !entry.getName().endsWith(".crysl")) {
            throw new CryptoAnalysisException("ZIP entry is a directory or not a CrySL file");
        }
        CrySLRule rule = null;
        try {
            String name = CrySLRuleReader.createUniqueZipEntryName(zipFile, entry);
            rule = CrySLRuleReader.getReader().readRule(zip.getInputStream(entry), name);
        }
        catch (IOException | IllegalArgumentException | NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return rule;
    }

    private static String createUniqueZipEntryName(File zipFile, ZipEntry zipEntry) throws NoSuchAlgorithmException, CryptoAnalysisException {
        if (!zipFile.exists() || !zipFile.isFile() || zipEntry == null) {
            throw new CryptoAnalysisException("The specified path is not a ZIP file " + zipFile.getAbsolutePath());
        }
        StringBuilder sb = new StringBuilder();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(zipFile.getAbsolutePath().getBytes());
        String partFileName = CrySLRuleReader.bytesToHex(messageDigest.digest());
        sb.append(partFileName);
        sb.append(File.separator);
        sb.append(zipEntry.getName());
        return sb.toString();
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

