/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLLiteral;
import crypto.rules.CrySLMethod;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CrySLPredicate
extends CrySLLiteral {
    private static final long serialVersionUID = 1L;
    protected final ICrySLPredicateParameter baseObject;
    protected final String predName;
    protected final List<ICrySLPredicateParameter> parameters;
    protected final boolean negated;
    protected final Optional<ISLConstraint> constraint;

    public CrySLPredicate(ICrySLPredicateParameter baseObject, String name, List<ICrySLPredicateParameter> parameters, Boolean negated) {
        this(baseObject, name, parameters, negated, Optional.empty());
    }

    public CrySLPredicate(ICrySLPredicateParameter baseObject, String name, List<ICrySLPredicateParameter> parameters, Boolean negated, ISLConstraint constraint) {
        this(baseObject, name, parameters, negated, Optional.ofNullable(constraint));
    }

    public CrySLPredicate(ICrySLPredicateParameter baseObject, String name, List<ICrySLPredicateParameter> parameters, Boolean negated, Optional<ISLConstraint> constraint) {
        this.baseObject = baseObject;
        this.predName = name;
        this.parameters = parameters;
        this.negated = negated;
        this.constraint = constraint;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.predName == null ? 0 : this.predName.hashCode());
        result = 31 * result + this.getConstraint().hashCode();
        result = 31 * result + this.getParameters().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrySLPredicate)) {
            return false;
        }
        CrySLPredicate other = (CrySLPredicate)obj;
        return this.getPredName().equals(other.getPredName());
    }

    public ICrySLPredicateParameter getBaseObject() {
        return this.baseObject;
    }

    public String getPredName() {
        return this.predName;
    }

    public Optional<ISLConstraint> getConstraint() {
        return this.constraint;
    }

    public List<ICrySLPredicateParameter> getParameters() {
        return this.parameters;
    }

    public Boolean isNegated() {
        return this.negated;
    }

    public String toString() {
        StringBuilder predSB = new StringBuilder();
        if (this.negated) {
            predSB.append("!");
        }
        predSB.append(this.predName);
        predSB.append("(");
        predSB.append(this.parameters.stream().map(x -> x.toString()).collect(Collectors.joining(", ")));
        predSB.append(")");
        return predSB.toString();
    }

    @Override
    public Set<String> getInvolvedVarNames() {
        HashSet<String> varNames = new HashSet<String>();
        if (Arrays.asList("neverTypeOf", "instanceOf").contains(this.predName)) {
            varNames.add(this.parameters.get(0).getName());
        } else {
            for (ICrySLPredicateParameter var : this.parameters) {
                if ("_".equals(var.getName()) || "this".equals(var.getName()) || var instanceof CrySLMethod) continue;
                varNames.add(var.getName());
            }
        }
        if (this.getBaseObject() != null) {
            varNames.add(this.getBaseObject().getName());
        }
        return varNames;
    }

    public CrySLPredicate setNegated(boolean negated) {
        if (negated == this.negated) {
            return this;
        }
        return new CrySLPredicate(this.baseObject, this.predName, this.parameters, negated);
    }

    @Override
    public String getName() {
        if (this.parameters.size() == 1) {
            return this.parameters.get(0).getName();
        }
        return "";
    }
}

