/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import boomerang.results.ForwardBoomerangResults;
import com.google.common.base.Stopwatch;
import crypto.analysis.IAnalysisSeed;
import crypto.reporting.ErrorMarkerListener;
import crypto.reporting.ReportStatistics;
import crypto.rules.CrySLRule;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;
import typestate.TransitionFunction;

public abstract class Reporter
extends ErrorMarkerListener {
    private File outputFolder;
    private List<CrySLRule> rules;
    private boolean includeStatistics;
    protected final ReportStatistics statistics = new ReportStatistics();
    protected final Stopwatch analysisWatch = Stopwatch.createUnstarted();
    protected final Collection<IAnalysisSeed> objects = new HashSet<IAnalysisSeed>();
    protected final Set<SootMethod> dataflowReachableMethods = new HashSet<SootMethod>();

    public Reporter(File outputFolder, String softwareID, List<CrySLRule> rules, long callgraphConstructionTime, boolean includeStatistics) {
        this.outputFolder = outputFolder;
        this.rules = rules;
        this.includeStatistics = includeStatistics;
        this.statistics.setSoftwareID(softwareID);
        this.statistics.setCallgraphTime(callgraphConstructionTime);
        ReachableMethods reachableMethods = Scene.v().getReachableMethods();
        QueueReader listener = reachableMethods.listener();
        HashSet<SootMethod> visited = new HashSet<SootMethod>();
        int callgraphReachableMethodsWithActiveBodies = 0;
        while (listener.hasNext()) {
            MethodOrMethodContext next = (MethodOrMethodContext)listener.next();
            visited.add(next.method());
            if (!next.method().hasActiveBody()) continue;
            ++callgraphReachableMethodsWithActiveBodies;
        }
        this.statistics.setCallgraphReachableMethods(visited.size());
        this.statistics.setCallgraphReachableMethodsWithActiveBodies(callgraphReachableMethodsWithActiveBodies);
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public List<CrySLRule> getRules() {
        return this.rules;
    }

    public boolean includeStatistics() {
        return this.includeStatistics;
    }

    public ReportStatistics getStatistics() {
        return this.statistics;
    }

    public Collection<IAnalysisSeed> getObjects() {
        return this.objects;
    }

    @Override
    public void beforeAnalysis() {
        this.analysisWatch.start();
    }

    @Override
    public void discoveredSeed(IAnalysisSeed object) {
        this.objects.add(object);
    }

    @Override
    public void onSeedFinished(IAnalysisSeed seed, ForwardBoomerangResults<TransitionFunction> forwardResults) {
        this.dataflowReachableMethods.addAll(forwardResults.getStats().getCallVisitedMethods());
    }

    @Override
    public void afterAnalysis() {
        this.analysisWatch.stop();
        this.statistics.setSeedObjectCount(this.objects.size());
        this.statistics.setAnalysisTime(this.analysisWatch.elapsed(TimeUnit.MILLISECONDS));
        this.statistics.setDataflowVisitedMethods(this.dataflowReachableMethods.size());
        this.handleAnalysisResults();
    }

    public abstract void handleAnalysisResults();
}

