/*
 * Decompiled with CFR 0.152.
 */
package crypto.predicates;

import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import crypto.analysis.AlternativeReqPredicate;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.ClassSpecification;
import crypto.analysis.CryptoScanner;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.RequiredCrySLPredicate;
import crypto.analysis.ResultsHandler;
import crypto.analysis.errors.PredicateContradictionError;
import crypto.analysis.errors.RequiredPredicateError;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLRule;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import typestate.TransitionFunction;

public class PredicateHandler {
    private final Table<Statement, Val, Set<EnsuredCrySLPredicate>> existingPredicates = HashBasedTable.create();
    private final Table<Statement, IAnalysisSeed, Set<EnsuredCrySLPredicate>> existingPredicatesObjectBased = HashBasedTable.create();
    private final Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> expectedPredicateObjectBased = HashBasedTable.create();
    private final CryptoScanner cryptoScanner;

    public PredicateHandler(CryptoScanner cryptoScanner) {
        this.cryptoScanner = cryptoScanner;
    }

    public boolean addNewPred(IAnalysisSeed seedObj, Statement statement, Val variable, EnsuredCrySLPredicate ensPred) {
        Set<EnsuredCrySLPredicate> set = this.getExistingPredicates(statement, variable);
        boolean added = set.add(ensPred);
        assert (((Set)this.existingPredicates.get((Object)statement, (Object)variable)).contains(ensPred));
        if (added) {
            this.onPredicateAdded(seedObj, statement, variable, ensPred);
        }
        this.cryptoScanner.getAnalysisListener().onSecureObjectFound(seedObj);
        Set predsObjBased = (Set)this.existingPredicatesObjectBased.get((Object)statement, (Object)seedObj);
        if (predsObjBased == null) {
            predsObjBased = Sets.newHashSet();
        }
        predsObjBased.add(ensPred);
        this.existingPredicatesObjectBased.put((Object)statement, (Object)seedObj, (Object)predsObjBased);
        return added;
    }

    public Set<EnsuredCrySLPredicate> getExistingPredicates(Statement stmt, Val seed) {
        Set set = (Set)this.existingPredicates.get((Object)stmt, (Object)seed);
        if (set == null) {
            set = Sets.newHashSet();
            this.existingPredicates.put((Object)stmt, (Object)seed, (Object)set);
        }
        return set;
    }

    private void onPredicateAdded(IAnalysisSeed seedObj, Statement statement, Val seed, EnsuredCrySLPredicate ensPred) {
        if (statement.isCallsite()) {
            InstanceInvokeExpr iie;
            InvokeExpr ivexpr = ((Stmt)statement.getUnit().get()).getInvokeExpr();
            if (ivexpr instanceof InstanceInvokeExpr) {
                iie = (InstanceInvokeExpr)ivexpr;
                SootMethod callerMethod = statement.getMethod();
                Value base = iie.getBase();
                boolean paramMatch = false;
                for (Value arg : iie.getArgs()) {
                    if (seed.value() == null || !seed.value().equals(arg)) continue;
                    paramMatch = true;
                }
                if (paramMatch) {
                    for (AnalysisSeedWithSpecification secondSeed : Lists.newArrayList(this.cryptoScanner.getAnalysisSeeds())) {
                        secondSeed.registerResultsHandler(new AddPredicateToOtherSeed(statement, base, callerMethod, ensPred, secondSeed));
                    }
                }
            }
            if (ivexpr instanceof StaticInvokeExpr && statement.getUnit().get() instanceof AssignStmt) {
                iie = (StaticInvokeExpr)ivexpr;
                boolean paramMatch = false;
                for (Value arg : iie.getArgs()) {
                    if (seed.value() == null || !seed.value().equals(arg)) continue;
                    paramMatch = true;
                }
                if (paramMatch) {
                    for (AnalysisSeedWithSpecification spec : Lists.newArrayList(this.cryptoScanner.getAnalysisSeeds())) {
                        if (!spec.stmt().equals((Object)statement)) continue;
                        spec.addEnsuredPredicate(ensPred);
                    }
                }
            }
        }
    }

    public void expectPredicate(IAnalysisSeed object, Statement stmt, CrySLPredicate predToBeEnsured) {
        for (Unit succ : this.cryptoScanner.icfg().getSuccsOf((Object)((Unit)stmt.getUnit().get()))) {
            Set set = (Set)this.expectedPredicateObjectBased.get((Object)succ, (Object)object);
            if (set == null) {
                set = Sets.newHashSet();
            }
            set.add(predToBeEnsured);
            this.expectedPredicateObjectBased.put((Object)new Statement((Stmt)succ, stmt.getMethod()), (Object)object, (Object)set);
        }
    }

    public void checkPredicates() {
        this.checkMissingRequiredPredicates();
        this.checkForContradictions();
        this.cryptoScanner.getAnalysisListener().ensuredPredicates(this.existingPredicates, this.expectedPredicateObjectBased, this.computeMissingPredicates());
    }

    private void checkMissingRequiredPredicates() {
        for (AnalysisSeedWithSpecification seed : this.cryptoScanner.getAnalysisSeeds()) {
            Set<ISLConstraint> missingPredicates = seed.getMissingPredicates();
            for (ISLConstraint pred : missingPredicates) {
                if (pred instanceof RequiredCrySLPredicate) {
                    this.reportMissingPred(seed, (RequiredCrySLPredicate)pred);
                    continue;
                }
                if (!(pred instanceof AlternativeReqPredicate)) continue;
                this.reportMissingPred(seed, (AlternativeReqPredicate)pred);
            }
        }
    }

    private void reportMissingPred(AnalysisSeedWithSpecification seed, RequiredCrySLPredicate missingPred) {
        CrySLRule rule = seed.getSpec().getRule();
        if (!rule.getPredicates().parallelStream().anyMatch(e -> missingPred.getPred().getPredName().equals(e.getPredName()) && missingPred.getPred().getParameters().get(0).equals(e.getParameters().get(0)))) {
            for (CallSiteWithParamIndex v : seed.getParameterAnalysis().getAllQuerySites()) {
                if (!missingPred.getPred().getInvolvedVarNames().contains(v.getVarName()) || !v.stmt().equals((Object)missingPred.getLocation())) continue;
                this.cryptoScanner.getAnalysisListener().reportError(seed, new RequiredPredicateError(Arrays.asList(missingPred.getPred()), missingPred.getLocation(), seed.getSpec().getRule(), new CallSiteWithExtractedValue(v, null)));
            }
        }
    }

    private void reportMissingPred(AnalysisSeedWithSpecification seed, AlternativeReqPredicate missingPred) {
        CrySLRule rule = seed.getSpec().getRule();
        if (!rule.getPredicates().parallelStream().anyMatch(e -> missingPred.getAlternatives().stream().anyMatch(e1 -> e1.getPredName().equals(e.getPredName())) && missingPred.getAlternatives().stream().anyMatch(e2 -> e2.getParameters().get(0).equals(e.getParameters().get(0))))) {
            for (CallSiteWithParamIndex v : seed.getParameterAnalysis().getAllQuerySites()) {
                if (!missingPred.getAlternatives().parallelStream().anyMatch(e4 -> e4.getInvolvedVarNames().contains(v.getVarName())) || !v.stmt().equals((Object)missingPred.getLocation())) continue;
                this.cryptoScanner.getAnalysisListener().reportError(seed, new RequiredPredicateError(missingPred.getAlternatives(), missingPred.getLocation(), seed.getSpec().getRule(), new CallSiteWithExtractedValue(v, null)));
            }
        }
    }

    private void checkForContradictions() {
        HashSet<AbstractMap.SimpleEntry<CrySLPredicate, CrySLPredicate>> contradictionPairs = new HashSet<AbstractMap.SimpleEntry<CrySLPredicate, CrySLPredicate>>();
        for (ClassSpecification c : this.cryptoScanner.getClassSpecifictions()) {
            CrySLRule rule = c.getRule();
            for (ISLConstraint cons : rule.getConstraints()) {
                if (!(cons instanceof CrySLPredicate) || !((CrySLPredicate)cons).isNegated().booleanValue()) continue;
                contradictionPairs.add(new AbstractMap.SimpleEntry<CrySLPredicate, CrySLPredicate>(rule.getPredicates().get(0), ((CrySLPredicate)cons).setNegated(false)));
            }
        }
        for (Statement generatingPredicateStmt : this.expectedPredicateObjectBased.rowKeySet()) {
            for (Map.Entry exPredCell : this.existingPredicates.row((Object)generatingPredicateStmt).entrySet()) {
                HashSet<String> preds = new HashSet<String>();
                for (EnsuredCrySLPredicate ensuredCrySLPredicate : (Set)exPredCell.getValue()) {
                    preds.add(ensuredCrySLPredicate.getPredicate().getPredName());
                }
                for (Map.Entry entry : contradictionPairs) {
                    if (!preds.contains(((CrySLPredicate)entry.getKey()).getPredName()) || !preds.contains(((CrySLPredicate)entry.getValue()).getPredName())) continue;
                    this.cryptoScanner.getAnalysisListener().reportError(null, new PredicateContradictionError(generatingPredicateStmt, null, entry));
                }
            }
        }
    }

    private Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> computeMissingPredicates() {
        HashBasedTable res = HashBasedTable.create();
        for (Table.Cell c : this.expectedPredicateObjectBased.cellSet()) {
            Set exPreds = (Set)this.existingPredicatesObjectBased.get(c.getRowKey(), c.getColumnKey());
            if (c.getValue() == null) continue;
            HashSet expectedPreds = new HashSet((Collection)c.getValue());
            if (exPreds == null) {
                exPreds = Sets.newHashSet();
            }
            for (EnsuredCrySLPredicate p : exPreds) {
                expectedPreds.remove(p.getPredicate());
            }
            if (expectedPreds.isEmpty()) continue;
            res.put((Object)((Statement)c.getRowKey()), (Object)((IAnalysisSeed)((Object)c.getColumnKey())), expectedPreds);
        }
        return res;
    }

    private final class AddPredicateToOtherSeed
    implements ResultsHandler {
        private final Statement statement;
        private final Value base;
        private final SootMethod callerMethod;
        private final EnsuredCrySLPredicate ensPred;
        private final AnalysisSeedWithSpecification secondSeed;

        private AddPredicateToOtherSeed(Statement statement, Value base, SootMethod callerMethod, EnsuredCrySLPredicate ensPred, AnalysisSeedWithSpecification secondSeed) {
            this.statement = statement;
            this.base = base;
            this.callerMethod = callerMethod;
            this.ensPred = ensPred;
            this.secondSeed = secondSeed;
        }

        @Override
        public void done(ForwardBoomerangResults<TransitionFunction> results) {
            if (results.asStatementValWeightTable().row((Object)this.statement).containsKey(new Val(this.base, this.callerMethod))) {
                this.secondSeed.addEnsuredPredicate(this.ensPred);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
            result = 31 * result + (this.callerMethod == null ? 0 : this.callerMethod.hashCode());
            result = 31 * result + (this.ensPred == null ? 0 : this.ensPred.hashCode());
            result = 31 * result + (this.secondSeed == null ? 0 : this.secondSeed.hashCode());
            result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddPredicateToOtherSeed other = (AddPredicateToOtherSeed)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
                return false;
            }
            if (this.callerMethod == null ? other.callerMethod != null : !this.callerMethod.equals(other.callerMethod)) {
                return false;
            }
            if (this.ensPred == null ? other.ensPred != null : !this.ensPred.equals(other.ensPred)) {
                return false;
            }
            if (this.secondSeed == null ? other.secondSeed != null : !this.secondSeed.equals((Object)other.secondSeed)) {
                return false;
            }
            return !(this.statement == null ? other.statement != null : !this.statement.equals((Object)other.statement));
        }

        private PredicateHandler getOuterType() {
            return PredicateHandler.this;
        }
    }
}

