/*
 * Decompiled with CFR 0.152.
 */
package crypto.preanalysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import crypto.constraints.ExceptionConstraint;
import crypto.rules.CrySLExceptionConstraint;
import crypto.rules.CrySLRule;
import crypto.typestate.CrySLMethodToSootMethod;
import crypto.typestate.LabeledMatcherTransition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import soot.Body;
import soot.BodyTransformer;
import soot.PackManager;
import soot.PhaseOptions;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Transformer;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.internal.JEqExpr;
import soot.jimple.internal.JIfStmt;

public class ExceptionAwareTransformer
extends BodyTransformer {
    private final SootClass spec;
    private final Multimap<SootMethod, SootClass> exceptions;
    private final Map<SootMethod, SootMethod> lookupCache = new HashMap<SootMethod, SootMethod>();

    public static void setup(List<CrySLRule> rules) {
        for (CrySLRule rule : rules) {
            String phaseName = "jap.etr-" + rule.getClassName();
            PackManager.v().getPack("jap").remove(phaseName);
            PackManager.v().getPack("jap").add(new Transform(phaseName, (Transformer)new ExceptionAwareTransformer(rule)));
            PhaseOptions.v().setPhaseOption(phaseName, "on");
        }
    }

    public ExceptionAwareTransformer(CrySLRule rule) {
        this.exceptions = HashMultimap.create();
        this.spec = Scene.v().getSootClass(rule.getClassName());
        rule.getConstraints().stream().filter(constraint -> constraint instanceof CrySLExceptionConstraint).map(constraint -> (CrySLExceptionConstraint)constraint).forEach(constraint -> CrySLMethodToSootMethod.v().convert(constraint.getMethod()).stream().forEach(method -> this.exceptions.put(method, (Object)Scene.v().getSootClass(constraint.getException().getException()))));
    }

    protected void internalTransform(Body body, String phase, Map<String, String> options) {
        if (body.getMethod().getDeclaringClass().getName().startsWith("java.")) {
            return;
        }
        if (!body.getMethod().getDeclaringClass().isApplicationClass()) {
            return;
        }
        UnitPatchingChain units = body.getUnits();
        units.snapshotIterator().forEachRemaining(unit -> {
            if (!(unit instanceof Stmt)) {
                return;
            }
            if (!((Stmt)unit).containsInvokeExpr()) {
                return;
            }
            SootMethod called = ((Stmt)unit).getInvokeExpr().getMethod();
            if (!called.getDeclaringClass().equals(this.spec)) {
                return;
            }
            this.lookup(called).ifPresent(declared -> {
                for (SootClass exception : this.exceptions.get(declared)) {
                    ExceptionConstraint.getTrap(body, unit, exception).ifPresent(trap -> this.addBranch(units, (Unit)unit, trap.getHandlerUnit()));
                }
            });
        });
    }

    private void addBranch(UnitPatchingChain units, Unit after, Unit to) {
        JEqExpr condition = new JEqExpr((Value)NullConstant.v(), (Value)NullConstant.v());
        units.insertOnEdge((Unit)new JIfStmt((Value)condition, to), after, null);
    }

    private Optional<SootMethod> lookup(SootMethod called) {
        if (this.lookupCache.containsKey(called)) {
            return Optional.of(this.lookupCache.get(called));
        }
        for (SootMethod declared : this.exceptions.keySet()) {
            if (!LabeledMatcherTransition.matches(called, declared)) continue;
            this.lookupCache.put(called, declared);
            return Optional.of(declared);
        }
        return Optional.empty();
    }
}

