/*
 * Decompiled with CFR 0.152.
 */
package crypto.constraints;

import crypto.analysis.errors.ConstraintError;
import crypto.constraints.ConstraintSolver;
import crypto.constraints.EvaluableConstraint;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLObject;
import crypto.rules.CrySLSplitter;
import crypto.rules.CrySLValueConstraint;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ValueConstraint
extends EvaluableConstraint {
    protected ValueConstraint(ISLConstraint origin, ConstraintSolver context) {
        super(origin, context);
    }

    @Override
    public void evaluate() {
        CrySLValueConstraint valCons = (CrySLValueConstraint)this.origin;
        CrySLObject var = valCons.getVar();
        List<Map.Entry<String, CallSiteWithExtractedValue>> vals = this.getValFromVar(var, valCons);
        if (vals.isEmpty()) {
            return;
        }
        for (Map.Entry<String, CallSiteWithExtractedValue> val : vals) {
            List values = valCons.getValueRange().parallelStream().map(e -> e.toLowerCase()).collect(Collectors.toList());
            if (values.contains(val.getKey().toLowerCase())) continue;
            this.errors.add(new ConstraintError(val.getValue(), this.context.getClassSpec().getRule(), this.context.getObject(), valCons));
        }
    }

    private List<Map.Entry<String, CallSiteWithExtractedValue>> getValFromVar(CrySLObject var, ISLConstraint cons) {
        String varName = var.getVarName();
        Map<String, CallSiteWithExtractedValue> valueCollection = this.extractValueAsString(varName, cons);
        ArrayList<Map.Entry<String, CallSiteWithExtractedValue>> vals = new ArrayList<Map.Entry<String, CallSiteWithExtractedValue>>();
        if (valueCollection.isEmpty()) {
            return vals;
        }
        for (Map.Entry<String, CallSiteWithExtractedValue> e : valueCollection.entrySet()) {
            CrySLSplitter splitter = var.getSplitter();
            CallSiteWithExtractedValue location = e.getValue();
            String val = e.getKey();
            if (splitter != null) {
                int ind = splitter.getIndex();
                String splitElement = splitter.getSplitter();
                if (ind > 0) {
                    String[] splits = val.split(splitElement);
                    if (splits.length > ind) {
                        vals.add(new AbstractMap.SimpleEntry<String, CallSiteWithExtractedValue>(splits[ind], location));
                        continue;
                    }
                    vals.add(new AbstractMap.SimpleEntry<String, CallSiteWithExtractedValue>("", location));
                    continue;
                }
                vals.add(new AbstractMap.SimpleEntry<String, CallSiteWithExtractedValue>(val.split(splitElement)[ind], location));
                continue;
            }
            vals.add(new AbstractMap.SimpleEntry<String, CallSiteWithExtractedValue>(val, location));
        }
        return vals;
    }
}

