/*
 * Decompiled with CFR 0.152.
 */
package crypto.constraints;

import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ConstraintError;
import crypto.analysis.errors.ImpreciseValueExtractionError;
import crypto.constraints.ConstraintSolver;
import crypto.constraints.EvaluableConstraint;
import crypto.constraints.PredicateConstraint;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLArithmeticConstraint;
import crypto.rules.CrySLComparisonConstraint;
import crypto.rules.CrySLPredicate;
import java.util.HashMap;
import java.util.Map;

public class ComparisonConstraint
extends EvaluableConstraint {
    protected ComparisonConstraint(ISLConstraint origin, ConstraintSolver context) {
        super(origin, context);
    }

    @Override
    public void evaluate() {
        CrySLComparisonConstraint compConstraint = (CrySLComparisonConstraint)this.origin;
        Map<Integer, CallSiteWithExtractedValue> left = this.evaluate(compConstraint.getLeft());
        Map<Integer, CallSiteWithExtractedValue> right = this.evaluate(compConstraint.getRight());
        for (Map.Entry<Integer, CallSiteWithExtractedValue> entry : right.entrySet()) {
            if (entry.getKey() != Integer.MIN_VALUE) continue;
            this.errors.add(new ConstraintError(entry.getValue(), this.context.getClassSpec().getRule(), this.context.getObject(), compConstraint));
            return;
        }
        for (Map.Entry<Integer, CallSiteWithExtractedValue> leftie : left.entrySet()) {
            if (leftie.getKey() == Integer.MIN_VALUE) {
                this.errors.add(new ConstraintError(leftie.getValue(), this.context.getClassSpec().getRule(), this.context.getObject(), compConstraint));
                return;
            }
            for (Map.Entry<Integer, CallSiteWithExtractedValue> rightie : right.entrySet()) {
                boolean cons = true;
                switch (compConstraint.getOperator()) {
                    case eq: {
                        cons = leftie.getKey().equals(rightie.getKey());
                        break;
                    }
                    case g: {
                        cons = leftie.getKey() > rightie.getKey();
                        break;
                    }
                    case ge: {
                        cons = leftie.getKey() >= rightie.getKey();
                        break;
                    }
                    case l: {
                        cons = leftie.getKey() < rightie.getKey();
                        break;
                    }
                    case le: {
                        cons = leftie.getKey() <= rightie.getKey();
                        break;
                    }
                    case neq: {
                        cons = leftie.getKey() != rightie.getKey();
                        break;
                    }
                    default: {
                        cons = false;
                    }
                }
                if (cons) continue;
                this.errors.add(new ConstraintError(leftie.getValue(), this.context.getClassSpec().getRule(), this.context.getObject(), this.origin));
                return;
            }
        }
    }

    private Map<Integer, CallSiteWithExtractedValue> evaluate(CrySLArithmeticConstraint arith) {
        Map<Integer, CallSiteWithExtractedValue> left = this.extractValueAsInt(arith.getLeft(), arith);
        Map<Integer, CallSiteWithExtractedValue> right = this.extractValueAsInt(arith.getRight(), arith);
        for (Map.Entry<Integer, CallSiteWithExtractedValue> rightie : right.entrySet()) {
            if (rightie.getKey() != Integer.MIN_VALUE) continue;
            return left;
        }
        HashMap<Integer, CallSiteWithExtractedValue> results = new HashMap<Integer, CallSiteWithExtractedValue>();
        for (Map.Entry<Integer, CallSiteWithExtractedValue> leftie : left.entrySet()) {
            if (leftie.getKey() == Integer.MIN_VALUE) {
                return left;
            }
            for (Map.Entry<Integer, CallSiteWithExtractedValue> rightie : right.entrySet()) {
                int sum = 0;
                switch (arith.getOperator()) {
                    case n: {
                        sum = leftie.getKey() - rightie.getKey();
                        break;
                    }
                    case p: {
                        sum = leftie.getKey() + rightie.getKey();
                        break;
                    }
                    case m: {
                        sum = leftie.getKey() % rightie.getKey();
                        break;
                    }
                    default: {
                        sum = 0;
                    }
                }
                if (rightie.getValue() != null) {
                    results.put(sum, rightie.getValue());
                    continue;
                }
                results.put(sum, leftie.getValue());
            }
        }
        return results;
    }

    private Map<Integer, CallSiteWithExtractedValue> extractValueAsInt(ICrySLPredicateParameter par, CrySLArithmeticConstraint arith) {
        if (par instanceof CrySLPredicate) {
            PredicateConstraint predicateConstraint = new PredicateConstraint((CrySLPredicate)par, this.context);
            predicateConstraint.evaluate();
            if (!predicateConstraint.getErrors().isEmpty()) {
                for (AbstractError err : predicateConstraint.getErrors()) {
                    this.errors.add(new ImpreciseValueExtractionError(arith, err.getErrorLocation(), err.getRule()));
                }
                predicateConstraint.errors.clear();
            }
            return new HashMap<Integer, CallSiteWithExtractedValue>();
        }
        return this.extractValueAsInt(par.getName(), (ISLConstraint)arith);
    }

    private Map<Integer, CallSiteWithExtractedValue> extractValueAsInt(String exp, ISLConstraint cons) {
        HashMap<Integer, CallSiteWithExtractedValue> valuesInt = new HashMap<Integer, CallSiteWithExtractedValue>();
        if (exp.equalsIgnoreCase("true")) {
            valuesInt.put(1, null);
            return valuesInt;
        }
        if (exp.equalsIgnoreCase("false")) {
            valuesInt.put(0, null);
            return valuesInt;
        }
        try {
            valuesInt.put(Integer.parseInt(exp), null);
            return valuesInt;
        }
        catch (NumberFormatException ex) {
            Map<String, CallSiteWithExtractedValue> valueCollection = this.extractValueAsString(exp, cons);
            if (valueCollection.isEmpty()) {
                return valuesInt;
            }
            try {
                for (Map.Entry<String, CallSiteWithExtractedValue> value : valueCollection.entrySet()) {
                    if (value.getKey().equals("true")) {
                        valuesInt.put(1, value.getValue());
                        continue;
                    }
                    if (value.getKey().equals("false")) {
                        valuesInt.put(0, value.getValue());
                        continue;
                    }
                    valuesInt.put(Integer.parseInt(value.getKey()), value.getValue());
                }
            }
            catch (NumberFormatException ex1) {
                LOGGER.error("An exception occured when extracting value as Integer.", (Throwable)ex1);
            }
            return valuesInt;
        }
    }
}

