/*
 * Decompiled with CFR 0.152.
 */
package crypto.typestate;

import boomerang.WeightedForwardQuery;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import crypto.typestate.SootBasedStateMachineGraph;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.RefType;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;
import wpds.impl.Weight;

public class FiniteStateMachineToTypestateChangeFunction
extends TypeStateMachineWeightFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(FiniteStateMachineToTypestateChangeFunction.class);
    private RefType analyzedType = null;
    private SootBasedStateMachineGraph fsm;

    public FiniteStateMachineToTypestateChangeFunction(SootBasedStateMachineGraph fsm) {
        for (MatcherTransition trans : fsm.getAllTransitions()) {
            this.addTransition(trans);
        }
        for (SootMethod m : fsm.initialTransitonLabel()) {
            if (!m.isConstructor()) continue;
            if (this.analyzedType == null) {
                this.analyzedType = m.getDeclaringClass().getType();
                continue;
            }
            if (this.analyzedType == m.getDeclaringClass().getType()) continue;
            LOGGER.error("The type of m.getDeclaringClass() does not appear to be consistent across fsm.initialTransitonLabel().");
        }
        this.fsm = fsm;
    }

    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod method, Unit unit) {
        HashSet<WeightedForwardQuery<TransitionFunction>> out = new HashSet<WeightedForwardQuery<TransitionFunction>>();
        if (!(unit instanceof Stmt) || !((Stmt)unit).containsInvokeExpr()) {
            return out;
        }
        InvokeExpr invokeExpr = ((Stmt)unit).getInvokeExpr();
        SootMethod calledMethod = invokeExpr.getMethod();
        if (!this.fsm.initialTransitonLabel().contains(calledMethod)) {
            return out;
        }
        if (calledMethod.isStatic()) {
            if (unit instanceof AssignStmt) {
                AssignStmt stmt = (AssignStmt)unit;
                out.add(this.createQuery((Unit)stmt, method, new AllocVal(stmt.getLeftOp(), method, stmt.getRightOp(), new Statement((Stmt)stmt, method))));
            }
        } else if (invokeExpr instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)invokeExpr;
            out.add(this.createQuery(unit, method, new AllocVal(iie.getBase(), method, (Value)iie, new Statement((Stmt)unit, method))));
        }
        return out;
    }

    private WeightedForwardQuery<TransitionFunction> createQuery(Unit unit, SootMethod method, AllocVal allocVal) {
        return new WeightedForwardQuery(new Statement((Stmt)unit, method), (Val)allocVal, (Weight)this.fsm.getInitialWeight(new Statement((Stmt)unit, method)));
    }

    protected State initialState() {
        throw new UnsupportedOperationException("This method should never be called.");
    }
}

