/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import java.io.Serializable;

public class StateNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private Boolean init = false;
    private Boolean accepting = false;
    private int hopsToAccepting = Integer.MAX_VALUE;

    public StateNode(String _name) {
        this.name = _name;
    }

    public StateNode(String _name, Boolean _init) {
        this(_name);
        this.init = _init;
    }

    public StateNode(String _name, Boolean _init, Boolean _accepting) {
        this(_name, _init);
        this.accepting = _accepting;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getInit() {
        return this.init;
    }

    public Boolean getAccepting() {
        return this.accepting;
    }

    public void setAccepting(Boolean _accepting) {
        this.accepting = _accepting;
    }

    public String toString() {
        StringBuilder nodeSB = new StringBuilder();
        nodeSB.append("Name: ");
        nodeSB.append(this.name);
        nodeSB.append(" (");
        if (!this.accepting.booleanValue()) {
            nodeSB.append(this.hopsToAccepting + "hops to ");
        }
        nodeSB.append("accepting)");
        return nodeSB.toString();
    }

    public boolean isErrorState() {
        return this.accepting == false;
    }

    public boolean isInitialState() {
        return this.init;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accepting == null ? 0 : this.accepting.hashCode());
        result = 31 * result + (this.init == null ? 0 : this.init.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateNode other = (StateNode)obj;
        if (this.accepting == null ? other.accepting != null : !this.accepting.equals(other.accepting)) {
            return false;
        }
        if (this.init == null ? other.init != null : !this.init.equals(other.init)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void setHopsToAccepting(int hops) {
        this.hopsToAccepting = hops;
    }

    public int getHopsToAccepting() {
        return this.hopsToAccepting;
    }
}

