/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLLiteral;
import crypto.rules.CrySLMethod;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CrySLPredicate
extends CrySLLiteral
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ICrySLPredicateParameter baseObject;
    protected final String predName;
    protected final List<ICrySLPredicateParameter> parameters;
    protected final boolean negated;
    protected final ISLConstraint optConstraint;

    public CrySLPredicate(ICrySLPredicateParameter baseObject, String name, List<ICrySLPredicateParameter> variables, Boolean not) {
        this(baseObject, name, variables, not, null);
    }

    public CrySLPredicate(ICrySLPredicateParameter baseObject, String name, List<ICrySLPredicateParameter> variables, Boolean not, ISLConstraint constraint) {
        this.baseObject = baseObject;
        this.predName = name;
        this.parameters = variables;
        this.negated = not;
        this.optConstraint = constraint;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.predName == null ? 0 : this.predName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrySLPredicate)) {
            return false;
        }
        CrySLPredicate other = (CrySLPredicate)obj;
        return !(this.predName == null ? other.predName != null : !this.predName.equals(other.predName));
    }

    public ICrySLPredicateParameter getBaseObject() {
        return this.baseObject;
    }

    public String getPredName() {
        return this.predName;
    }

    public ISLConstraint getConstraint() {
        return this.optConstraint;
    }

    public List<ICrySLPredicateParameter> getParameters() {
        return this.parameters;
    }

    public Boolean isNegated() {
        return this.negated;
    }

    public String toString() {
        StringBuilder predSB = new StringBuilder();
        if (this.negated) {
            predSB.append("!");
        }
        predSB.append(this.predName);
        predSB.append("(");
        for (ICrySLPredicateParameter parameter : this.parameters) {
            predSB.append(parameter);
            predSB.append(",");
        }
        predSB.reverse().deleteCharAt(0).reverse();
        predSB.append(")");
        return predSB.toString();
    }

    @Override
    public Set<String> getInvolvedVarNames() {
        HashSet<String> varNames = new HashSet<String>();
        if (Arrays.asList("neverTypeOf", "instanceOf").contains(this.predName)) {
            varNames.add(this.parameters.get(0).getName());
        } else {
            for (ICrySLPredicateParameter var : this.parameters) {
                if ("_".equals(var.getName()) || "this".equals(var.getName()) || var instanceof CrySLMethod) continue;
                varNames.add(var.getName());
            }
        }
        if (this.getBaseObject() != null) {
            varNames.add(this.getBaseObject().getName());
        }
        return varNames;
    }

    public CrySLPredicate setNegated(boolean negated) {
        if (negated == this.negated) {
            return this;
        }
        return new CrySLPredicate(this.baseObject, this.predName, this.parameters, negated);
    }

    @Override
    public String getName() {
        if (this.parameters.size() == 1) {
            return this.parameters.get(0).getName();
        }
        return "";
    }
}

