/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import crypto.interfaces.ICrySLPredicateParameter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class CrySLMethod
implements Serializable,
ICrySLPredicateParameter {
    private static final long serialVersionUID = 1L;
    private final String methodName;
    private final Map.Entry<String, String> retObject;
    private final List<Map.Entry<String, String>> parameters;
    private final List<Boolean> backward;

    public CrySLMethod(String methName, List<Map.Entry<String, String>> pars, List<Boolean> backw, Map.Entry<String, String> returnObject) {
        this.methodName = methName;
        this.parameters = pars;
        this.backward = backw;
        this.retObject = returnObject;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getShortMethodName() {
        return this.methodName.substring(this.methodName.lastIndexOf(".") + 1);
    }

    public List<Map.Entry<String, String>> getParameters() {
        return this.parameters;
    }

    public List<Boolean> getBackward() {
        return this.backward;
    }

    public Map.Entry<String, String> getRetObject() {
        return this.retObject;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        StringBuilder stmntBuilder = new StringBuilder();
        String returnValue = this.retObject.getKey();
        if (!"_".equals(returnValue)) {
            stmntBuilder.append(returnValue);
            stmntBuilder.append(" = ");
        }
        stmntBuilder.append(this.methodName);
        stmntBuilder.append("(");
        for (Map.Entry<String, String> par : this.parameters) {
            stmntBuilder.append(" ");
            stmntBuilder.append(par.getKey());
        }
        stmntBuilder.append(");");
        return stmntBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backward == null ? 0 : this.backward.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrySLMethod)) {
            return false;
        }
        CrySLMethod other = (CrySLMethod)obj;
        return this.getMethodName().equals(other.getMethodName()) && this.parameters.equals(other.parameters);
    }
}

