/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import crypto.rules.CrySLArithmeticConstraint;
import crypto.rules.CrySLLiteral;
import java.io.Serializable;
import java.util.Set;

public class CrySLComparisonConstraint
extends CrySLLiteral
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CompOp operator;
    private CrySLArithmeticConstraint left;
    private CrySLArithmeticConstraint right;

    public CrySLComparisonConstraint(CrySLArithmeticConstraint l, CrySLArithmeticConstraint r, CompOp op) {
        this.left = l;
        this.right = r;
        this.operator = op;
    }

    public String toString() {
        return this.left + " " + this.getOperatorString() + " " + this.right;
    }

    private String getOperatorString() {
        switch (this.operator) {
            case l: {
                return "<";
            }
            case le: {
                return "<";
            }
            case g: {
                return ">";
            }
            case ge: {
                return ">=";
            }
            case neq: {
                return "!=";
            }
        }
        return "=";
    }

    public CompOp getOperator() {
        return this.operator;
    }

    public CrySLArithmeticConstraint getLeft() {
        return this.left;
    }

    public CrySLArithmeticConstraint getRight() {
        return this.right;
    }

    @Override
    public Set<String> getInvolvedVarNames() {
        Set<String> varNames = this.left.getInvolvedVarNames();
        varNames.addAll(this.right.getInvolvedVarNames());
        return varNames;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public static enum CompOp {
        l,
        g,
        le,
        ge,
        eq,
        neq;

    }
}

