/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import com.google.common.collect.Table;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.AbstractError;
import crypto.reporting.ErrorMarkerListener;
import crypto.reporting.ReporterHelper;
import crypto.rules.CrySLRule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Printer;
import soot.SootClass;
import soot.SootMethod;
import soot.util.EscapedWriter;

public class TXTReporter
extends ErrorMarkerListener {
    private File outputFolder;
    private List<CrySLRule> rules;
    private Collection<IAnalysisSeed> objects = new HashSet<IAnalysisSeed>();
    private static final Logger LOG = LoggerFactory.getLogger(TXTReporter.class);
    private String analysisReport;
    private static final String REPORT_NAME = "CryptoAnalysis-Report.txt";

    public TXTReporter(String reportDir, List<CrySLRule> rules) {
        this.outputFolder = reportDir != null ? new File(reportDir) : new File(System.getProperty("user.dir"));
        this.rules = rules;
    }

    @Override
    public void discoveredSeed(IAnalysisSeed object) {
        this.objects.add(object);
    }

    @Override
    public void afterAnalysis() {
        this.analysisReport = ReporterHelper.generateReport(this.rules, this.objects, this.secureObjects, (Table<SootClass, SootMethod, Set<AbstractError>>)this.errorMarkers, this.errorMarkerCount);
        try {
            FileWriter writer = new FileWriter(this.outputFolder + File.separator + REPORT_NAME);
            writer.write(this.analysisReport);
            writer.close();
            for (SootClass c : this.errorMarkers.rowKeySet()) {
                FileOutputStream streamOut = new FileOutputStream(new File(this.outputFolder + File.separator + c.toString() + ".jimple"));
                PrintWriter writerOut = new PrintWriter((Writer)new EscapedWriter((Writer)new OutputStreamWriter(streamOut)));
                Printer.v().printTo(c, writerOut);
                writerOut.flush();
                streamOut.close();
                writerOut.close();
            }
            LOG.info("Text Report generated to file : " + this.outputFolder.getAbsolutePath() + File.separator + REPORT_NAME);
        }
        catch (IOException e) {
            LOG.error("Could not write to file " + this.outputFolder.getAbsolutePath() + File.separator + REPORT_NAME, (Throwable)e);
        }
    }
}

