/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.AbstractError;
import crypto.reporting.ErrorMarkerListener;
import crypto.reporting.SARIFHelper;
import crypto.reporting.SourceCodeLocater;
import crypto.rules.CrySLRule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.Stmt;

public class SARIFReporter
extends ErrorMarkerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SARIFReporter.class);
    private File outputFolder;
    private Collection<IAnalysisSeed> objects = new HashSet<IAnalysisSeed>();
    private JSONObject files = new JSONObject();
    private JSONObject resources = new JSONObject();
    private JSONObject rules = new JSONObject();
    private JSONArray results = new JSONArray();
    private SARIFHelper sarifHelper;
    private Map<String, Integer> errorCountMap;
    private static final String REPORT_NAME = "CryptoAnalysis-Report.json";

    public SARIFReporter(String reportDir, List<CrySLRule> rules) {
        this.outputFolder = reportDir != null ? new File(reportDir) : new File(System.getProperty("user.dir"));
        this.sarifHelper = new SARIFHelper();
        this.errorCountMap = new HashMap<String, Integer>();
        this.initializeMap();
    }

    public SARIFReporter(String string, List<CrySLRule> rules, SourceCodeLocater sourceLocater) {
        this(string, rules);
        this.sarifHelper = new SARIFHelper(sourceLocater);
    }

    private void initializeMap() {
        this.errorCountMap.put("ConstraintError", 0);
        this.errorCountMap.put("NeverTypeOfError", 0);
        this.errorCountMap.put("HardCodedError", 0);
        this.errorCountMap.put("InstanceOfError", 0);
        this.errorCountMap.put("ForbiddenMethodError", 0);
        this.errorCountMap.put("ImpreciseValueExtractionError", 0);
        this.errorCountMap.put("TypestateError", 0);
        this.errorCountMap.put("RequiredPredicateError", 0);
        this.errorCountMap.put("IncompleteOperationError", 0);
    }

    private void addFile(SootClass c) {
        String filePath = this.sarifHelper.getFileName(c);
        JSONObject mimeType = new JSONObject();
        mimeType.put((Object)"mimeType", (Object)"text/java");
        this.files.put((Object)filePath, (Object)mimeType);
    }

    private String addRules(String errorType) {
        String finalErrorType = errorType;
        if (this.rules.containsKey((Object)errorType)) {
            int count = this.errorCountMap.get(errorType);
            finalErrorType = errorType.concat("-".concat(Integer.toString(++count)));
            this.errorCountMap.put(errorType, count);
        }
        JSONObject ruleInfo = new JSONObject();
        JSONObject fullDescription = new JSONObject();
        fullDescription.put((Object)"text", (Object)this.sarifHelper.getRuleDescription(errorType));
        ruleInfo.put((Object)"id", (Object)errorType);
        ruleInfo.put((Object)"fullDescription", (Object)fullDescription);
        this.rules.put((Object)finalErrorType, (Object)ruleInfo);
        return finalErrorType;
    }

    private void addResults(String errorType, SootClass c, String methodName, int lineNumber, String text, String richText) {
        JSONObject result = new JSONObject();
        String finalErrorType = this.addRules(errorType);
        result.put((Object)"ruleId", (Object)finalErrorType);
        result.put((Object)"message", (Object)this.sarifHelper.getMessage(text, richText));
        result.put((Object)"locations", (Object)this.sarifHelper.getLocations(c, methodName, lineNumber));
        this.results.add((Object)result);
    }

    private JSONObject makeSARIF() {
        this.resources.put((Object)"rules", (Object)this.rules);
        JSONObject sarif = new JSONObject();
        sarif.put((Object)"sarifVersion", (Object)"2.0.0");
        JSONArray runs = new JSONArray();
        JSONObject run = new JSONObject();
        run.put((Object)"tool", (Object)this.sarifHelper.getToolInfo());
        run.put((Object)"files", (Object)this.files);
        run.put((Object)"results", (Object)this.results);
        run.put((Object)"resources", (Object)this.resources);
        runs.add((Object)run);
        sarif.put((Object)"runs", (Object)runs);
        return sarif;
    }

    @Override
    public void discoveredSeed(IAnalysisSeed object) {
        this.objects.add(object);
    }

    @Override
    public void afterAnalysis() {
        for (SootClass c : this.errorMarkers.rowKeySet()) {
            this.addFile(c);
            for (Map.Entry e : this.errorMarkers.row((Object)c).entrySet()) {
                for (AbstractError marker : (Set)e.getValue()) {
                    String errorType = marker.getClass().getSimpleName();
                    String richText = String.format("%s violating CrySL rule for %s.", marker.getClass().getSimpleName(), marker.getRule().getClassName());
                    String text = String.format("%s.", marker.toErrorMarkerString());
                    int lineNumber = ((Stmt)marker.getErrorLocation().getUnit().get()).getJavaSourceStartLineNumber();
                    this.addResults(errorType, c, ((SootMethod)e.getKey()).getName(), lineNumber, text, richText);
                }
            }
        }
        JSONObject sarif = this.makeSARIF();
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
            writer.writeValue(Paths.get(this.outputFolder + File.separator + REPORT_NAME, new String[0]).toFile(), (Object)sarif);
            LOGGER.info("SARIF Report generated to file : " + this.outputFolder + File.separator + REPORT_NAME);
        }
        catch (IOException e) {
            LOGGER.error("Could not write to file: " + this.outputFolder.getAbsolutePath() + File.separator + REPORT_NAME, (Throwable)e);
        }
    }
}

