/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import com.google.common.collect.Table;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.AbstractError;
import crypto.reporting.ErrorMarkerListener;
import crypto.reporting.ReporterHelper;
import crypto.rules.CrySLRule;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;

public class CommandLineReporter
extends ErrorMarkerListener {
    private File outputFolder;
    private List<CrySLRule> rules;
    private Collection<IAnalysisSeed> objects = new HashSet<IAnalysisSeed>();
    private String analysisReport;

    public CommandLineReporter(String reportDir, List<CrySLRule> rules) {
        this.outputFolder = reportDir != null ? new File(reportDir) : null;
        this.rules = rules;
    }

    public CommandLineReporter(List<CrySLRule> rules) {
        this.rules = rules;
    }

    @Override
    public void discoveredSeed(IAnalysisSeed object) {
        this.objects.add(object);
    }

    @Override
    public void afterAnalysis() {
        this.analysisReport = ReporterHelper.generateReport(this.rules, this.objects, this.secureObjects, (Table<SootClass, SootMethod, Set<AbstractError>>)this.errorMarkers, this.errorMarkerCount);
        System.out.println(this.analysisReport);
    }
}

