/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import boomerang.BackwardQuery;
import boomerang.Query;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import crypto.analysis.AnalysisSeedWithSpecification;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ConstraintError;
import crypto.analysis.errors.ForbiddenMethodError;
import crypto.analysis.errors.HardCodedError;
import crypto.analysis.errors.ImpreciseValueExtractionError;
import crypto.analysis.errors.IncompleteOperationError;
import crypto.analysis.errors.NeverTypeOfError;
import crypto.analysis.errors.RequiredPredicateError;
import crypto.analysis.errors.TypestateError;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.interfaces.ISLConstraint;
import crypto.reporting.ErrorMarkerListener;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLRule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;

public class CSVReporter
extends ErrorMarkerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVReporter.class);
    private static final String CSV_SEPARATOR = ";";
    private Set<AbstractError> errors = Sets.newHashSet();
    private int seeds;
    private List<String> headers = Lists.newArrayList();
    private Map<String, String> headersToValues = Maps.newHashMap();
    private List<CrySLRule> rules;
    private Set<SootMethod> dataflowReachableMethods = Sets.newHashSet();
    private Stopwatch analysisTime = Stopwatch.createUnstarted();
    private File reportDir;
    private static final String REPORT_NAME = "CryptoAnalysis-Report.csv";

    public CSVReporter(String reportDir, String softwareId, List<CrySLRule> rules, long callGraphConstructionTime) {
        this.reportDir = reportDir != null ? new File(reportDir) : new File(System.getProperty("user.dir"));
        this.rules = rules;
        ReachableMethods reachableMethods = Scene.v().getReachableMethods();
        QueueReader listener = reachableMethods.listener();
        HashSet visited = Sets.newHashSet();
        int callgraphReachableMethodsWithActiveBodies = 0;
        while (listener.hasNext()) {
            MethodOrMethodContext next = (MethodOrMethodContext)listener.next();
            visited.add(next.method());
            if (!next.method().hasActiveBody()) continue;
            ++callgraphReachableMethodsWithActiveBodies;
        }
        int callgraphReachableMethods = visited.size();
        for (Headers h : Headers.values()) {
            this.headers.add(h.toString());
        }
        this.put(Headers.SoftwareID, (Object)softwareId);
        this.put(Headers.CallGraphTime_ms, (Object)callGraphConstructionTime);
        this.put(Headers.CallGraphReachableMethods, (Object)callgraphReachableMethods);
        this.put(Headers.CallGraphReachableMethods_ActiveBodies, (Object)callgraphReachableMethodsWithActiveBodies);
        this.addDynamicHeader(ConstraintError.class.getSimpleName());
        this.addDynamicHeader(NeverTypeOfError.class.getSimpleName());
        this.addDynamicHeader(HardCodedError.class.getSimpleName());
        this.addDynamicHeader(TypestateError.class.getSimpleName());
        this.addDynamicHeader(RequiredPredicateError.class.getSimpleName());
        this.addDynamicHeader(IncompleteOperationError.class.getSimpleName());
        this.addDynamicHeader(ImpreciseValueExtractionError.class.getSimpleName());
        this.addDynamicHeader(ForbiddenMethodError.class.getSimpleName());
    }

    private void addDynamicHeader(String name) {
        this.headers.add(name + "_sum");
        for (CrySLRule r : this.rules) {
            this.headers.add(name + "_" + r.getClassName());
        }
    }

    @Override
    public void beforeAnalysis() {
        this.analysisTime.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterAnalysis() {
        this.analysisTime.stop();
        this.put(Headers.DataflowVisitedMethod, (Object)this.dataflowReachableMethods.size());
        this.put(Headers.CryptoAnalysisTime_ms, (Object)this.analysisTime.elapsed(TimeUnit.MILLISECONDS));
        this.put(Headers.SeedObjectCount, (Object)this.seeds);
        HashBasedTable errorTable = HashBasedTable.create();
        for (AbstractError err : this.errors) {
            Integer n;
            void var4_7;
            Integer n2 = (Integer)errorTable.get(err.getClass(), (Object)err.getRule());
            if (n2 == null) {
                Integer n3 = 0;
            }
            void var5_12 = var4_7;
            Integer n4 = n = Integer.valueOf(var4_7.intValue() + 1);
            errorTable.put(err.getClass(), (Object)err.getRule(), (Object)n);
        }
        for (Table.Cell c : errorTable.cellSet()) {
            this.put(((Class)c.getRowKey()).getSimpleName() + "_" + ((CrySLRule)c.getColumnKey()).getClassName(), c.getValue());
        }
        HashMap errorsAccumulated = Maps.newHashMap();
        for (Table.Cell cell : errorTable.cellSet()) {
            Integer integer = (Integer)errorsAccumulated.get(cell.getRowKey());
            if (integer == null) {
                integer = 0;
            }
            integer = integer + (Integer)cell.getValue();
            errorsAccumulated.put((Class)cell.getRowKey(), integer);
        }
        for (Map.Entry entry : errorsAccumulated.entrySet()) {
            this.put(((Class)entry.getKey()).getSimpleName() + "_sum", entry.getValue());
        }
        this.writeToFile();
    }

    private void writeToFile() {
        try {
            FileWriter writer = new FileWriter(this.reportDir + File.separator + REPORT_NAME);
            writer.write(Joiner.on((String)CSV_SEPARATOR).join(this.headers) + "\n");
            ArrayList line = Lists.newArrayList();
            for (String h : this.headers) {
                String string = this.headersToValues.get(h);
                if (string == null) {
                    string = "";
                }
                line.add(string);
            }
            writer.write(Joiner.on((String)CSV_SEPARATOR).join((Iterable)line) + "\n");
            writer.write("\nCryptoAnalysis\n");
            String version = this.getClass().getPackage().getImplementationVersion();
            if (version == null) {
                version = "Version is not known";
            }
            writer.write(version);
            writer.close();
            LOGGER.info("CSV Report generated to file : " + this.reportDir.getAbsolutePath() + File.separator + REPORT_NAME);
        }
        catch (IOException e) {
            LOGGER.error("Could not write to " + this.reportDir.getAbsolutePath() + File.separator + REPORT_NAME, (Throwable)e);
        }
    }

    private void put(String key, Object val) {
        if (!this.headers.contains(key)) {
            LOGGER.error("Did not create a header to this value " + key);
        } else if (val == null) {
            LOGGER.info(key + " is null");
        } else {
            this.headersToValues.put(key, val.toString());
        }
    }

    private void put(Headers key, Object val) {
        this.put(key.toString(), val);
    }

    @Override
    public void beforeConstraintCheck(AnalysisSeedWithSpecification analysisSeedWithSpecification) {
    }

    @Override
    public void afterConstraintCheck(AnalysisSeedWithSpecification analysisSeedWithSpecification) {
    }

    @Override
    public void beforePredicateCheck(AnalysisSeedWithSpecification analysisSeedWithSpecification) {
    }

    @Override
    public void afterPredicateCheck(AnalysisSeedWithSpecification analysisSeedWithSpecification) {
    }

    @Override
    public void seedStarted(IAnalysisSeed analysisSeedWithSpecification) {
    }

    @Override
    public void boomerangQueryStarted(Query seed, BackwardQuery q) {
    }

    @Override
    public void boomerangQueryFinished(Query seed, BackwardQuery q) {
    }

    @Override
    public void reportError(AbstractError error) {
        this.errors.add(error);
    }

    @Override
    public void ensuredPredicates(Table<Statement, Val, Set<EnsuredCrySLPredicate>> existingPredicates, Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> expectedPredicates, Table<Statement, IAnalysisSeed, Set<CrySLPredicate>> missingPredicates) {
    }

    @Override
    public void checkedConstraints(AnalysisSeedWithSpecification analysisSeedWithSpecification, Collection<ISLConstraint> relConstraints) {
    }

    @Override
    public void onSeedTimeout(Node<Statement, Val> seed) {
    }

    @Override
    public void onSeedFinished(IAnalysisSeed seed, ForwardBoomerangResults<TransitionFunction> forwardResults) {
        this.dataflowReachableMethods.addAll(forwardResults.getStats().getCallVisitedMethods());
    }

    @Override
    public void collectedValues(AnalysisSeedWithSpecification seed, Multimap<CallSiteWithParamIndex, ExtractedValue> collectedValues) {
    }

    @Override
    public void discoveredSeed(IAnalysisSeed curr) {
        ++this.seeds;
    }

    @Override
    public void onSecureObjectFound(IAnalysisSeed analysisObject) {
    }

    @Override
    public void addProgress(int processedSeeds, int workListsize) {
    }

    private static enum Headers {
        SoftwareID,
        SeedObjectCount,
        CallGraphTime_ms,
        CryptoAnalysisTime_ms,
        CallGraphReachableMethods,
        CallGraphReachableMethods_ActiveBodies,
        DataflowVisitedMethod;

    }
}

