/*
 * Decompiled with CFR 0.152.
 */
package crypto.extractparameter;

import boomerang.BackwardQuery;
import boomerang.Boomerang;
import boomerang.BoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.BackwardBoomerangResults;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import crypto.analysis.CryptoScanner;
import crypto.boomerang.CogniCryptIntAndStringBoomerangOptions;
import crypto.extractparameter.CallSiteWithParamIndex;
import crypto.extractparameter.ExtractedValue;
import crypto.rules.CrySLMethod;
import crypto.typestate.CrySLMethodToSootMethod;
import crypto.typestate.LabeledMatcherTransition;
import crypto.typestate.SootBasedStateMachineGraph;
import heros.utilities.DefaultValueMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.Stmt;
import sync.pds.solver.nodes.Node;
import typestate.finiteautomata.MatcherTransition;
import wpds.impl.Weight;

public class ExtractParameterAnalysis {
    private Map<Statement, SootMethod> allCallsOnObject;
    private Collection<LabeledMatcherTransition> events = Sets.newHashSet();
    private CryptoScanner cryptoScanner;
    private Multimap<CallSiteWithParamIndex, ExtractedValue> collectedValues = HashMultimap.create();
    private Collection<CallSiteWithParamIndex> querySites = Sets.newHashSet();
    private Multimap<CallSiteWithParamIndex, Type> propagatedTypes = HashMultimap.create();
    private DefaultValueMap<AdditionalBoomerangQuery, AdditionalBoomerangQuery> additionalBoomerangQuery = new DefaultValueMap<AdditionalBoomerangQuery, AdditionalBoomerangQuery>(){

        protected AdditionalBoomerangQuery createItem(AdditionalBoomerangQuery key) {
            return key;
        }
    };

    public ExtractParameterAnalysis(CryptoScanner cryptoScanner, Map<Statement, SootMethod> allCallsOnObject, SootBasedStateMachineGraph fsm) {
        this.cryptoScanner = cryptoScanner;
        this.allCallsOnObject = allCallsOnObject;
        for (MatcherTransition m : fsm.getAllTransitions()) {
            if (!(m instanceof LabeledMatcherTransition)) continue;
            this.events.add((LabeledMatcherTransition)m);
        }
    }

    public void run() {
        for (Map.Entry<Statement, SootMethod> callSiteWithCallee : this.allCallsOnObject.entrySet()) {
            Statement callSite = callSiteWithCallee.getKey();
            SootMethod declaredCallee = callSiteWithCallee.getValue();
            if (!callSite.isCallsite()) continue;
            for (LabeledMatcherTransition e : this.events) {
                if (!e.matches(declaredCallee)) continue;
                this.injectQueryAtCallSite(e.label(), callSite);
            }
        }
        for (AdditionalBoomerangQuery q : this.additionalBoomerangQuery.keySet()) {
            q.solve();
        }
    }

    public Multimap<CallSiteWithParamIndex, ExtractedValue> getCollectedValues() {
        return this.collectedValues;
    }

    public Multimap<CallSiteWithParamIndex, Type> getPropagatedTypes() {
        return this.propagatedTypes;
    }

    public Collection<CallSiteWithParamIndex> getAllQuerySites() {
        return this.querySites;
    }

    private void injectQueryAtCallSite(List<CrySLMethod> list, Statement callSite) {
        if (!callSite.isCallsite()) {
            return;
        }
        for (CrySLMethod matchingDescriptor : list) {
            for (SootMethod m : CrySLMethodToSootMethod.v().convert(matchingDescriptor)) {
                SootMethod method;
                if (!m.equals(method = ((Stmt)callSite.getUnit().get()).getInvokeExpr().getMethod())) continue;
                int index = 0;
                for (Map.Entry<String, String> param : matchingDescriptor.getParameters()) {
                    Type parameterType;
                    if (!param.getKey().equals("_") && (parameterType = method.getParameterType(index)).toString().equals(param.getValue())) {
                        this.addQueryAtCallsite(param.getKey(), callSite, index);
                    }
                    ++index;
                }
            }
        }
    }

    public void addQueryAtCallsite(String varNameInSpecification, Statement stmt, int index) {
        if (!stmt.isCallsite()) {
            return;
        }
        Value parameter = ((Stmt)stmt.getUnit().get()).getInvokeExpr().getArg(index);
        if (!(parameter instanceof Local)) {
            Val parameterVal = new Val(parameter, stmt.getMethod());
            CallSiteWithParamIndex cs = new CallSiteWithParamIndex(stmt, parameterVal, index, varNameInSpecification);
            HashSet dataFlowPath = Sets.newHashSet();
            dataFlowPath.add(new Node((Object)stmt, (Object)parameterVal));
            this.collectedValues.put((Object)cs, (Object)new ExtractedValue(stmt, parameter, dataFlowPath));
            this.querySites.add(cs);
            return;
        }
        Val queryVal = new Val((Value)((Local)parameter), stmt.getMethod());
        for (Unit pred : this.cryptoScanner.icfg().getPredsOf((Object)((Unit)stmt.getUnit().get()))) {
            AdditionalBoomerangQuery query = (AdditionalBoomerangQuery)((Object)this.additionalBoomerangQuery.getOrCreate((Object)new AdditionalBoomerangQuery(new Statement((Stmt)pred, stmt.getMethod()), queryVal)));
            final CallSiteWithParamIndex callSiteWithParamIndex = new CallSiteWithParamIndex(stmt, queryVal, index, varNameInSpecification);
            this.querySites.add(callSiteWithParamIndex);
            query.addListener(new QueryListener(){

                @Override
                public void solved(AdditionalBoomerangQuery q, BackwardBoomerangResults<Weight.NoWeight> res) {
                    ExtractParameterAnalysis.this.propagatedTypes.putAll((Object)callSiteWithParamIndex, (Iterable)res.getPropagationType());
                    for (ForwardQuery v : res.getAllocationSites().keySet()) {
                        String calledMethodSignature;
                        ExtractedValue extractedValue = null;
                        if (v.var() instanceof AllocVal) {
                            AllocVal allocVal = (AllocVal)v.var();
                            extractedValue = new ExtractedValue(allocVal.allocationStatement(), allocVal.allocationValue(), res.getDataFlowPath(v));
                        } else {
                            extractedValue = new ExtractedValue(v.stmt(), v.var().value(), res.getDataFlowPath(v));
                        }
                        ExtractParameterAnalysis.this.collectedValues.put((Object)callSiteWithParamIndex, (Object)extractedValue);
                        if (!v.stmt().isCallsite() || !(calledMethodSignature = ((Stmt)v.stmt().getUnit().get()).getInvokeExpr().getMethod().getSignature()).equals("<java.lang.String: char[] toCharArray()>")) continue;
                        ExtractParameterAnalysis.this.propagatedTypes.put((Object)callSiteWithParamIndex, (Object)Scene.v().getType("java.lang.String"));
                    }
                }
            });
        }
    }

    public void addAdditionalBoomerangQuery(AdditionalBoomerangQuery q, QueryListener listener) {
        AdditionalBoomerangQuery query = (AdditionalBoomerangQuery)((Object)this.additionalBoomerangQuery.getOrCreate((Object)q));
        query.addListener(listener);
    }

    private static interface QueryListener {
        public void solved(AdditionalBoomerangQuery var1, BackwardBoomerangResults<Weight.NoWeight> var2);
    }

    public class AdditionalBoomerangQuery
    extends BackwardQuery {
        protected boolean solved;
        private List<QueryListener> listeners;
        private BackwardBoomerangResults<Weight.NoWeight> res;

        public AdditionalBoomerangQuery(Statement stmt, Val variable) {
            super(stmt, variable);
            this.listeners = Lists.newLinkedList();
        }

        public void solve() {
            Boomerang boomerang = new Boomerang((BoomerangOptions)new CogniCryptIntAndStringBoomerangOptions()){

                public ObservableICFG<Unit, SootMethod> icfg() {
                    return ExtractParameterAnalysis.this.cryptoScanner.icfg();
                }
            };
            this.res = boomerang.solve((BackwardQuery)this);
            for (QueryListener l : Lists.newLinkedList(this.listeners)) {
                l.solved(this, this.res);
            }
            this.solved = true;
        }

        public void addListener(QueryListener q) {
            if (this.solved) {
                q.solved(this, this.res);
                return;
            }
            this.listeners.add(q);
        }
    }
}

